/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.wizard;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.settings.AbstractImportFromExternalSystemControl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalProjectImportBuilder<C extends AbstractImportFromExternalSystemControl>
extends ProjectImportBuilder<DataNode<ProjectData>> {
    private static final Logger LOG = Logger.getInstance((String)("#" + AbstractExternalProjectImportBuilder.class.getName()));
    @NotNull
    private final ProjectDataManager myProjectDataManager;
    @NotNull
    private final C myControl;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    private DataNode<ProjectData> myExternalProjectNode;

    public AbstractExternalProjectImportBuilder(@NotNull ProjectDataManager projectDataManager, @NotNull C control, @NotNull ProjectSystemId externalSystemId) {
        if (projectDataManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDataManager", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "<init>"));
        }
        if (control == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "<init>"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "<init>"));
        }
        this.myProjectDataManager = projectDataManager;
        this.myControl = control;
        this.myExternalSystemId = externalSystemId;
    }

    @Override
    public List<DataNode<ProjectData>> getList() {
        return Arrays.asList(this.myExternalProjectNode);
    }

    @Override
    public boolean isMarked(DataNode<ProjectData> element) {
        return true;
    }

    @Override
    public void setList(List<DataNode<ProjectData>> gradleProjects) {
    }

    @Override
    public void setOpenProjectSettingsAfter(boolean on) {
    }

    @NotNull
    public C getControl(@Nullable Project currentProject) {
        ((AbstractImportFromExternalSystemControl)this.myControl).setCurrentProject(currentProject);
        C c = this.myControl;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "getControl"));
        }
        return c;
    }

    public void prepare(@NotNull WizardContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "prepare"));
        }
        ((AbstractImportFromExternalSystemControl)this.myControl).reset();
        String pathToUse = this.getFileToImport();
        ((AbstractImportFromExternalSystemControl)this.myControl).setLinkedProjectPath(pathToUse);
        this.doPrepare(context);
    }

    protected abstract void doPrepare(@NotNull WizardContext var1);

    @Override
    public List<Module> commit(final Project project, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
        final DataNode<ProjectData> externalProjectNode = this.getExternalProjectNode();
        if (externalProjectNode != null) {
            this.beforeCommit(externalProjectNode, project);
        }
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)AbstractExternalProjectImportBuilder.this.myExternalSystemId);
                final ExternalProjectSettings projectSettings = AbstractExternalProjectImportBuilder.this.getCurrentExternalProjectSettings();
                HashSet projects = ContainerUtilRt.newHashSet((Iterable)systemSettings.getLinkedProjectsSettings());
                projects.remove(projectSettings);
                projects.add(projectSettings);
                systemSettings.copyFrom(AbstractExternalProjectImportBuilder.this.myControl.getSystemSettings());
                systemSettings.setLinkedProjectsSettings((Collection)projects);
                if (externalProjectNode != null) {
                    ExternalSystemUtil.ensureToolWindowInitialized(project, AbstractExternalProjectImportBuilder.this.myExternalSystemId);
                    ExternalSystemApiUtil.executeProjectChangeAction((DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

                        public void execute() {
                            ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractExternalProjectImportBuilder.this.myProjectDataManager.importData(externalProjectNode.getKey(), Collections.singleton(externalProjectNode), project, true);
                                    AbstractExternalProjectImportBuilder.this.myExternalProjectNode = null;
                                }
                            });
                        }
                    });
                    Runnable resolveDependenciesTask = new Runnable(){

                        @Override
                        public void run() {
                            String progressText = ExternalSystemBundle.message((String)"progress.resolve.libraries", (Object[])new Object[]{AbstractExternalProjectImportBuilder.this.myExternalSystemId.getReadableName()});
                            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, progressText, false){

                                public void run(@NotNull ProgressIndicator indicator) {
                                    if (indicator == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder$1$2$1", "run"));
                                    }
                                    if (project.isDisposed()) {
                                        return;
                                    }
                                    ExternalSystemResolveProjectTask task = new ExternalSystemResolveProjectTask(AbstractExternalProjectImportBuilder.this.myExternalSystemId, project, projectSettings.getExternalProjectPath(), false);
                                    task.execute(indicator, (ExternalSystemTaskNotificationListener[])ExternalSystemTaskNotificationListener.EP_NAME.getExtensions());
                                    DataNode<ProjectData> projectWithResolvedLibraries = task.getExternalProject();
                                    if (projectWithResolvedLibraries == null) {
                                        return;
                                    }
                                    AbstractExternalProjectImportBuilder.this.setupLibraries((DataNode<ProjectData>)projectWithResolvedLibraries, project);
                                }
                            });
                        }
                    };
                    UIUtil.invokeLaterIfNeeded((Runnable)resolveDependenciesTask);
                }
            }
        });
        return Collections.emptyList();
    }

    @NotNull
    private ExternalProjectSettings getCurrentExternalProjectSettings() {
        ExternalProjectSettings result = ((AbstractImportFromExternalSystemControl)this.myControl).getProjectSettings().clone();
        File externalProjectConfigFile = this.getExternalProjectConfigToUse(new File(result.getExternalProjectPath()));
        String linkedProjectPath = FileUtil.toCanonicalPath((String)externalProjectConfigFile.getPath());
        assert (linkedProjectPath != null);
        result.setExternalProjectPath(linkedProjectPath);
        ExternalProjectSettings externalProjectSettings = result;
        if (externalProjectSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "getCurrentExternalProjectSettings"));
        }
        return externalProjectSettings;
    }

    protected abstract void beforeCommit(@NotNull DataNode<ProjectData> var1, @NotNull Project var2);

    private void setupLibraries(final @NotNull DataNode<ProjectData> projectWithResolvedLibraries, final Project project) {
        if (projectWithResolvedLibraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectWithResolvedLibraries", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "setupLibraries"));
        }
        ExternalSystemApiUtil.executeProjectChangeAction((DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (ExternalSystemApiUtil.isNewProjectConstruction()) {
                            LibraryTable projectLibraryTable = ProjectLibraryTable.getInstance(project);
                            if (projectLibraryTable == null) {
                                LOG.warn("Can't resolve external dependencies of the target gradle project (" + project + "). Reason: project " + "library table is undefined");
                                return;
                            }
                            LibraryTable.ModifiableModel model = projectLibraryTable.getModifiableModel();
                            try {
                                for (Library library : model.getLibraries()) {
                                    model.removeLibrary(library);
                                }
                            }
                            finally {
                                model.commit();
                            }
                        }
                        AbstractExternalProjectImportBuilder.this.myProjectDataManager.importData(Collections.singletonList(projectWithResolvedLibraries), project, false);
                    }
                });
            }
        });
    }

    @Nullable
    private File getProjectFile() {
        String path = ((AbstractImportFromExternalSystemControl)this.myControl).getProjectSettings().getExternalProjectPath();
        return path == null ? null : new File(path);
    }

    public void ensureProjectIsDefined(@NotNull WizardContext wizardContext) throws ConfigurationException {
        if (wizardContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardContext", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "ensureProjectIsDefined"));
        }
        final String externalSystemName = this.myExternalSystemId.getReadableName();
        File projectFile = this.getProjectFile();
        if (projectFile == null) {
            throw new ConfigurationException(ExternalSystemBundle.message((String)"error.project.undefined", (Object[])new Object[0]));
        }
        projectFile = this.getExternalProjectConfigToUse(projectFile);
        final Ref error = new Ref();
        final ExternalProjectRefreshCallback callback = new ExternalProjectRefreshCallback(){

            @Override
            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                AbstractExternalProjectImportBuilder.this.myExternalProjectNode = externalProject;
            }

            @Override
            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder$3", "onFailure"));
                }
                if (!StringUtil.isEmpty((String)errorDetails)) {
                    LOG.warn(errorDetails);
                }
                error.set((Object)new ConfigurationException(ExternalSystemBundle.message((String)"error.resolve.with.reason", (Object[])new Object[]{errorMessage}), ExternalSystemBundle.message((String)"error.resolve.generic", (Object[])new Object[0])));
            }
        };
        final Project project = this.getProject(wizardContext);
        File finalProjectFile = projectFile;
        final String externalProjectPath = FileUtil.toCanonicalPath((String)finalProjectFile.getAbsolutePath());
        final Ref exRef = new Ref();
        this.executeAndRestoreDefaultProjectSettings(project, new Runnable(){

            @Override
            public void run() {
                try {
                    ExternalSystemUtil.refreshProject(project, AbstractExternalProjectImportBuilder.this.myExternalSystemId, externalProjectPath, callback, true, ProgressExecutionMode.MODAL_SYNC);
                }
                catch (IllegalArgumentException e) {
                    exRef.set((Object)new ConfigurationException(e.getMessage(), ExternalSystemBundle.message((String)"error.cannot.parse.project", (Object[])new Object[]{externalSystemName})));
                }
            }
        });
        ConfigurationException ex = (ConfigurationException)((Object)exRef.get());
        if (ex != null) {
            throw ex;
        }
        if (this.myExternalProjectNode == null) {
            ConfigurationException exception = (ConfigurationException)((Object)error.get());
            if (exception != null) {
                throw exception;
            }
        } else {
            this.applyProjectSettings(wizardContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndRestoreDefaultProjectSettings(@NotNull Project project, @NotNull Runnable task) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "executeAndRestoreDefaultProjectSettings"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "executeAndRestoreDefaultProjectSettings"));
        }
        if (!project.isDefault()) {
            task.run();
            return;
        }
        AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)this.myExternalSystemId);
        Object systemStateToRestore = null;
        if (systemSettings instanceof PersistentStateComponent) {
            systemStateToRestore = ((PersistentStateComponent)systemSettings).getState();
        }
        systemSettings.copyFrom(((AbstractImportFromExternalSystemControl)this.myControl).getSystemSettings());
        Collection projectSettingsToRestore = systemSettings.getLinkedProjectsSettings();
        systemSettings.setLinkedProjectsSettings(Collections.singleton(this.getCurrentExternalProjectSettings()));
        try {
            task.run();
        }
        finally {
            if (systemStateToRestore != null) {
                ((PersistentStateComponent)systemSettings).loadState(systemStateToRestore);
            } else {
                systemSettings.setLinkedProjectsSettings(projectSettingsToRestore);
            }
        }
    }

    @NotNull
    protected abstract File getExternalProjectConfigToUse(@NotNull File var1);

    @Nullable
    public DataNode<ProjectData> getExternalProjectNode() {
        return this.myExternalProjectNode;
    }

    public void applyProjectSettings(@NotNull WizardContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "applyProjectSettings"));
        }
        if (this.myExternalProjectNode == null) {
            assert (false);
            return;
        }
        context.setProjectName(((ProjectData)this.myExternalProjectNode.getData()).getInternalName());
        context.setProjectFileDirectory(((ProjectData)this.myExternalProjectNode.getData()).getIdeProjectFileDirectoryPath());
        this.applyExtraSettings(context);
    }

    protected abstract void applyExtraSettings(@NotNull WizardContext var1);

    @NotNull
    public Project getProject(@NotNull WizardContext wizardContext) {
        if (wizardContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardContext", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "getProject"));
        }
        Project result = wizardContext.getProject();
        if (result == null) {
            result = ProjectManager.getInstance().getDefaultProject();
        }
        Project project = result;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder", "getProject"));
        }
        return project;
    }
}

