/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.Weighted;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SortedConfigurableGroup
extends SearchableConfigurable.Parent.Abstract
implements SearchableConfigurable,
Weighted,
ConfigurableGroup,
Configurable.NoScroll {
    private ArrayList<Configurable> myList = new ArrayList();
    private final String myGroupId;
    private String myDisplayName;
    private int myWeight;

    private SortedConfigurableGroup(String groupId) {
        this.myGroupId = groupId;
    }

    public SortedConfigurableGroup(Project project, Configurable ... configurables) {
        this.myGroupId = "root";
        HashMap<String, SortedConfigurableGroup> map = new HashMap<String, SortedConfigurableGroup>();
        map.put(this.myGroupId, this);
        for (Configurable configurable : configurables) {
            SortedConfigurableGroup composite;
            String groupId = null;
            if (configurable instanceof ConfigurableWrapper) {
                ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
                groupId = wrapper.getExtensionPoint().groupId;
            }
            if ((composite = (SortedConfigurableGroup)map.get(groupId)) == null) {
                composite = new SortedConfigurableGroup(groupId);
                map.put(groupId, composite);
            }
            composite.myList.add(configurable);
        }
        this.add(70, (SortedConfigurableGroup)map.remove("appearance"));
        this.add(60, (SortedConfigurableGroup)map.remove("editor"));
        SortedConfigurableGroup projectGroup = (SortedConfigurableGroup)map.remove("project");
        if (projectGroup != null && project != null && !project.isDefault()) {
            projectGroup.myDisplayName = StringUtil.first((String)OptionsBundle.message((String)"configurable.group.project.named.settings.display.name", (Object[])new Object[]{project.getName()}), (int)30, (boolean)true);
        }
        this.add(40, projectGroup);
        SortedConfigurableGroup build = (SortedConfigurableGroup)map.remove("build");
        if (build == null) {
            build = (SortedConfigurableGroup)map.remove("build.tools");
        } else {
            build.add(1000, (SortedConfigurableGroup)map.remove("build.tools"));
        }
        this.add(30, build);
        this.add(20, (SortedConfigurableGroup)map.remove("language"));
        this.add(10, (SortedConfigurableGroup)map.remove("tools"));
        this.add(-10, (SortedConfigurableGroup)map.remove(null));
        if (1 < map.size()) {
            for (SortedConfigurableGroup group : map.values()) {
                if (this == group) continue;
                group.myDisplayName = OptionsBundle.message((String)"configurable.group.category.named.settings.display.name", (Object[])new Object[]{group.myGroupId});
                this.add(0, group);
            }
        }
    }

    private void add(int weight, SortedConfigurableGroup configurable) {
        if (configurable != null) {
            configurable.myWeight = weight;
            this.myList.add((Configurable)configurable);
        }
    }

    protected Configurable[] buildConfigurables() {
        Collections.sort(this.myList, COMPARATOR);
        Configurable[] result = (Configurable[])ArrayUtil.toObjectArray(this.myList, Configurable.class);
        this.myList.clear();
        this.myList = null;
        return result;
    }

    @NotNull
    public String getId() {
        String string = "configurable.group." + this.myGroupId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/SortedConfigurableGroup", "getId"));
        }
        return string;
    }

    @Nullable
    public String getHelpTopic() {
        return "configurable.group." + this.myGroupId + ".help.topic";
    }

    @Override
    public int getWeight() {
        return this.myWeight;
    }

    @Nls
    public String getDisplayName() {
        return this.myDisplayName != null ? this.myDisplayName : OptionsBundle.message((String)("configurable.group." + this.myGroupId + ".settings.display.name"), (Object[])new Object[0]);
    }

    public String getShortName() {
        return this.getDisplayName();
    }
}

