/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.popup.PopupFactoryImpl;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public abstract class WelcomePopupAction
extends AnAction
implements DumbAware {
    protected abstract void fillActions(DefaultActionGroup var1);

    protected abstract String getTextForEmpty();

    protected abstract String getCaption();

    protected abstract boolean isSilentlyChooseSingleOption();

    public void actionPerformed(AnActionEvent e) {
        this.showPopup(e);
    }

    private void showPopup(AnActionEvent e) {
        final DefaultActionGroup group = new DefaultActionGroup();
        this.fillActions(group);
        if (group.getChildrenCount() == 1 && this.isSilentlyChooseSingleOption()) {
            AnAction[] children = group.getChildren(null);
            children[0].actionPerformed(e);
            return;
        }
        if (group.getChildrenCount() == 0) {
            group.add(new AnAction(this.getTextForEmpty()){

                public void actionPerformed(AnActionEvent e) {
                    group.setPopup(false);
                }
            });
        }
        DataContext context = e.getDataContext();
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(this.getCaption(), (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
        JComponent contextComponent = null;
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent instanceof MouseEvent && inputEvent.getSource() instanceof JComponent) {
            contextComponent = (JComponent)inputEvent.getSource();
        }
        this.showPopup(context, popup, contextComponent);
    }

    protected void showPopup(DataContext context, ListPopup popup, JComponent contextComponent) {
        Component focusedComponent;
        Component component = focusedComponent = contextComponent != null ? contextComponent : (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
        if (focusedComponent != null) {
            if (popup instanceof PopupFactoryImpl.ActionGroupPopup && focusedComponent instanceof JLabel) {
                ((PopupFactoryImpl.ActionGroupPopup)popup).showUnderneathOfLabel((JLabel)focusedComponent);
            } else {
                popup.showUnderneathOf(focusedComponent);
            }
        } else {
            focusedComponent = WindowManagerEx.getInstanceEx().getFocusedComponent((Project)null);
            Rectangle r = WindowManagerEx.getInstanceEx().getScreenBounds();
            int x = r.x + r.width / 2;
            int y = r.y + r.height / 2;
            Point point = new Point(x, y);
            SwingUtilities.convertPointToScreen(point, focusedComponent.getParent());
            popup.showInScreenCoordinates((Component)focusedComponent.getParent(), point);
        }
    }
}

