/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeShortNamesCache
extends PsiShortNamesCache {
    private final PsiShortNamesCache[] myCaches;

    public CompositeShortNamesCache(Project project) {
        this.myCaches = project.isDefault() ? new PsiShortNamesCache[]{} : (PsiShortNamesCache[])project.getExtensions(PsiShortNamesCache.EP_NAME);
    }

    @NotNull
    public PsiFile[] getFilesByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/CompositeShortNamesCache", "getFilesByName"));
        }
        Merger<PsiFile> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiFile[] classes = cache.getFilesByName(name);
            if (classes.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiFile>();
            }
            merger.add(classes);
        }
        PsiFile[] result = merger == null ? null : (PsiFile[])merger.getResult();
        PsiFile[] psiFileArray = result != null ? result : PsiFile.EMPTY_ARRAY;
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/CompositeShortNamesCache", "getFilesByName"));
        }
        return psiFileArray;
    }

    @NotNull
    public String[] getAllFileNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.myCaches) {
            merger.add(cache.getAllFileNames());
        }
        String[] result = (String[])merger.getResult();
        String[] stringArray = result != null ? result : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/CompositeShortNamesCache", "getAllFileNames"));
        }
        return stringArray;
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/CompositeShortNamesCache", "getClassesByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/CompositeShortNamesCache", "getClassesByName"));
        }
        Merger<PsiClass> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiClass[] classes = cache.getClassesByName(name, scope);
            if (classes.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiClass>();
            }
            merger.add(classes);
        }
        PsiClass[] result = merger == null ? null : (PsiClass[])merger.getResult();
        PsiClass[] psiClassArray = result != null ? result : PsiClass.EMPTY_ARRAY;
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/CompositeShortNamesCache", "getClassesByName"));
        }
        return psiClassArray;
    }

    @NotNull
    public String[] getAllClassNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.myCaches) {
            String[] names = cache.getAllClassNames();
            merger.add(names);
        }
        String[] result = (String[])merger.getResult();
        String[] stringArray = result != null ? result : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/CompositeShortNamesCache", "getAllClassNames"));
        }
        return stringArray;
    }

    public boolean processAllClassNames(Processor<String> processor) {
        CommonProcessors.UniqueProcessor uniqueProcessor = new CommonProcessors.UniqueProcessor(processor);
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processAllClassNames((Processor)uniqueProcessor)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllClassNames(Processor<String> processor, GlobalSearchScope scope, IdFilter filter) {
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processAllClassNames(processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllMethodNames(Processor<String> processor, GlobalSearchScope scope, IdFilter filter) {
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processAllMethodNames(processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllFieldNames(Processor<String> processor, GlobalSearchScope scope, IdFilter filter) {
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processAllFieldNames(processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public void getAllClassNames(@NotNull HashSet<String> dest) {
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/intellij/psi/impl/CompositeShortNamesCache", "getAllClassNames"));
        }
        for (PsiShortNamesCache cache : this.myCaches) {
            cache.getAllClassNames(dest);
        }
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/CompositeShortNamesCache", "getMethodsByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/CompositeShortNamesCache", "getMethodsByName"));
        }
        Merger<PsiMethod> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiMethod[] methods = cache.getMethodsByName(name, scope);
            if (methods.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiMethod>();
            }
            merger.add(methods);
        }
        PsiMethod[] result = merger == null ? null : (PsiMethod[])merger.getResult();
        PsiMethod[] psiMethodArray = result == null ? PsiMethod.EMPTY_ARRAY : result;
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/CompositeShortNamesCache", "getMethodsByName"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/CompositeShortNamesCache", "getMethodsByNameIfNotMoreThan"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/CompositeShortNamesCache", "getMethodsByNameIfNotMoreThan"));
        }
        Merger<PsiMethod> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiMethod[] methods = cache.getMethodsByNameIfNotMoreThan(name, scope, maxCount);
            if (methods.length == maxCount) {
                if (methods == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/CompositeShortNamesCache", "getMethodsByNameIfNotMoreThan"));
                }
                return methods;
            }
            if (methods.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiMethod>();
            }
            merger.add(methods);
        }
        PsiMethod[] result = merger == null ? null : (PsiMethod[])merger.getResult();
        PsiMethod[] psiMethodArray = result == null ? PsiMethod.EMPTY_ARRAY : result;
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/CompositeShortNamesCache", "getMethodsByNameIfNotMoreThan"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiField[] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/CompositeShortNamesCache", "getFieldsByNameIfNotMoreThan"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/CompositeShortNamesCache", "getFieldsByNameIfNotMoreThan"));
        }
        Merger<PsiField> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiField[] fields = cache.getFieldsByNameIfNotMoreThan(name, scope, maxCount);
            if (fields.length == maxCount) {
                if (fields == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/CompositeShortNamesCache", "getFieldsByNameIfNotMoreThan"));
                }
                return fields;
            }
            if (fields.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiField>();
            }
            merger.add(fields);
        }
        PsiField[] result = merger == null ? null : (PsiField[])merger.getResult();
        PsiField[] psiFieldArray = result == null ? PsiField.EMPTY_ARRAY : result;
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/CompositeShortNamesCache", "getFieldsByNameIfNotMoreThan"));
        }
        return psiFieldArray;
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiMethod> processor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/CompositeShortNamesCache", "processMethodsWithName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/CompositeShortNamesCache", "processMethodsWithName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/CompositeShortNamesCache", "processMethodsWithName"));
        }
        return this.processMethodsWithName(name, processor, scope, null);
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull Processor<? super PsiMethod> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/CompositeShortNamesCache", "processMethodsWithName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/CompositeShortNamesCache", "processMethodsWithName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/CompositeShortNamesCache", "processMethodsWithName"));
        }
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processMethodsWithName(name, processor, scope, idFilter)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String[] getAllMethodNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.myCaches) {
            merger.add(cache.getAllMethodNames());
        }
        String[] result = (String[])merger.getResult();
        String[] stringArray = result != null ? result : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/CompositeShortNamesCache", "getAllMethodNames"));
        }
        return stringArray;
    }

    public void getAllMethodNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/psi/impl/CompositeShortNamesCache", "getAllMethodNames"));
        }
        for (PsiShortNamesCache cache : this.myCaches) {
            cache.getAllMethodNames(set);
        }
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/CompositeShortNamesCache", "getFieldsByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/CompositeShortNamesCache", "getFieldsByName"));
        }
        Merger<PsiField> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiField[] classes = cache.getFieldsByName(name, scope);
            if (classes.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiField>();
            }
            merger.add(classes);
        }
        PsiField[] result = merger == null ? null : (PsiField[])merger.getResult();
        PsiField[] psiFieldArray = result == null ? PsiField.EMPTY_ARRAY : result;
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/CompositeShortNamesCache", "getFieldsByName"));
        }
        return psiFieldArray;
    }

    @NotNull
    public String[] getAllFieldNames() {
        Merger<String> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            String[] classes = cache.getAllFieldNames();
            if (classes.length == 0) continue;
            if (merger == null) {
                merger = new Merger<String>();
            }
            merger.add(classes);
        }
        String[] result = merger == null ? null : (String[])merger.getResult();
        String[] stringArray = result == null ? ArrayUtil.EMPTY_STRING_ARRAY : result;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/CompositeShortNamesCache", "getAllFieldNames"));
        }
        return stringArray;
    }

    public void getAllFieldNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/psi/impl/CompositeShortNamesCache", "getAllFieldNames"));
        }
        for (PsiShortNamesCache cache : this.myCaches) {
            cache.getAllFieldNames(set);
        }
    }

    public boolean processFieldsWithName(@NotNull String key, @NotNull Processor<? super PsiField> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/CompositeShortNamesCache", "processFieldsWithName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/CompositeShortNamesCache", "processFieldsWithName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/CompositeShortNamesCache", "processFieldsWithName"));
        }
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processFieldsWithName(key, processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processClassesWithName(@NotNull String key, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/CompositeShortNamesCache", "processClassesWithName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/CompositeShortNamesCache", "processClassesWithName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/CompositeShortNamesCache", "processClassesWithName"));
        }
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processClassesWithName(key, processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Composite cache: " + Arrays.asList(this.myCaches);
    }

    private static class Merger<T> {
        private T[] mySingleItem;
        private Set<T> myAllItems;

        private Merger() {
        }

        public void add(@NotNull T[] items) {
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/psi/impl/CompositeShortNamesCache$Merger", "add"));
            }
            if (items.length == 0) {
                return;
            }
            if (this.mySingleItem == null) {
                this.mySingleItem = items;
                return;
            }
            if (this.myAllItems == null) {
                Object[] elements = this.mySingleItem;
                this.myAllItems = (Set)ContainerUtil.addAll((Collection)new THashSet(elements.length), (Object[])elements);
            }
            ContainerUtil.addAll(this.myAllItems, (Object[])items);
        }

        public T[] getResult() {
            if (this.myAllItems == null) {
                return this.mySingleItem;
            }
            return this.myAllItems.toArray(this.mySingleItem);
        }
    }
}

