/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.smartPointers.AnchorElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfoFactory;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnchorElementInfoFactory
implements SmartPointerElementInfoFactory {
    @Override
    @Nullable
    public SmartPointerElementInfo createElementInfo(@NotNull PsiElement element) {
        PsiElement anchor;
        PsiFileWithStubSupport stubFile;
        StubTree stubTree;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/AnchorElementInfoFactory", "createElementInfo"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (element instanceof StubBasedPsiElement && containingFile instanceof PsiFileWithStubSupport && (stubTree = (stubFile = (PsiFileWithStubSupport)containingFile).getStubTree()) != null) {
            StubBasedPsiElement stubPsi = (StubBasedPsiElement)element;
            int stubId = PsiAnchor.calcStubIndex(stubPsi);
            IStubElementType myStubElementType = stubPsi.getElementType();
            if (stubId != -1) {
                return new AnchorElementInfo(element, stubFile, stubId, myStubElementType);
            }
        }
        if ((anchor = AnchorElementInfoFactory.getAnchor(element)) != null) {
            return new AnchorElementInfo(anchor, containingFile);
        }
        return null;
    }

    @Nullable
    static PsiElement getAnchor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/AnchorElementInfoFactory", "getAnchor"));
        }
        PsiUtilCore.ensureValid((PsiElement)element);
        PsiElement anchor = null;
        for (SmartPointerAnchorProvider provider : (SmartPointerAnchorProvider[])SmartPointerAnchorProvider.EP_NAME.getExtensions()) {
            anchor = provider.getAnchor(element);
            if (anchor == null || !anchor.isPhysical()) continue;
            return anchor;
        }
        return anchor;
    }
}

