/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JRadioButton;

public class RadioUpDownListener
extends KeyAdapter {
    private final JRadioButton[] myRadioButtons;

    public RadioUpDownListener(JRadioButton ... radioButtons) {
        this.myRadioButtons = radioButtons;
        for (JRadioButton radioButton : radioButtons) {
            radioButton.addKeyListener(this);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int selected = this.getSelected();
        if (selected != -1) {
            if (e.getKeyCode() == 38) {
                this.up(selected, selected);
            } else if (e.getKeyCode() == 40) {
                this.down(selected, selected);
            }
        }
    }

    private void down(int selected, int stop) {
        int newIdx = selected + 1;
        if (newIdx > this.myRadioButtons.length - 1) {
            newIdx = 0;
        }
        if (!RadioUpDownListener.click(this.myRadioButtons[newIdx]) && stop != newIdx) {
            this.down(newIdx, selected);
        }
    }

    private void up(int selected, int stop) {
        int newIdx = selected - 1;
        if (newIdx < 0) {
            newIdx = this.myRadioButtons.length - 1;
        }
        if (!RadioUpDownListener.click(this.myRadioButtons[newIdx]) && stop != newIdx) {
            this.up(newIdx, selected);
        }
    }

    private int getSelected() {
        for (int i = 0; i < this.myRadioButtons.length; ++i) {
            if (!this.myRadioButtons[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    private static boolean click(JRadioButton button) {
        if (button.isEnabled() && button.isVisible()) {
            button.requestFocus();
            button.doClick();
            return true;
        }
        return false;
    }
}

