/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace;

import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ReplaceOptions
implements JDOMExternalizable {
    private Map<String, ReplacementVariableDefinition> variableDefs;
    private String replacement = "";
    private boolean toShortenFQN;
    private boolean myToReformatAccordingToStyle;
    private boolean myToUseStaticImport = false;
    private MatchOptions matchOptions = new MatchOptions();
    @NonNls
    private static final String REFORMAT_ATTR_NAME = "reformatAccordingToStyle";
    @NonNls
    private static final String REPLACEMENT_ATTR_NAME = "replacement";
    @NonNls
    private static final String SHORTEN_FQN_ATTR_NAME = "shortenFQN";
    @NonNls
    private static final String USE_STATIC_IMPORT_ATTR_NAME = "useStaticImport";
    @NonNls
    private static final String VARIABLE_DEFINITION_TAG_NAME = "variableDefinition";

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public boolean isToShortenFQN() {
        return this.toShortenFQN;
    }

    public void setToShortenFQN(boolean shortedFQN) {
        this.toShortenFQN = shortedFQN;
    }

    public boolean isToReformatAccordingToStyle() {
        return this.myToReformatAccordingToStyle;
    }

    public MatchOptions getMatchOptions() {
        return this.matchOptions;
    }

    public void setMatchOptions(MatchOptions matchOptions) {
        this.matchOptions = matchOptions;
    }

    public void setToReformatAccordingToStyle(boolean reformatAccordingToStyle) {
        this.myToReformatAccordingToStyle = reformatAccordingToStyle;
    }

    public boolean isToUseStaticImport() {
        return this.myToUseStaticImport;
    }

    public void setToUseStaticImport(boolean useStaticImport) {
        this.myToUseStaticImport = useStaticImport;
    }

    public void readExternal(Element element) {
        this.matchOptions.readExternal(element);
        Attribute attribute = element.getAttribute(REFORMAT_ATTR_NAME);
        try {
            this.myToReformatAccordingToStyle = attribute.getBooleanValue();
        }
        catch (DataConversionException ex) {
            // empty catch block
        }
        attribute = element.getAttribute(SHORTEN_FQN_ATTR_NAME);
        try {
            this.toShortenFQN = attribute.getBooleanValue();
        }
        catch (DataConversionException ex) {
            // empty catch block
        }
        attribute = element.getAttribute(USE_STATIC_IMPORT_ATTR_NAME);
        if (attribute != null) {
            try {
                this.myToUseStaticImport = attribute.getBooleanValue();
            }
            catch (DataConversionException ignore) {
                // empty catch block
            }
        }
        this.replacement = element.getAttributeValue(REPLACEMENT_ATTR_NAME);
        List elements = element.getChildren(VARIABLE_DEFINITION_TAG_NAME);
        if (elements != null && elements.size() > 0) {
            for (Element element1 : elements) {
                ReplacementVariableDefinition variableDefinition = new ReplacementVariableDefinition();
                variableDefinition.readExternal(element1);
                this.addVariableDefinition(variableDefinition);
            }
        }
    }

    public void writeExternal(Element element) {
        this.matchOptions.writeExternal(element);
        element.setAttribute(REFORMAT_ATTR_NAME, String.valueOf(this.myToReformatAccordingToStyle));
        element.setAttribute(SHORTEN_FQN_ATTR_NAME, String.valueOf(this.toShortenFQN));
        if (this.isToUseStaticImport()) {
            element.setAttribute(USE_STATIC_IMPORT_ATTR_NAME, String.valueOf(this.isToUseStaticImport()));
        }
        element.setAttribute(REPLACEMENT_ATTR_NAME, this.replacement);
        if (this.variableDefs != null) {
            for (ReplacementVariableDefinition variableDefinition : this.variableDefs.values()) {
                Element infoElement = new Element(VARIABLE_DEFINITION_TAG_NAME);
                element.addContent(infoElement);
                variableDefinition.writeExternal(infoElement);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplaceOptions)) {
            return false;
        }
        ReplaceOptions replaceOptions = (ReplaceOptions)o;
        if (this.myToReformatAccordingToStyle != replaceOptions.myToReformatAccordingToStyle) {
            return false;
        }
        if (this.toShortenFQN != replaceOptions.toShortenFQN) {
            return false;
        }
        if (this.myToUseStaticImport != replaceOptions.myToUseStaticImport) {
            return false;
        }
        if (this.matchOptions != null ? !this.matchOptions.equals(replaceOptions.matchOptions) : replaceOptions.matchOptions != null) {
            return false;
        }
        if (this.replacement != null ? !this.replacement.equals(replaceOptions.replacement) : replaceOptions.replacement != null) {
            return false;
        }
        return !(this.variableDefs != null ? !((Object)this.variableDefs).equals(replaceOptions.variableDefs) : replaceOptions.variableDefs != null);
    }

    public int hashCode() {
        int result = this.replacement != null ? this.replacement.hashCode() : 0;
        result = 29 * result + (this.toShortenFQN ? 1 : 0);
        result = 29 * result + (this.myToReformatAccordingToStyle ? 1 : 0);
        result = 29 * result + (this.myToUseStaticImport ? 1 : 0);
        result = 29 * result + (this.matchOptions != null ? this.matchOptions.hashCode() : 0);
        result = 29 * result + (this.variableDefs != null ? ((Object)this.variableDefs).hashCode() : 0);
        return result;
    }

    public ReplacementVariableDefinition getVariableDefinition(String name) {
        return this.variableDefs != null ? this.variableDefs.get(name) : null;
    }

    public void addVariableDefinition(ReplacementVariableDefinition definition) {
        if (this.variableDefs == null) {
            this.variableDefs = new LinkedHashMap<String, ReplacementVariableDefinition>();
        }
        this.variableDefs.put(definition.getName(), definition);
    }

    public Collection<ReplacementVariableDefinition> getReplacementVariableDefinitions() {
        return this.variableDefs != null ? this.variableDefs.values() : Collections.emptyList();
    }

    public void clearVariableDefinitions() {
        this.variableDefs = null;
    }
}

