/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.ui.popup.TreePopup;
import com.intellij.openapi.ui.popup.TreePopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.HintHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.BalloonPopupBuilderImpl;
import com.intellij.ui.popup.ComponentPopupBuilderImpl;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.mock.MockConfirmation;
import com.intellij.ui.popup.tree.TreePopupImpl;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.ui.EmptyIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopupFactoryImpl
extends JBPopupFactory {
    public static final Key<VisualPosition> ANCHOR_POPUP_POSITION = Key.create((String)"popup.anchor.position");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.popup.PopupFactoryImpl");
    private final Map<Disposable, List<Balloon>> myStorage = new WeakHashMap();

    @NotNull
    public ListPopup createConfirmation(String title, Runnable onYes, int defaultOptionIndex) {
        ListPopup listPopup = this.createConfirmation(title, CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText(), onYes, defaultOptionIndex);
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createConfirmation"));
        }
        return listPopup;
    }

    @NotNull
    public ListPopup createConfirmation(String title, String yesText, String noText, Runnable onYes, int defaultOptionIndex) {
        ListPopup listPopup = this.createConfirmation(title, yesText, noText, onYes, EmptyRunnable.getInstance(), defaultOptionIndex);
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createConfirmation"));
        }
        return listPopup;
    }

    @NotNull
    public JBPopup createMessage(String text) {
        ListPopup listPopup = this.createListPopup((ListPopupStep)new BaseListPopupStep(null, (Object[])new String[]{text}));
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createMessage"));
        }
        return listPopup;
    }

    public Balloon getParentBalloonFor(@Nullable Component c) {
        if (c == null) {
            return null;
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            Object balloon;
            if (!(eachParent instanceof JComponent) || !((balloon = ((JComponent)eachParent).getClientProperty("Balloon.property")) instanceof Balloon)) continue;
            return (Balloon)balloon;
        }
        return null;
    }

    @NotNull
    public ListPopup createConfirmation(String title, final String yesText, String noText, final Runnable onYes, final Runnable onNo, int defaultOptionIndex) {
        BaseListPopupStep<String> step = new BaseListPopupStep<String>(title, new String[]{yesText, noText}){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                if (selectedValue.equals(yesText)) {
                    onYes.run();
                } else {
                    onNo.run();
                }
                return FINAL_CHOICE;
            }

            public void canceled() {
                onNo.run();
            }

            public boolean isMnemonicsNavigationEnabled() {
                return true;
            }
        };
        step.setDefaultOptionIndex(defaultOptionIndex);
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        ListPopupImpl listPopupImpl = app == null || !app.isUnitTestMode() ? new ListPopupImpl((ListPopupStep)step) : new MockConfirmation((ListPopupStep)step, yesText);
        if (listPopupImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createConfirmation"));
        }
        return listPopupImpl;
    }

    private static ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        return PopupFactoryImpl.createActionGroupPopup(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, null, null);
    }

    public ListPopup createActionGroupPopup(String title, ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        return this.createActionGroupPopup(title, actionGroup, dataContext, showNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, null);
    }

    private static ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition, @Nullable String actionPlace) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        return new ActionGroupPopup(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectActionCondition, actionPlace);
    }

    @NotNull
    public ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        ListPopup listPopup = PopupFactoryImpl.createActionGroupPopup(title, actionGroup, dataContext, showNumbers, true, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectActionCondition, null);
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        return listPopup;
    }

    @NotNull
    public ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, JBPopupFactory.ActionSelectionAid selectionAidMethod, boolean showDisabledActions) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        ListPopup listPopup = PopupFactoryImpl.createActionGroupPopup(title, actionGroup, dataContext, selectionAidMethod == JBPopupFactory.ActionSelectionAid.NUMBERING || selectionAidMethod == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, selectionAidMethod == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, showDisabledActions, selectionAidMethod == JBPopupFactory.ActionSelectionAid.MNEMONICS, null, -1);
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        return listPopup;
    }

    @NotNull
    public ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, JBPopupFactory.ActionSelectionAid selectionAidMethod, boolean showDisabledActions, @Nullable String actionPlace) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        ListPopup listPopup = PopupFactoryImpl.createActionGroupPopup(title, actionGroup, dataContext, selectionAidMethod == JBPopupFactory.ActionSelectionAid.NUMBERING || selectionAidMethod == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, selectionAidMethod == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, showDisabledActions, selectionAidMethod == JBPopupFactory.ActionSelectionAid.MNEMONICS, null, -1, null, actionPlace);
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        return listPopup;
    }

    @NotNull
    public ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, JBPopupFactory.ActionSelectionAid selectionAidMethod, boolean showDisabledActions, Runnable disposeCallback, int maxRowCount) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        ListPopup listPopup = PopupFactoryImpl.createActionGroupPopup(title, actionGroup, dataContext, selectionAidMethod == JBPopupFactory.ActionSelectionAid.NUMBERING || selectionAidMethod == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, selectionAidMethod == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, showDisabledActions, selectionAidMethod == JBPopupFactory.ActionSelectionAid.MNEMONICS, disposeCallback, maxRowCount);
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createActionGroupPopup"));
        }
        return listPopup;
    }

    @NotNull
    public ListPopupStep createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean showDisabledActions, String title, Component component, boolean honorActionMnemonics) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/popup/PopupFactoryImpl", "createActionsStep"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/PopupFactoryImpl", "createActionsStep"));
        }
        ListPopupStep listPopupStep = this.createActionsStep(actionGroup, dataContext, showNumbers, showDisabledActions, title, component, honorActionMnemonics, 0, false);
        if (listPopupStep == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createActionsStep"));
        }
        return listPopupStep;
    }

    private static ListPopupStep createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, String title, Component component, boolean honorActionMnemonics, final int defaultOptionIndex, boolean autoSelectionEnabled) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/popup/PopupFactoryImpl", "createActionsStep"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/PopupFactoryImpl", "createActionsStep"));
        }
        final List<ActionItem> items = PopupFactoryImpl.makeActionItemsFromActionGroup(actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics);
        return new ActionPopupStep(items, title, component, showNumbers || honorActionMnemonics && PopupFactoryImpl.itemsHaveMnemonics(items), (Condition)new Condition<AnAction>(){

            public boolean value(AnAction action) {
                return defaultOptionIndex >= 0 && defaultOptionIndex < items.size() && ((ActionItem)items.get(defaultOptionIndex)).getAction().equals(action);
            }
        }, autoSelectionEnabled, showDisabledActions);
    }

    @NotNull
    private static List<ActionItem> makeActionItemsFromActionGroup(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/popup/PopupFactoryImpl", "makeActionItemsFromActionGroup"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/PopupFactoryImpl", "makeActionItemsFromActionGroup"));
        }
        ActionStepBuilder builder = new ActionStepBuilder(dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics);
        builder.buildGroup(actionGroup);
        List<ActionItem> list = builder.getItems();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "makeActionItemsFromActionGroup"));
        }
        return list;
    }

    @NotNull
    private static ListPopupStep createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, String title, Component component, boolean honorActionMnemonics, Condition<AnAction> preselectActionCondition, boolean autoSelectionEnabled) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/popup/PopupFactoryImpl", "createActionsStep"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/PopupFactoryImpl", "createActionsStep"));
        }
        List<ActionItem> items = PopupFactoryImpl.makeActionItemsFromActionGroup(actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics);
        ActionPopupStep actionPopupStep = new ActionPopupStep(items, title, component, showNumbers || honorActionMnemonics && PopupFactoryImpl.itemsHaveMnemonics(items), preselectActionCondition, autoSelectionEnabled, showDisabledActions);
        if (actionPopupStep == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createActionsStep"));
        }
        return actionPopupStep;
    }

    @NotNull
    public ListPopupStep createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean showDisabledActions, String title, Component component, boolean honorActionMnemonics, int defaultOptionIndex, boolean autoSelectionEnabled) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/popup/PopupFactoryImpl", "createActionsStep"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/PopupFactoryImpl", "createActionsStep"));
        }
        ListPopupStep listPopupStep = PopupFactoryImpl.createActionsStep(actionGroup, dataContext, showNumbers, true, showDisabledActions, title, component, honorActionMnemonics, defaultOptionIndex, autoSelectionEnabled);
        if (listPopupStep == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createActionsStep"));
        }
        return listPopupStep;
    }

    private static boolean itemsHaveMnemonics(List<ActionItem> items) {
        for (ActionItem item : items) {
            if (item.getAction().getTemplatePresentation().getMnemonic() == 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ListPopup createWizardStep(@NotNull PopupStep step) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "com/intellij/ui/popup/PopupFactoryImpl", "createWizardStep"));
        }
        ListPopupImpl listPopupImpl = new ListPopupImpl((ListPopupStep)step);
        if (listPopupImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createWizardStep"));
        }
        return listPopupImpl;
    }

    @NotNull
    public ListPopup createListPopup(@NotNull ListPopupStep step) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "com/intellij/ui/popup/PopupFactoryImpl", "createListPopup"));
        }
        ListPopupImpl listPopupImpl = new ListPopupImpl(step);
        if (listPopupImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createListPopup"));
        }
        return listPopupImpl;
    }

    @NotNull
    public ListPopup createListPopup(@NotNull ListPopupStep step, int maxRowCount) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "com/intellij/ui/popup/PopupFactoryImpl", "createListPopup"));
        }
        ListPopupImpl listPopupImpl = new ListPopupImpl(step, maxRowCount);
        if (listPopupImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createListPopup"));
        }
        return listPopupImpl;
    }

    @NotNull
    public TreePopup createTree(JBPopup parent, @NotNull TreePopupStep aStep, Object parentValue) {
        if (aStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aStep", "com/intellij/ui/popup/PopupFactoryImpl", "createTree"));
        }
        TreePopupImpl treePopupImpl = new TreePopupImpl(parent, aStep, parentValue);
        if (treePopupImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createTree"));
        }
        return treePopupImpl;
    }

    @NotNull
    public TreePopup createTree(@NotNull TreePopupStep aStep) {
        if (aStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aStep", "com/intellij/ui/popup/PopupFactoryImpl", "createTree"));
        }
        TreePopupImpl treePopupImpl = new TreePopupImpl(aStep);
        if (treePopupImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createTree"));
        }
        return treePopupImpl;
    }

    @NotNull
    public ComponentPopupBuilder createComponentPopupBuilder(@NotNull JComponent content, JComponent prefferableFocusComponent) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/popup/PopupFactoryImpl", "createComponentPopupBuilder"));
        }
        ComponentPopupBuilderImpl componentPopupBuilderImpl = new ComponentPopupBuilderImpl(content, prefferableFocusComponent);
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createComponentPopupBuilder"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull DataContext dataContext) {
        Point point;
        JComponent focusOwner;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/PopupFactoryImpl", "guessBestPopupLocation"));
        }
        Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        JComponent jComponent = focusOwner = component instanceof JComponent ? (JComponent)component : null;
        if (focusOwner == null) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            IdeFrameImpl frame = project == null ? null : ((WindowManagerEx)WindowManager.getInstance()).getFrame(project);
            JComponent jComponent2 = focusOwner = frame == null ? null : frame.getRootPane();
            if (focusOwner == null) {
                throw new IllegalArgumentException("focusOwner cannot be null");
            }
        }
        if ((point = (Point)PlatformDataKeys.CONTEXT_MENU_POINT.getData(dataContext)) != null) {
            RelativePoint relativePoint = new RelativePoint((Component)focusOwner, point);
            if (relativePoint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "guessBestPopupLocation"));
            }
            return relativePoint;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && focusOwner == editor.getContentComponent()) {
            RelativePoint relativePoint = this.guessBestPopupLocation(editor);
            if (relativePoint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "guessBestPopupLocation"));
            }
            return relativePoint;
        }
        RelativePoint relativePoint = this.guessBestPopupLocation(focusOwner);
        if (relativePoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "guessBestPopupLocation"));
        }
        return relativePoint;
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/popup/PopupFactoryImpl", "guessBestPopupLocation"));
        }
        Point popupMenuPoint = null;
        Rectangle visibleRect = component.getVisibleRect();
        if (component instanceof JList) {
            int[] selectedIndices;
            JList list = (JList)component;
            int firstVisibleIndex = list.getFirstVisibleIndex();
            int lastVisibleIndex = list.getLastVisibleIndex();
            for (int index : selectedIndices = list.getSelectedIndices()) {
                if (firstVisibleIndex > index || index > lastVisibleIndex) continue;
                Rectangle cellBounds = list.getCellBounds(index, index);
                popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 4, cellBounds.y + cellBounds.height);
                break;
            }
        } else if (component instanceof JTree) {
            JTree tree = (JTree)component;
            int[] selectionRows = tree.getSelectionRows();
            if (selectionRows != null) {
                Arrays.sort(selectionRows);
                for (int i = 0; i < selectionRows.length; ++i) {
                    int row = selectionRows[i];
                    Rectangle rowBounds = tree.getRowBounds(row);
                    if (!visibleRect.contains(rowBounds)) continue;
                    popupMenuPoint = new Point(rowBounds.x + 2, rowBounds.y + rowBounds.height - 1);
                    break;
                }
                if (popupMenuPoint == null) {
                    Point visibleCenter = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
                    double minDistance = Double.POSITIVE_INFINITY;
                    int bestRow = -1;
                    for (int i = 0; i < selectionRows.length; ++i) {
                        int row = selectionRows[i];
                        Rectangle rowBounds = tree.getRowBounds(row);
                        Point rowCenter = new Point(rowBounds.x + rowBounds.width / 2, rowBounds.y + rowBounds.height / 2);
                        double distance = visibleCenter.distance(rowCenter);
                        if (!(minDistance > distance)) continue;
                        minDistance = distance;
                        bestRow = row;
                    }
                    if (bestRow != -1) {
                        Rectangle rowBounds = tree.getRowBounds(bestRow);
                        tree.scrollRectToVisible(new Rectangle(rowBounds.x, rowBounds.y, Math.min(visibleRect.width, rowBounds.width), rowBounds.height));
                        popupMenuPoint = new Point(rowBounds.x + 2, rowBounds.y + rowBounds.height - 1);
                    }
                }
            }
        } else if (component instanceof JTable) {
            JTable table = (JTable)component;
            int column = table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            int row = Math.max(table.getSelectionModel().getLeadSelectionIndex(), table.getSelectionModel().getAnchorSelectionIndex());
            Rectangle rect = table.getCellRect(row, column, false);
            if (!visibleRect.intersects(rect)) {
                table.scrollRectToVisible(rect);
            }
            popupMenuPoint = new Point(rect.x, rect.y + rect.height);
        } else if (component instanceof PopupOwner) {
            popupMenuPoint = ((PopupOwner)((Object)component)).getBestPopupPosition();
        }
        if (popupMenuPoint == null) {
            popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
        }
        RelativePoint relativePoint = new RelativePoint((Component)component, popupMenuPoint);
        if (relativePoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "guessBestPopupLocation"));
        }
        return relativePoint;
    }

    public boolean isBestPopupLocationVisible(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/popup/PopupFactoryImpl", "isBestPopupLocationVisible"));
        }
        return PopupFactoryImpl.getVisibleBestPopupLocation(editor) != null;
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/popup/PopupFactoryImpl", "guessBestPopupLocation"));
        }
        Point p = PopupFactoryImpl.getVisibleBestPopupLocation(editor);
        if (p == null) {
            Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
            p = new Point((visibleArea.x + visibleArea.width) / 2, (visibleArea.y + visibleArea.height) / 2);
        }
        RelativePoint relativePoint = new RelativePoint((Component)editor.getContentComponent(), p);
        if (relativePoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "guessBestPopupLocation"));
        }
        return relativePoint;
    }

    @Nullable
    private static Point getVisibleBestPopupLocation(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/popup/PopupFactoryImpl", "getVisibleBestPopupLocation"));
        }
        VisualPosition visualPosition = (VisualPosition)editor.getUserData(ANCHOR_POPUP_POSITION);
        if (visualPosition == null) {
            CaretModel caretModel = editor.getCaretModel();
            visualPosition = caretModel.isUpToDate() ? caretModel.getVisualPosition() : editor.offsetToVisualPosition(caretModel.getOffset());
        }
        Point p = editor.visualPositionToXY(new VisualPosition(visualPosition.line + 1, visualPosition.column));
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        return visibleArea.contains(p) ? p : null;
    }

    public Point getCenterOf(JComponent container, JComponent content) {
        return AbstractPopup.getCenterOf(container, content);
    }

    @NotNull
    public List<JBPopup> getChildPopups(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/popup/PopupFactoryImpl", "getChildPopups"));
        }
        List<JBPopup> list = FocusTrackback.getChildPopups(component);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "getChildPopups"));
        }
        return list;
    }

    public boolean isPopupActive() {
        return IdeEventQueue.getInstance().isPopupActive();
    }

    @NotNull
    public BalloonBuilder createBalloonBuilder(@NotNull JComponent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/popup/PopupFactoryImpl", "createBalloonBuilder"));
        }
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = new BalloonPopupBuilderImpl(this.myStorage, content);
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createBalloonBuilder"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder createDialogBalloonBuilder(@NotNull JComponent content, String title) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/popup/PopupFactoryImpl", "createDialogBalloonBuilder"));
        }
        BalloonPopupBuilderImpl builder = new BalloonPopupBuilderImpl(this.myStorage, content);
        Color bg = UIManager.getColor("Panel.background");
        Color borderOriginal = Color.darkGray;
        Color border = ColorUtil.toAlpha((Color)borderOriginal, (int)75);
        builder.setDialogMode(true).setTitle(title).setAnimationCycle(200).setFillColor(bg).setBorderColor(border).setHideOnClickOutside(false).setHideOnKeyOutside(false).setHideOnAction(false).setCloseButtonEnabled(true).setShadow(true);
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = builder;
        if (balloonPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createDialogBalloonBuilder"));
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull String htmlContent, @Nullable Icon icon, Color fillColor, @Nullable HyperlinkListener listener) {
        if (htmlContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlContent", "com/intellij/ui/popup/PopupFactoryImpl", "createHtmlTextBalloonBuilder"));
        }
        JEditorPane text = IdeTooltipManager.initPane(htmlContent, new HintHint().setAwtTooltip(true), null);
        if (listener != null) {
            text.addHyperlinkListener(listener);
        }
        text.setEditable(false);
        NonOpaquePanel.setTransparent((JComponent)text);
        text.setBorder(null);
        JLabel label = new JLabel();
        NonOpaquePanel content = new NonOpaquePanel((LayoutManager)new BorderLayout((int)((double)label.getIconTextGap() * 1.5), (int)((double)label.getIconTextGap() * 1.5)));
        NonOpaquePanel textWrapper = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        JScrollPane scrolledText = new JScrollPane(text);
        scrolledText.setBackground(fillColor);
        scrolledText.getViewport().setBackground(fillColor);
        scrolledText.getViewport().setBorder(null);
        scrolledText.setBorder(null);
        textWrapper.add((Component)scrolledText);
        content.add((Component)textWrapper, "Center");
        NonOpaquePanel north = new NonOpaquePanel((LayoutManager)new BorderLayout());
        north.add((Component)new JLabel(icon), (Object)"North");
        content.add((Component)north, "West");
        content.setBorder(new EmptyBorder(2, 4, 2, 4));
        BalloonBuilder builder = this.createBalloonBuilder((JComponent)content);
        builder.setFillColor(fillColor);
        BalloonBuilder balloonBuilder = builder;
        if (balloonBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createHtmlTextBalloonBuilder"));
        }
        return balloonBuilder;
    }

    @NotNull
    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull String htmlContent, MessageType messageType, @Nullable HyperlinkListener listener) {
        if (htmlContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlContent", "com/intellij/ui/popup/PopupFactoryImpl", "createHtmlTextBalloonBuilder"));
        }
        BalloonBuilder balloonBuilder = this.createHtmlTextBalloonBuilder(htmlContent, messageType.getDefaultIcon(), messageType.getPopupBackground(), listener);
        if (balloonBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl", "createHtmlTextBalloonBuilder"));
        }
        return balloonBuilder;
    }

    private static class ActionStepBuilder {
        private final List<ActionItem> myListModel;
        private final DataContext myDataContext;
        private final boolean myShowNumbers;
        private final boolean myUseAlphaAsNumbers;
        private final boolean myShowDisabled;
        private final HashMap<AnAction, Presentation> myAction2presentation;
        private int myCurrentNumber;
        private boolean myPrependWithSeparator;
        private String mySeparatorText;
        private final boolean myHonorActionMnemonics;
        private Icon myEmptyIcon;
        private int myMaxIconWidth;
        private int myMaxIconHeight;
        @NotNull
        private String myActionPlace;

        private ActionStepBuilder(@NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabled, boolean honorActionMnemonics) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/PopupFactoryImpl$ActionStepBuilder", "<init>"));
            }
            this.myMaxIconWidth = -1;
            this.myMaxIconHeight = -1;
            this.myUseAlphaAsNumbers = useAlphaAsNumbers;
            this.myListModel = new ArrayList<ActionItem>();
            this.myDataContext = dataContext;
            this.myShowNumbers = showNumbers;
            this.myShowDisabled = showDisabled;
            this.myAction2presentation = new HashMap();
            this.myCurrentNumber = 0;
            this.myPrependWithSeparator = false;
            this.mySeparatorText = null;
            this.myHonorActionMnemonics = honorActionMnemonics;
            this.myActionPlace = "unknown";
        }

        public void setActionPlace(@NotNull String actionPlace) {
            if (actionPlace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionPlace", "com/intellij/ui/popup/PopupFactoryImpl$ActionStepBuilder", "setActionPlace"));
            }
            this.myActionPlace = actionPlace;
        }

        @NotNull
        public List<ActionItem> getItems() {
            List<ActionItem> list = this.myListModel;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl$ActionStepBuilder", "getItems"));
            }
            return list;
        }

        public void buildGroup(@NotNull ActionGroup actionGroup) {
            if (actionGroup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/popup/PopupFactoryImpl$ActionStepBuilder", "buildGroup"));
            }
            this.calcMaxIconSize(actionGroup);
            this.myEmptyIcon = this.myMaxIconHeight != -1 && this.myMaxIconWidth != -1 ? new EmptyIcon(this.myMaxIconWidth, this.myMaxIconHeight) : null;
            this.appendActionsFromGroup(actionGroup);
            if (this.myListModel.isEmpty()) {
                this.myListModel.add(new ActionItem(Utils.EMPTY_MENU_FILLER, "Nothing here", false, null, false, null));
            }
        }

        private void calcMaxIconSize(ActionGroup actionGroup) {
            AnAction[] actions;
            for (AnAction action : actions = actionGroup.getChildren(this.createActionEvent((AnAction)actionGroup))) {
                ActionGroup group;
                if (action == null) continue;
                if (action instanceof ActionGroup && !(group = (ActionGroup)action).isPopup()) {
                    this.calcMaxIconSize(group);
                    continue;
                }
                Icon icon = action.getTemplatePresentation().getIcon();
                if (icon == null && action instanceof Toggleable) {
                    icon = PlatformIcons.CHECK_ICON;
                }
                if (icon == null) continue;
                int width = icon.getIconWidth();
                int height = icon.getIconHeight();
                if (this.myMaxIconWidth < width) {
                    this.myMaxIconWidth = width;
                }
                if (this.myMaxIconHeight >= height) continue;
                this.myMaxIconHeight = height;
            }
        }

        @NotNull
        private AnActionEvent createActionEvent(@NotNull AnAction actionGroup) {
            if (actionGroup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/popup/PopupFactoryImpl$ActionStepBuilder", "createActionEvent"));
            }
            AnActionEvent actionEvent = new AnActionEvent(null, this.myDataContext, this.myActionPlace, this.getPresentation(actionGroup), ActionManager.getInstance(), 0);
            actionEvent.setInjectedContext(actionGroup.isInInjectedContext());
            AnActionEvent anActionEvent = actionEvent;
            if (anActionEvent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl$ActionStepBuilder", "createActionEvent"));
            }
            return anActionEvent;
        }

        private void appendActionsFromGroup(@NotNull ActionGroup actionGroup) {
            AnAction[] actions;
            if (actionGroup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/popup/PopupFactoryImpl$ActionStepBuilder", "appendActionsFromGroup"));
            }
            for (AnAction action : actions = actionGroup.getChildren(this.createActionEvent((AnAction)actionGroup))) {
                if (action == null) {
                    LOG.error("null action in group " + actionGroup);
                    continue;
                }
                if (action instanceof Separator) {
                    this.myPrependWithSeparator = true;
                    this.mySeparatorText = ((Separator)action).getText();
                    continue;
                }
                if (action instanceof ActionGroup) {
                    ActionGroup group = (ActionGroup)action;
                    if (group.isPopup()) {
                        this.appendAction((AnAction)group);
                        continue;
                    }
                    this.appendActionsFromGroup(group);
                    continue;
                }
                this.appendAction(action);
            }
        }

        private void appendAction(@NotNull AnAction action) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/ui/popup/PopupFactoryImpl$ActionStepBuilder", "appendAction"));
            }
            Presentation presentation = this.getPresentation(action);
            AnActionEvent event = this.createActionEvent(action);
            ActionUtil.performDumbAwareUpdate((AnAction)action, (AnActionEvent)event, (boolean)true);
            if ((this.myShowDisabled || presentation.isEnabled()) && presentation.isVisible()) {
                boolean prependSeparator;
                boolean toggled;
                String actionId;
                String text = presentation.getText();
                if (this.myShowNumbers) {
                    if (this.myCurrentNumber < 9) {
                        text = "&" + (this.myCurrentNumber + 1) + ". " + text;
                    } else if (this.myCurrentNumber == 9) {
                        text = "&0. " + text;
                    } else if (this.myUseAlphaAsNumbers) {
                        text = "&" + (char)(65 + this.myCurrentNumber - 10) + ". " + text;
                    }
                    ++this.myCurrentNumber;
                } else if (this.myHonorActionMnemonics) {
                    text = Presentation.restoreTextWithMnemonic((String)text, (int)action.getTemplatePresentation().getMnemonic());
                }
                Icon icon = presentation.getIcon();
                icon = icon == null ? ((actionId = ActionManager.getInstance().getId(action)) != null && actionId.startsWith("QuickList.") ? AllIcons.Actions.QuickList : (action instanceof Toggleable ? ((toggled = Boolean.TRUE.equals(presentation.getClientProperty("selected"))) ? new IconWrapper(PlatformIcons.CHECK_ICON) : this.myEmptyIcon) : this.myEmptyIcon)) : new IconWrapper(icon);
                boolean bl = prependSeparator = (!this.myListModel.isEmpty() || this.mySeparatorText != null) && this.myPrependWithSeparator;
                assert (text != null) : action + " has no presentation";
                this.myListModel.add(new ActionItem(action, text, presentation.isEnabled(), icon, prependSeparator, this.mySeparatorText));
                this.myPrependWithSeparator = false;
                this.mySeparatorText = null;
            }
        }

        private Presentation getPresentation(@NotNull AnAction action) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/ui/popup/PopupFactoryImpl$ActionStepBuilder", "getPresentation"));
            }
            Presentation presentation = (Presentation)this.myAction2presentation.get((Object)action);
            if (presentation == null) {
                presentation = action.getTemplatePresentation().clone();
                this.myAction2presentation.put((Object)action, (Object)presentation);
            }
            return presentation;
        }

        private class IconWrapper
        implements Icon {
            private Icon myIcon;

            IconWrapper(Icon icon) {
                this.myIcon = icon;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                this.myIcon.paintIcon(c, g, x, y);
            }

            @Override
            public int getIconWidth() {
                return ActionStepBuilder.this.myMaxIconWidth;
            }

            @Override
            public int getIconHeight() {
                return ActionStepBuilder.this.myMaxIconHeight;
            }
        }
    }

    private static class ActionPopupStep
    implements ListPopupStepEx<ActionItem>,
    MnemonicNavigationFilter<ActionItem>,
    SpeedSearchFilter<ActionItem> {
        private final List<ActionItem> myItems;
        private final String myTitle;
        private final Component myContext;
        private final boolean myEnableMnemonics;
        private final int myDefaultOptionIndex;
        private final boolean myAutoSelectionEnabled;
        private final boolean myShowDisabledActions;
        private Runnable myFinalRunnable;
        @Nullable
        private final Condition<AnAction> myPreselectActionCondition;

        private ActionPopupStep(@NotNull List<ActionItem> items, String title, Component context, boolean enableMnemonics, @Nullable Condition<AnAction> preselectActionCondition, boolean autoSelection, boolean showDisabledActions) {
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/ui/popup/PopupFactoryImpl$ActionPopupStep", "<init>"));
            }
            this.myItems = items;
            this.myTitle = title;
            this.myContext = context;
            this.myEnableMnemonics = enableMnemonics;
            this.myDefaultOptionIndex = ActionPopupStep.getDefaultOptionIndexFromSelectCondition(preselectActionCondition, items);
            this.myPreselectActionCondition = preselectActionCondition;
            this.myAutoSelectionEnabled = autoSelection;
            this.myShowDisabledActions = showDisabledActions;
        }

        private static int getDefaultOptionIndexFromSelectCondition(@Nullable Condition<AnAction> preselectActionCondition, @NotNull List<ActionItem> items) {
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/ui/popup/PopupFactoryImpl$ActionPopupStep", "getDefaultOptionIndexFromSelectCondition"));
            }
            int defaultOptionIndex = 0;
            if (preselectActionCondition != null) {
                for (int i = 0; i < items.size(); ++i) {
                    AnAction action = items.get(i).getAction();
                    if (!preselectActionCondition.value((Object)action)) continue;
                    defaultOptionIndex = i;
                    break;
                }
            }
            return defaultOptionIndex;
        }

        @NotNull
        public List<ActionItem> getValues() {
            List<ActionItem> list = this.myItems;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl$ActionPopupStep", "getValues"));
            }
            return list;
        }

        public boolean isSelectable(ActionItem value) {
            return value.isEnabled();
        }

        public int getMnemonicPos(ActionItem value) {
            String text = this.getTextFor(value);
            int i = text.indexOf(27);
            if (i < 0) {
                i = text.indexOf(38);
            }
            if (i < 0) {
                i = text.indexOf(95);
            }
            return i;
        }

        public Icon getIconFor(ActionItem aValue) {
            return aValue.getIcon();
        }

        @NotNull
        public String getTextFor(ActionItem value) {
            String string = value.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl$ActionPopupStep", "getTextFor"));
            }
            return string;
        }

        public ListSeparator getSeparatorAbove(ActionItem value) {
            return value.isPrependWithSeparator() ? new ListSeparator(value.getSeparatorText()) : null;
        }

        public int getDefaultOptionIndex() {
            return this.myDefaultOptionIndex;
        }

        public String getTitle() {
            return this.myTitle;
        }

        public PopupStep onChosen(ActionItem actionChoice, boolean finalChoice) {
            return this.onChosen(actionChoice, finalChoice, 0);
        }

        public PopupStep onChosen(ActionItem actionChoice, boolean finalChoice, final int eventModifiers) {
            DataContext dataContext;
            if (!actionChoice.isEnabled()) {
                return FINAL_CHOICE;
            }
            final AnAction action = actionChoice.getAction();
            DataManager mgr = DataManager.getInstance();
            DataContext dataContext2 = dataContext = this.myContext != null ? mgr.getDataContext(this.myContext) : mgr.getDataContext();
            if (!(!(action instanceof ActionGroup) || finalChoice && ((ActionGroup)action).canBePerformed(dataContext))) {
                return PopupFactoryImpl.createActionsStep((ActionGroup)action, dataContext, this.myEnableMnemonics, true, this.myShowDisabledActions, null, this.myContext, false, (Condition<AnAction>)this.myPreselectActionCondition, false);
            }
            this.myFinalRunnable = new Runnable(){

                @Override
                public void run() {
                    AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", action.getTemplatePresentation().clone(), ActionManager.getInstance(), eventModifiers);
                    event.setInjectedContext(action.isInInjectedContext());
                    if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)event, (boolean)false)) {
                        action.actionPerformed(event);
                    }
                }
            };
            return FINAL_CHOICE;
        }

        public Runnable getFinalRunnable() {
            return this.myFinalRunnable;
        }

        public boolean hasSubstep(ActionItem selectedValue) {
            return selectedValue != null && selectedValue.isEnabled() && selectedValue.getAction() instanceof ActionGroup;
        }

        public void canceled() {
        }

        public boolean isMnemonicsNavigationEnabled() {
            return this.myEnableMnemonics;
        }

        public MnemonicNavigationFilter<ActionItem> getMnemonicNavigationFilter() {
            return this;
        }

        public boolean canBeHidden(ActionItem value) {
            return true;
        }

        public String getIndexedString(ActionItem value) {
            return this.getTextFor(value);
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean isAutoSelectionEnabled() {
            return this.myAutoSelectionEnabled;
        }

        public SpeedSearchFilter<ActionItem> getSpeedSearchFilter() {
            return this;
        }
    }

    public static class ActionItem {
        private final AnAction myAction;
        private final String myText;
        private final boolean myIsEnabled;
        private final Icon myIcon;
        private final boolean myPrependWithSeparator;
        private final String mySeparatorText;

        private ActionItem(@NotNull AnAction action, @NotNull String text, boolean enabled, Icon icon, boolean prependWithSeparator, String separatorText) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/ui/popup/PopupFactoryImpl$ActionItem", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/popup/PopupFactoryImpl$ActionItem", "<init>"));
            }
            this.myAction = action;
            this.myText = text;
            this.myIsEnabled = enabled;
            this.myIcon = icon;
            this.myPrependWithSeparator = prependWithSeparator;
            this.mySeparatorText = separatorText;
        }

        @NotNull
        public AnAction getAction() {
            AnAction anAction = this.myAction;
            if (anAction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl$ActionItem", "getAction"));
            }
            return anAction;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/PopupFactoryImpl$ActionItem", "getText"));
            }
            return string;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        public boolean isPrependWithSeparator() {
            return this.myPrependWithSeparator;
        }

        public String getSeparatorText() {
            return this.mySeparatorText;
        }

        public boolean isEnabled() {
            return this.myIsEnabled;
        }
    }

    public static class ActionGroupPopup
    extends ListPopupImpl {
        private final Runnable myDisposeCallback;
        private final Component myComponent;

        public ActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition, final @Nullable String actionPlace) {
            if (actionGroup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/popup/PopupFactoryImpl$ActionGroupPopup", "<init>"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/PopupFactoryImpl$ActionGroupPopup", "<init>"));
            }
            super(ActionGroupPopup.createStep(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, preselectActionCondition, actionPlace), maxRowCount);
            this.myDisposeCallback = disposeCallback;
            this.myComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            this.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    JList list = (JList)e.getSource();
                    ActionItem actionItem = (ActionItem)list.getSelectedValue();
                    if (actionItem == null) {
                        return;
                    }
                    AnAction action = actionItem.getAction();
                    Presentation presentation = new Presentation();
                    presentation.setDescription(action.getTemplatePresentation().getDescription());
                    String actualActionPlace = actionPlace == null ? "unknown" : actionPlace;
                    AnActionEvent actionEvent = new AnActionEvent(null, DataManager.getInstance().getDataContext(ActionGroupPopup.this.myComponent), actualActionPlace, presentation, ActionManager.getInstance(), 0);
                    actionEvent.setInjectedContext(action.isInInjectedContext());
                    action.update(actionEvent);
                    ActionMenu.showDescriptionInStatusBar(true, ActionGroupPopup.this.myComponent, presentation.getDescription());
                }
            });
        }

        private static ListPopupStep createStep(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Condition<AnAction> preselectActionCondition, @Nullable String actionPlace) {
            if (actionGroup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/popup/PopupFactoryImpl$ActionGroupPopup", "createStep"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/PopupFactoryImpl$ActionGroupPopup", "createStep"));
            }
            Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            LOG.assertTrue(component != null, (Object)"dataContext has no component for new ListPopupStep");
            ActionStepBuilder builder = new ActionStepBuilder(dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics);
            if (actionPlace != null) {
                builder.setActionPlace(actionPlace);
            }
            builder.buildGroup(actionGroup);
            List<ActionItem> items = builder.getItems();
            return new ActionPopupStep(items, title, component, showNumbers || honorActionMnemonics && PopupFactoryImpl.itemsHaveMnemonics(items), preselectActionCondition, false, showDisabledActions);
        }

        @Override
        public void dispose() {
            if (this.myDisposeCallback != null) {
                this.myDisposeCallback.run();
            }
            ActionMenu.showDescriptionInStatusBar(true, this.myComponent, null);
            super.dispose();
        }
    }
}

