/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.conflict;

import com.android.builder.model.AndroidLibrary;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolution;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConflictSet {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ImmutableList<Conflict> mySelectionConflicts;
    @NotNull
    private final ImmutableList<Conflict> myStructureConflicts;

    @NotNull
    public static ConflictSet findConflicts(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/conflict/ConflictSet", "findConflicts"));
        }
        HashMap selectionConflicts = Maps.newHashMap();
        HashMap structureConflicts = Maps.newHashMap();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            String gradlePath;
            IdeaAndroidProject currentProject = ConflictSet.getAndroidProject(module);
            if (currentProject == null || !currentProject.isLibrary() || (gradlePath = GradleUtil.getGradlePath(module)) == null) continue;
            String selectedVariant = currentProject.getSelectedVariant().getName();
            for (Module dependent : ModuleUtilCore.getAllDependentModules((Module)module)) {
                String expectedVariant;
                IdeaAndroidProject dependentProject = ConflictSet.getAndroidProject(dependent);
                if (dependentProject == null || StringUtil.isEmpty((String)(expectedVariant = ConflictSet.getExpectedVariant(dependentProject, gradlePath)))) continue;
                ConflictSet.addConflict(structureConflicts, module, selectedVariant, dependent, expectedVariant);
                if (selectedVariant.equals(expectedVariant)) continue;
                ConflictSet.addConflict(selectionConflicts, module, selectedVariant, dependent, expectedVariant);
            }
        }
        ArrayList filteredStructureConflicts = Lists.newArrayList();
        for (Conflict conflict : structureConflicts.values()) {
            if (conflict.getVariants().size() <= 1) continue;
            filteredStructureConflicts.add(conflict);
        }
        ConflictSet conflictSet = new ConflictSet(project, selectionConflicts.values(), filteredStructureConflicts);
        if (conflictSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/conflict/ConflictSet", "findConflicts"));
        }
        return conflictSet;
    }

    @Nullable
    private static IdeaAndroidProject getAndroidProject(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/variant/conflict/ConflictSet", "getAndroidProject"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null || !facet.isGradleProject()) {
            return null;
        }
        return facet.getIdeaAndroidProject();
    }

    private static void addConflict(@NotNull Map<String, Conflict> allConflicts, @NotNull Module source, @NotNull String selectedVariant, @NotNull Module affected, @NotNull String expectedVariant) {
        if (allConflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allConflicts", "com/android/tools/idea/gradle/variant/conflict/ConflictSet", "addConflict"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/gradle/variant/conflict/ConflictSet", "addConflict"));
        }
        if (selectedVariant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedVariant", "com/android/tools/idea/gradle/variant/conflict/ConflictSet", "addConflict"));
        }
        if (affected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affected", "com/android/tools/idea/gradle/variant/conflict/ConflictSet", "addConflict"));
        }
        if (expectedVariant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedVariant", "com/android/tools/idea/gradle/variant/conflict/ConflictSet", "addConflict"));
        }
        String causeName = source.getName();
        Conflict conflict = allConflicts.get(causeName);
        if (conflict == null) {
            conflict = new Conflict(source, selectedVariant);
            allConflicts.put(causeName, conflict);
        }
        conflict.addAffectedModule(affected, expectedVariant);
    }

    @Nullable
    private static String getExpectedVariant(@NotNull IdeaAndroidProject dependentProject, @NotNull String dependencyGradlePath) {
        if (dependentProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentProject", "com/android/tools/idea/gradle/variant/conflict/ConflictSet", "getExpectedVariant"));
        }
        if (dependencyGradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyGradlePath", "com/android/tools/idea/gradle/variant/conflict/ConflictSet", "getExpectedVariant"));
        }
        List<AndroidLibrary> dependencies = GradleUtil.getDirectLibraryDependencies(dependentProject.getSelectedVariant(), dependentProject);
        for (AndroidLibrary dependency : dependencies) {
            if (!dependencyGradlePath.equals(dependency.getProject())) continue;
            return dependency.getProjectVariant();
        }
        return null;
    }

    ConflictSet(@NotNull Project project, @NotNull Collection<Conflict> selectionConflicts, @NotNull Collection<Conflict> structureConflicts) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/conflict/ConflictSet", "<init>"));
        }
        if (selectionConflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionConflicts", "com/android/tools/idea/gradle/variant/conflict/ConflictSet", "<init>"));
        }
        if (structureConflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structureConflicts", "com/android/tools/idea/gradle/variant/conflict/ConflictSet", "<init>"));
        }
        this.myProject = project;
        this.mySelectionConflicts = ImmutableList.copyOf(selectionConflicts);
        this.myStructureConflicts = ImmutableList.copyOf(structureConflicts);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/conflict/ConflictSet", "getProject"));
        }
        return project;
    }

    @NotNull
    public List<Conflict> getSelectionConflicts() {
        ImmutableList<Conflict> immutableList = this.mySelectionConflicts;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/conflict/ConflictSet", "getSelectionConflicts"));
        }
        return immutableList;
    }

    @NotNull
    public List<Conflict> getStructureConflicts() {
        ImmutableList<Conflict> immutableList = this.myStructureConflicts;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/conflict/ConflictSet", "getStructureConflicts"));
        }
        return immutableList;
    }

    public void showSelectionConflicts() {
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(this.myProject);
        String groupName = "Variant selection conflicts";
        messages.removeMessages(groupName);
        for (final Conflict conflict : this.mySelectionConflicts) {
            final Module source = conflict.getSource();
            String hyperlinkText = String.format("Select '%1$s' in \"Build Variants\" window", source.getName());
            NotificationHyperlink selectInBuildVariantsWindowHyperlink = new NotificationHyperlink("select.conflict.in.variants.window", hyperlinkText){

                @Override
                protected void execute(@NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/conflict/ConflictSet$1", "execute"));
                    }
                    BuildVariantView.getInstance(project).selectAndScrollTo(source);
                }
            };
            NotificationHyperlink quickFixHyperlink = new NotificationHyperlink("fix.conflict", "Fix problem"){

                @Override
                protected void execute(@NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/conflict/ConflictSet$2", "execute"));
                    }
                    boolean solved = ConflictResolution.solveSelectionConflict(conflict);
                    if (solved) {
                        ConflictSet conflicts = ConflictSet.findConflicts(project);
                        conflicts.showSelectionConflicts();
                    }
                }
            };
            Message msg = new Message(groupName, Message.Type.ERROR, conflict.toString());
            messages.add(msg, selectInBuildVariantsWindowHyperlink, quickFixHyperlink);
        }
        BuildVariantView.getInstance(this.myProject).updateContents((List<Conflict>)this.mySelectionConflicts);
    }
}

