/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.ClassConverter;
import com.android.tools.idea.rendering.InconvertibleClassError;
import com.android.tools.lint.detector.api.ClassContext;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenderClassLoader
extends ClassLoader {
    protected static final Logger LOG = Logger.getInstance(RenderClassLoader.class);
    private ClassLoader myJarClassLoader;
    protected boolean myInsideJarClassLoader;

    public RenderClassLoader(@Nullable ClassLoader parent) {
        super(parent);
    }

    protected abstract URL[] getExternalJars();

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.load(name);
    }

    @NotNull
    protected Class<?> load(String name) throws ClassNotFoundException {
        Class<?> clz = this.loadClassFromJar(name);
        if (clz != null) {
            Class<?> clazz = clz;
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderClassLoader", "load"));
            }
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    @Nullable
    protected Class<?> loadClassFromJar(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/RenderClassLoader", "loadClassFromJar"));
        }
        if (this.myJarClassLoader == null) {
            URL[] externalJars = this.getExternalJars();
            this.myJarClassLoader = this.createClassLoader(externalJars);
        }
        try {
            this.myInsideJarClassLoader = true;
            String relative = ClassContext.getInternalName((String)name) + ".class";
            InputStream is = this.myJarClassLoader.getResourceAsStream(relative);
            if (is != null) {
                byte[] data = ByteStreams.toByteArray((InputStream)is);
                is.close();
                if (!ClassConverter.isValidClassFile(data)) {
                    throw new ClassFormatError(name);
                }
                byte[] rewritten = this.convertClass(data);
                try {
                    Class<?> clazz = this.defineClass(null, rewritten, 0, rewritten.length);
                    return clazz;
                }
                catch (UnsupportedClassVersionError inner) {
                    throw InconvertibleClassError.wrap(inner, name, data);
                }
            }
            Class<?> clazz = null;
            return clazz;
        }
        catch (IOException ex) {
            throw new Error("Failed to load class " + name, ex);
        }
        finally {
            this.myInsideJarClassLoader = false;
        }
    }

    private ClassLoader createClassLoader(URL[] externalJars) {
        return UrlClassLoader.build().parent((ClassLoader)this).urls(externalJars).allowUnescaped().noPreload().get();
    }

    @Nullable
    protected Class<?> loadClassFromClassPath(String fqcn, File classPathFolder) {
        File classFile = RenderClassLoader.findClassFile(classPathFolder, fqcn);
        if (classFile == null || !classFile.exists()) {
            return null;
        }
        return this.loadClassFile(fqcn, classFile);
    }

    @Nullable
    protected Class<?> loadClassFile(String fqcn, File classFile) {
        try {
            byte[] data = Files.toByteArray((File)classFile);
            return this.loadClass(fqcn, data);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    protected Class<?> loadClass(String fqcn, @Nullable byte[] data) {
        if (data == null) {
            return null;
        }
        if (!ClassConverter.isValidClassFile(data)) {
            throw new ClassFormatError(fqcn);
        }
        byte[] rewritten = this.convertClass(data);
        try {
            return this.defineClass(null, rewritten, 0, rewritten.length);
        }
        catch (UnsupportedClassVersionError inner) {
            throw InconvertibleClassError.wrap(inner, fqcn, data);
        }
    }

    @NotNull
    protected byte[] convertClass(@NotNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/rendering/RenderClassLoader", "convertClass"));
        }
        byte[] byArray = ClassConverter.rewriteClass(data);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderClassLoader", "convertClass"));
        }
        return byArray;
    }

    @Nullable
    private static File findClassFile(File parent, String className) {
        if (!parent.exists()) {
            return null;
        }
        String path = ClassContext.getInternalName((String)className).replace('/', File.separatorChar);
        File file = new File(parent, path + ".class");
        if (file.exists()) {
            return file;
        }
        if (className.indexOf(36) != -1) {
            return null;
        }
        path = className.replace('.', File.separatorChar);
        while (!(file = new File(parent, path + ".class")).exists()) {
            int last = path.lastIndexOf(File.separatorChar);
            if (last == -1) {
                return null;
            }
            path = path.substring(0, last) + '$' + path.substring(last + 1);
        }
        return file;
    }
}

