/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.android.tools.idea.ui.WrapAwareColoredComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultilineColoredTreeCellRenderer
extends WrapAwareColoredComponent
implements TreeCellRenderer {
    @NonNls
    protected static final String FONT_PROPERTY_NAME = "font";
    private static final Icon LOADING_NODE_ICON = new EmptyIcon(8, 16);
    @NotNull
    private final Insets myLabelInsets = new Insets(1, 2, 1, 2);
    @Nullable
    private String myPrefix;
    private int myPrefixWidth;
    private int myMinHeight;
    protected boolean mySelected;
    private boolean myFocused;
    private boolean myFocusedCalculated;
    @Nullable
    protected JTree myTree;
    private boolean myOpaque = true;

    protected MultilineColoredTreeCellRenderer() {
        this.setWrapText(true);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (MultilineColoredTreeCellRenderer.FONT_PROPERTY_NAME.equalsIgnoreCase(evt.getPropertyName())) {
                    MultilineColoredTreeCellRenderer.this.onFontChanged();
                }
            }
        });
    }

    protected void setMinHeight(int height) {
        this.myMinHeight = height;
    }

    private void onFontChanged() {
        this.resetTextLayoutCache();
    }

    @NotNull
    private FontMetrics getCurrFontMetrics() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "getCurrFontMetrics"));
        }
        return fontMetrics;
    }

    public void setText(@NotNull String[] lines, @Nullable String prefix) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "setText"));
        }
        this.myPrefix = prefix;
        for (int i = 0; i < lines.length; ++i) {
            this.append(lines[i]);
            if (i >= lines.length - 1) continue;
            this.appendLineBreak();
        }
    }

    @Override
    protected void beforePaintText(@NotNull Graphics g, int x, int textBaseLine) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "beforePaintText"));
        }
        if (!StringUtil.isEmpty((String)this.myPrefix)) {
            g.drawString(this.myPrefix, x - this.myPrefixWidth + 1, textBaseLine);
        }
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        Dimension preferredSize = this.getPreferredSize();
        Dimension result = new Dimension(preferredSize);
        Insets padding = this.getIpad();
        result.width = Math.max(result.width, padding.left + padding.right);
        result.height = Math.max(this.myMinHeight, Math.max(result.height, padding.top + padding.bottom));
        Dimension dimension = result;
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "getMinimumSize"));
        }
        return dimension;
    }

    private static int getChildIndent(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "getChildIndent"));
        }
        TreeUI newUI = tree.getUI();
        if (newUI instanceof BasicTreeUI) {
            BasicTreeUI ui = (BasicTreeUI)newUI;
            return ui.getLeftChildIndent() + ui.getRightChildIndent();
        }
        return Integer.valueOf(UIUtil.getTreeLeftChildIndent()) + Integer.valueOf(UIUtil.getTreeRightChildIndent());
    }

    private static int getAvailableWidth(@NotNull Object forValue, @NotNull JTree tree) {
        if (forValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forValue", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "getAvailableWidth"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "getAvailableWidth"));
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)forValue;
        int busyRoom = tree.getInsets().left + tree.getInsets().right + MultilineColoredTreeCellRenderer.getChildIndent(tree) * node.getLevel();
        return tree.getVisibleRect().width - busyRoom - 2;
    }

    protected abstract void initComponent(@NotNull JTree var1, @Nullable Object var2, boolean var3, boolean var4, boolean var5, int var6, boolean var7);

    public void customizeCellRenderer(@NotNull JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "customizeCellRenderer"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "customizeCellRenderer"));
        }
        this.setFont(UIUtil.getTreeFont());
        this.initComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        int availWidth = MultilineColoredTreeCellRenderer.getAvailableWidth(value, tree);
        if (availWidth > 0) {
            this.setSize(availWidth, 100);
        }
        int leftInset = this.myLabelInsets.left;
        Icon icon = this.getIcon();
        if (icon != null) {
            leftInset += icon.getIconWidth() + 2;
        }
        if (!StringUtil.isEmpty((String)this.myPrefix)) {
            this.myPrefixWidth = this.getCurrFontMetrics().stringWidth(this.myPrefix) + 5;
            leftInset += this.myPrefixWidth;
        }
        this.setIpad(new Insets(this.myLabelInsets.top, leftInset, this.myLabelInsets.bottom, this.myLabelInsets.right));
        if (icon != null) {
            this.setMinHeight(icon.getIconHeight());
        } else {
            this.setMinHeight(1);
        }
        this.setSize(this.getPreferredSize());
        this.resetTextLayoutCache();
    }

    @Override
    public final Component getTreeCellRendererComponent(@NotNull JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "getTreeCellRendererComponent"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "getTreeCellRendererComponent"));
        }
        this.myTree = tree;
        this.clear();
        this.mySelected = selected;
        this.myFocusedCalculated = false;
        if (UIUtil.isFullRowSelectionLAF()) {
            this.setBackground(selected ? UIUtil.getTreeSelectionBackground() : null);
        } else if (tree.getUI() instanceof WideSelectionTreeUI && ((WideSelectionTreeUI)tree.getUI()).isWideSelection()) {
            this.setPaintFocusBorder(false);
            if (selected) {
                this.setBackground(hasFocus ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeUnfocusedSelectionBackground());
            }
        } else if (selected) {
            this.setPaintFocusBorder(true);
            if (this.isFocused()) {
                this.setBackground(UIUtil.getTreeSelectionBackground());
            } else {
                this.setBackground(null);
            }
        } else {
            this.setBackground(null);
        }
        if (value instanceof LoadingNode) {
            this.setForeground((Color)JBColor.GRAY);
            this.setIcon(LOADING_NODE_ICON);
        } else {
            this.setForeground(tree.getForeground());
            this.setIcon(null);
        }
        if (UIUtil.isUnderGTKLookAndFeel()) {
            super.setOpaque(false);
            super.setIconOpaque(false);
        } else if (UIUtil.isUnderNimbusLookAndFeel() && selected && hasFocus) {
            super.setOpaque(false);
            super.setIconOpaque(false);
        } else if (tree.getUI() instanceof WideSelectionTreeUI && ((WideSelectionTreeUI)tree.getUI()).isWideSelection()) {
            super.setOpaque(false);
            super.setIconOpaque(false);
        } else {
            super.setOpaque(this.myOpaque || selected && hasFocus || selected && this.isFocused());
        }
        if (tree.getUI() instanceof WideSelectionTreeUI && UIUtil.isUnderAquaBasedLookAndFeel()) {
            this.setMyBorder(null);
            this.setIpad(new Insets(0, 2, 0, 2));
        }
        this.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
        return this;
    }

    @NotNull
    public static JScrollPane installRenderer(final @NotNull JTree tree, final @NotNull MultilineColoredTreeCellRenderer renderer) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "installRenderer"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "installRenderer"));
        }
        final TreeCellRenderer defaultRenderer = tree.getCellRenderer();
        JBScrollPane scrollPane = new JBScrollPane(tree){
            private int myAddRemoveCounter;
            private boolean myShouldResetCaches;
            {
                super(x0);
                this.myAddRemoveCounter = 0;
                this.myShouldResetCaches = false;
            }

            public void setSize(Dimension d) {
                boolean isChanged = this.getWidth() != d.width || this.myShouldResetCaches;
                super.setSize(d);
                if (isChanged) {
                    this.resetCaches();
                }
            }

            public void setBounds(int x, int y, int width, int height) {
                boolean isChanged = width != this.getWidth() || this.myShouldResetCaches;
                super.setBounds(x, y, width, height);
                if (isChanged) {
                    this.resetCaches();
                }
            }

            private void resetCaches() {
                MultilineColoredTreeCellRenderer.resetHeightCache(tree, defaultRenderer, renderer);
                this.myShouldResetCaches = false;
            }

            public void addNotify() {
                super.addNotify();
                if (this.myAddRemoveCounter == 0) {
                    this.myShouldResetCaches = true;
                }
                ++this.myAddRemoveCounter;
            }

            public void removeNotify() {
                super.removeNotify();
                --this.myAddRemoveCounter;
            }
        };
        scrollPane.setHorizontalScrollBarPolicy(32);
        scrollPane.setVerticalScrollBarPolicy(22);
        tree.setCellRenderer(renderer);
        scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MultilineColoredTreeCellRenderer.resetHeightCache(tree, defaultRenderer, renderer);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                MultilineColoredTreeCellRenderer.resetHeightCache(tree, defaultRenderer, renderer);
            }
        });
        JBScrollPane jBScrollPane = scrollPane;
        if (jBScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "installRenderer"));
        }
        return jBScrollPane;
    }

    private static void resetHeightCache(@NotNull JTree tree, @NotNull TreeCellRenderer defaultRenderer, @NotNull MultilineColoredTreeCellRenderer renderer) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "resetHeightCache"));
        }
        if (defaultRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultRenderer", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "resetHeightCache"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "resetHeightCache"));
        }
        tree.setCellRenderer(defaultRenderer);
        tree.setCellRenderer(renderer);
    }

    @Nullable
    public JTree getTree() {
        return this.myTree;
    }

    protected final boolean isFocused() {
        if (!this.myFocusedCalculated) {
            this.myFocused = this.calcFocusedState();
            this.myFocusedCalculated = true;
        }
        return this.myFocused;
    }

    protected boolean calcFocusedState() {
        return this.myTree != null && this.myTree.hasFocus();
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        this.myOpaque = isOpaque;
        super.setOpaque(isOpaque);
    }

    @Override
    @Nullable
    public Font getFont() {
        Font font = super.getFont();
        if (font != null) {
            return font;
        }
        JTree tree = this.getTree();
        return tree != null ? tree.getFont() : null;
    }

    @Override
    public void append(@NotNull @Nls String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "append"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/ui/MultilineColoredTreeCellRenderer", "append"));
        }
        if (this.mySelected && this.isFocused()) {
            super.append(fragment, new SimpleTextAttributes(attributes.getStyle(), UIUtil.getTreeSelectionForeground()), isMainText);
        } else if (this.mySelected && UIUtil.isUnderAquaBasedLookAndFeel()) {
            super.append(fragment, new SimpleTextAttributes(attributes.getStyle(), UIUtil.getTreeForeground()), isMainText);
        } else {
            super.append(fragment, attributes, isMainText);
        }
    }
}

