/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.LabelUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginModuleType;

public class ChooseModulesDialog
extends DialogWrapper {
    private final Icon myIcon;
    private final String myMessage;
    private final JTable myView;
    private final List<Module> myCandidateModules;
    private final boolean[] myStates;

    public ChooseModulesDialog(Project project, List<Module> candidateModules, @NonNls String title) {
        this(project, candidateModules, title, DevKitBundle.message("select.plugin.modules.to.patch", new Object[0]));
    }

    public ChooseModulesDialog(Project project, List<Module> candidateModules, @NonNls String title, String message) {
        super(project, false);
        this.setTitle(title);
        this.myCandidateModules = candidateModules;
        this.myIcon = Messages.getQuestionIcon();
        this.myMessage = message;
        this.myView = new JBTable((TableModel)new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return ChooseModulesDialog.this.myCandidateModules.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 0;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                ((ChooseModulesDialog)ChooseModulesDialog.this).myStates[rowIndex] = (Boolean)aValue;
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return columnIndex == 0 ? Boolean.class : Module.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return columnIndex == 0 ? Boolean.valueOf(ChooseModulesDialog.this.myStates[rowIndex]) : ChooseModulesDialog.this.myCandidateModules.get(rowIndex);
            }
        });
        this.myView.setShowGrid(false);
        this.myView.setTableHeader(null);
        this.myView.setIntercellSpacing((Dimension)JBUI.emptySize());
        TableUtil.setupCheckboxColumn((JTable)this.myView, (int)0);
        this.myView.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ChooseModulesDialog.this.getOKAction().setEnabled(ChooseModulesDialog.this.getSelectedModules().size() > 0);
            }
        });
        this.myView.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyChar() == '\n') {
                    ChooseModulesDialog.this.doOKAction();
                }
            }
        });
        this.myView.setDefaultRenderer(Module.class, new MyTableCellRenderer(project));
        this.myStates = new boolean[candidateModules.size()];
        Arrays.fill(this.myStates, true);
        this.init();
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout(15, 10));
        if (this.myIcon != null) {
            JLabel iconLabel = new JLabel(this.myIcon);
            Container container = new Container();
            container.setLayout(new BorderLayout());
            container.add((Component)iconLabel, "North");
            panel.add((Component)container, "West");
        }
        JPanel messagePanel = new JPanel(new BorderLayout());
        if (this.myMessage != null) {
            JLabel textLabel = new JLabel(this.myMessage);
            textLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            textLabel.setUI((LabelUI)new MultiLineLabelUI());
            messagePanel.add((Component)textLabel, "North");
        }
        panel.add((Component)messagePanel, "Center");
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane();
        jScrollPane.setViewportView(this.myView);
        jScrollPane.setPreferredSize((Dimension)JBUI.size((int)300, (int)80));
        panel.add((Component)jScrollPane, "South");
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myView;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    public List<Module> getSelectedModules() {
        ArrayList<Module> list = new ArrayList<Module>(this.myCandidateModules);
        Iterator<Module> modules = list.iterator();
        for (boolean b : this.myStates) {
            modules.next();
            if (b) continue;
            modules.remove();
        }
        return list;
    }

    private static class MyTableCellRenderer
    implements TableCellRenderer {
        private final JList myList;
        private final Project myProject;
        private final ColoredListCellRenderer myCellRenderer;

        public MyTableCellRenderer(Project project) {
            this.myProject = project;
            this.myList = new JBList();
            this.myCellRenderer = new ColoredListCellRenderer(){

                protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    Module module = (Module)value;
                    this.setIcon(ModuleType.get((Module)module).getIcon());
                    this.append(module.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    XmlFile pluginXml = PluginModuleType.getPluginXml(module);
                    assert (pluginXml != null);
                    VirtualFile virtualFile = pluginXml.getVirtualFile();
                    assert (virtualFile != null);
                    VirtualFile projectPath = MyTableCellRenderer.this.myProject.getBaseDir();
                    assert (projectPath != null);
                    if (VfsUtilCore.isAncestor((VirtualFile)projectPath, (VirtualFile)virtualFile, (boolean)false)) {
                        this.append(" (" + VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)projectPath, (char)File.separatorChar) + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    } else {
                        this.append(" (" + virtualFile.getPresentableUrl() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            };
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.myCellRenderer.getListCellRendererComponent(this.myList, value, row, isSelected, hasFocus);
        }
    }
}

