/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArchiveHandler {
    public static final long DEFAULT_LENGTH = 0L;
    public static final long DEFAULT_TIMESTAMP = -1L;
    private final String myPath;
    private final Object myLock;
    private volatile Reference<Map<String, EntryInfo>> myEntries;
    private boolean myCorrupted;

    protected ArchiveHandler(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/ArchiveHandler", "<init>"));
        }
        this.myLock = new Object();
        this.myEntries = new SoftReference(null);
        this.myCorrupted = false;
        this.myPath = path;
    }

    @NotNull
    public File getFile() {
        File file = new File(this.myPath);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getFile"));
        }
        return file;
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getAttributes"));
        }
        if (relativePath.isEmpty()) {
            FileAttributes attributes = FileSystemUtil.getAttributes((String)this.myPath);
            return attributes != null ? new FileAttributes(true, false, false, false, 0L, -1L, false) : null;
        }
        EntryInfo entry = this.getEntryInfo(relativePath);
        return entry != null ? new FileAttributes(entry.isDirectory, false, false, false, entry.length, entry.timestamp, false) : null;
    }

    @NotNull
    public String[] list(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vfs/impl/ArchiveHandler", "list"));
        }
        EntryInfo entry = this.getEntryInfo(relativePath);
        if (entry == null || !entry.isDirectory) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "list"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        HashSet<String> names = new HashSet<String>();
        for (EntryInfo info : this.getEntriesMap().values()) {
            if (info.parent != entry) continue;
            names.add(info.shortName);
        }
        String[] stringArray = ArrayUtil.toStringArray(names);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "list"));
        }
        return stringArray;
    }

    @Nullable
    protected EntryInfo getEntryInfo(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getEntryInfo"));
        }
        return this.getEntriesMap().get(relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, EntryInfo> getEntriesMap() {
        Map<Object, Object> map = (Map)SoftReference.dereference(this.myEntries);
        if (map == null) {
            Object object = this.myLock;
            synchronized (object) {
                map = (Map)SoftReference.dereference(this.myEntries);
                if (map == null) {
                    if (this.myCorrupted) {
                        map = Collections.emptyMap();
                    } else {
                        try {
                            map = Collections.unmodifiableMap(this.createEntriesMap());
                        }
                        catch (Exception e) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e.getMessage() + ": " + this.myPath, (Throwable)e);
                            map = Collections.emptyMap();
                        }
                    }
                    this.myEntries = new SoftReference(map);
                }
            }
        }
        Map map2 = map;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getEntriesMap"));
        }
        return map2;
    }

    @NotNull
    protected abstract Map<String, EntryInfo> createEntriesMap() throws IOException;

    @NotNull
    protected EntryInfo createRootEntry() {
        EntryInfo entryInfo = new EntryInfo(null, "", true, 0L, -1L);
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "createRootEntry"));
        }
        return entryInfo;
    }

    @NotNull
    protected EntryInfo getOrCreate(@NotNull Map<String, EntryInfo> map, @NotNull String entryName) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getOrCreate"));
        }
        if (entryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryName", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getOrCreate"));
        }
        EntryInfo entry = map.get(entryName);
        if (entry == null) {
            Pair<String, String> path = this.splitPath(entryName);
            EntryInfo parentEntry = this.getOrCreate(map, (String)path.first);
            entry = new EntryInfo(parentEntry, (String)path.second, true, 0L, -1L);
            map.put(entryName, entry);
        }
        EntryInfo entryInfo = entry;
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getOrCreate"));
        }
        return entryInfo;
    }

    @NotNull
    protected Pair<String, String> splitPath(@NotNull String entryName) {
        if (entryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryName", "com/intellij/openapi/vfs/impl/ArchiveHandler", "splitPath"));
        }
        int p = entryName.lastIndexOf(47);
        String parentName = p > 0 ? entryName.substring(0, p) : "";
        String shortName = p > 0 ? entryName.substring(p + 1) : entryName;
        Pair pair = Pair.create((Object)parentName, (Object)shortName);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "splitPath"));
        }
        return pair;
    }

    @NotNull
    public abstract byte[] contentsToByteArray(@NotNull String var1) throws IOException;

    protected static class EntryInfo {
        public final EntryInfo parent;
        public final String shortName;
        public final boolean isDirectory;
        public final long length;
        public final long timestamp;

        /*
         * WARNING - void declaration
         */
        public EntryInfo(EntryInfo parent, @NotNull String shortName, boolean isDirectory, long length, long l) {
            void timestamp;
            if (shortName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/openapi/vfs/impl/ArchiveHandler$EntryInfo", "<init>"));
            }
            this.parent = parent;
            this.shortName = shortName;
            this.isDirectory = isDirectory;
            this.length = length;
            this.timestamp = timestamp;
        }
    }
}

