/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.impl.AntBuildTargetImpl;
import com.intellij.lang.ant.config.impl.BuildTask;
import com.intellij.lang.ant.dom.AntDomIncludingDirective;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomTarget;
import com.intellij.lang.ant.dom.TargetResolver;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiCachedValueImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class AntBuildModelImpl
implements AntBuildModelBase {
    private final AntBuildFile myFile;
    private final CachedValue<List<AntBuildTargetBase>> myTargets;

    public AntBuildModelImpl(AntBuildFile buildFile) {
        this.myFile = buildFile;
        Project project = this.myFile.getProject();
        this.myTargets = new PsiCachedValueImpl(PsiManager.getInstance((Project)project), (CachedValueProvider)new CachedValueProvider<List<AntBuildTargetBase>>(){

            public CachedValueProvider.Result<List<AntBuildTargetBase>> compute() {
                Pair result = AntBuildModelImpl.getTargetListImpl(AntBuildModelImpl.this);
                Collection deps = (Collection)result.getSecond();
                return CachedValueProvider.Result.create((Object)result.getFirst(), (Object[])ArrayUtil.toObjectArray((Collection)deps));
            }
        });
    }

    @Override
    @Nullable
    public String getDefaultTargetName() {
        AntDomProject antDomProject = this.getAntProject();
        if (antDomProject != null) {
            return antDomProject.getDefaultTarget().getRawText();
        }
        return "";
    }

    @Override
    @Nullable
    public String getName() {
        AntDomProject project = this.getAntProject();
        return project != null ? project.getName().getRawText() : null;
    }

    @Override
    public AntBuildTarget[] getTargets() {
        List<AntBuildTargetBase> list = this.getTargetsList();
        return list.toArray(new AntBuildTargetBase[list.size()]);
    }

    @Override
    public AntBuildTarget[] getFilteredTargets() {
        ArrayList<AntBuildTargetBase> filtered = new ArrayList<AntBuildTargetBase>();
        for (AntBuildTargetBase buildTarget : this.getTargetsList()) {
            if (!this.myFile.isTargetVisible(buildTarget)) continue;
            filtered.add(buildTarget);
        }
        return filtered.size() == 0 ? AntBuildTargetBase.EMPTY_ARRAY : (AntBuildTarget[])filtered.toArray(new AntBuildTargetBase[filtered.size()]);
    }

    @Override
    @Nullable
    public String getDefaultTargetActionId() {
        if (this.getDefaultTargetName() == null) {
            return null;
        }
        String modelName = this.getName();
        if (modelName == null || modelName.trim().length() == 0) {
            return null;
        }
        return AntConfiguration.getActionIdPrefix(this.getBuildFile().getProject()) + modelName;
    }

    @Override
    public AntBuildFileBase getBuildFile() {
        return (AntBuildFileBase)this.myFile;
    }

    @Override
    @Nullable
    public AntBuildTargetBase findTarget(final String name) {
        return (AntBuildTargetBase)ApplicationManager.getApplication().runReadAction((Computable)new Computable<AntBuildTargetBase>(){

            @Nullable
            public AntBuildTargetBase compute() {
                return AntBuildModelImpl.findTargetImpl(name, AntBuildModelImpl.this);
            }
        });
    }

    @Override
    @Nullable
    public BuildTask findTask(String targetName, String taskName) {
        AntBuildTargetBase buildTarget = this.findTarget(targetName);
        return buildTarget == null ? null : buildTarget.findTask(taskName);
    }

    @Override
    public AntDomProject getAntProject() {
        return AntSupport.getAntDomProject((PsiFile)this.getBuildFile().getAntFile());
    }

    @Override
    public boolean hasTargetWithActionId(String id) {
        List<AntBuildTargetBase> targetsList = this.getTargetsList();
        for (AntBuildTargetBase buildTarget : targetsList) {
            if (!id.equals(buildTarget.getActionId())) continue;
            return true;
        }
        return false;
    }

    private List<AntBuildTargetBase> getTargetsList() {
        return (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<AntBuildTargetBase>>(){

            public List<AntBuildTargetBase> compute() {
                return (List)AntBuildModelImpl.this.myTargets.getValue();
            }
        });
    }

    @Nullable
    private static AntBuildTargetBase findTargetImpl(String name, AntBuildModelImpl model) {
        List buildTargetBases = (List)model.myTargets.getValue();
        for (AntBuildTargetBase targetBase : buildTargetBases) {
            if (!Comparing.strEqual((String)targetBase.getName(), (String)name)) continue;
            return targetBase;
        }
        return null;
    }

    private static Pair<List<AntBuildTargetBase>, Collection<Object>> getTargetListImpl(AntBuildModelBase model) {
        ArrayList list = new ArrayList();
        final HashSet<Object> dependencies = new HashSet<Object>();
        AntDomProject project = model.getAntProject();
        if (project != null) {
            AntBuildFile buildFile = model.getBuildFile();
            XmlFile xmlFile = buildFile.getAntFile();
            dependencies.add(xmlFile != null ? xmlFile : PsiModificationTracker.MODIFICATION_COUNT);
            VirtualFile sourceFile = buildFile.getVirtualFile();
            (new Object(){
                private boolean myIsImported = false;
                private final Set<VirtualFile> myProcessed = new HashSet<VirtualFile>();
                private AntDomTarget myDefaultTarget = null;

                private void fillTargets(List<AntBuildTargetBase> list, AntBuildModelBase model, AntDomProject project, VirtualFile sourceFile) {
                    TargetResolver.Result result;
                    if (this.myProcessed.contains(sourceFile)) {
                        return;
                    }
                    this.myProcessed.add(sourceFile);
                    if (!this.myIsImported && (result = (TargetResolver.Result)project.getDefaultTarget().getValue()) != null) {
                        Pair<AntDomTarget, String> targetWithName = result.getResolvedTarget(project.getDefaultTarget().getRawText());
                        this.myDefaultTarget = targetWithName != null ? (AntDomTarget)targetWithName.getFirst() : null;
                    }
                    for (AntDomTarget target : project.getDeclaredTargets()) {
                        list.add(new AntBuildTargetImpl(target, model, sourceFile, this.myIsImported, target.equals(this.myDefaultTarget)));
                    }
                    this.myIsImported = true;
                    Iterable allIncludes = ContainerUtil.concat((Iterable[])new Iterable[]{project.getDeclaredImports(), project.getDeclaredIncludes()});
                    for (AntDomIncludingDirective incl : allIncludes) {
                        PsiFileSystemItem includedFile = (PsiFileSystemItem)incl.getFile().getValue();
                        if (includedFile instanceof PsiFile) {
                            PsiFile included = includedFile.getContainingFile().getOriginalFile();
                            dependencies.add(included);
                            AntDomProject includedProject = AntSupport.getAntDomProject((PsiFile)includedFile);
                            if (includedProject == null) continue;
                            this.fillTargets(list, model, includedProject, included.getVirtualFile());
                            continue;
                        }
                        if (includedFile != null) continue;
                        dependencies.add(PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
                    }
                }
            }).fillTargets(list, model, project, sourceFile);
        }
        if (dependencies.isEmpty()) {
            dependencies.add(PsiModificationTracker.MODIFICATION_COUNT);
        }
        return new Pair(list, dependencies);
    }
}

