/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.internal.Factory;
import org.gradle.internal.Transformers;
import org.gradle.model.internal.core.IdentityModelProjection;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ProjectionBackedModelCreator;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelCreators {
    public static <T> Builder<T> of(ModelReference<? super T> modelReference, T instance) {
        return new Builder(modelReference, Transformers.constant(instance)).withIdentityProjection();
    }

    public static <T> Builder<T> of(ModelReference<? super T> modelReference, Factory<? extends T> factory) {
        return new Builder(modelReference, Transformers.toTransformer(factory)).withIdentityProjection();
    }

    public static <T> Builder<T> of(ModelReference<? super T> modelReference, Transformer<? extends T, ? super Inputs> transformer) {
        return new Builder(modelReference, transformer).withIdentityProjection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<T> {
        private final Transformer<? extends T, ? super Inputs> transformer;
        private final ModelReference<? super T> modelReference;
        private final ImmutableList.Builder<ModelProjection<? super T>> projections = ImmutableList.builder();
        private ModelRuleDescriptor modelRuleDescriptor;
        private List<ModelReference<?>> inputs = Collections.emptyList();

        private Builder(ModelReference<? super T> modelReference, Transformer<? extends T, ? super Inputs> transformer) {
            this.modelReference = modelReference;
            this.transformer = transformer;
        }

        public Builder<T> simpleDescriptor(String descriptor) {
            this.modelRuleDescriptor = new SimpleModelRuleDescriptor(descriptor);
            return this;
        }

        public Builder<T> descriptor(ModelRuleDescriptor descriptor) {
            this.modelRuleDescriptor = descriptor;
            return this;
        }

        public Builder<T> inputs(List<ModelReference<?>> inputs) {
            this.inputs = inputs;
            return this;
        }

        public Builder<T> withIdentityProjection() {
            this.projections.add(new IdentityModelProjection<T>(this.modelReference.getType(), true, true));
            return this;
        }

        public Builder<T> withProjection(ModelProjection<? super T> projection) {
            this.projections.add(projection);
            return this;
        }

        public ModelCreator build() {
            return new ProjectionBackedModelCreator<T>(this.modelReference.getPath(), this.modelRuleDescriptor, this.inputs, this.projections.build(), this.transformer);
        }
    }
}

