/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitBranch;
import git4idea.branch.DeepComparatorHolder;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import gnu.trove.TIntHashSet;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeepComparator
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DeepComparator.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final VcsLogUi myUi;
    @NotNull
    private final VcsLogListener myLogListener;
    @Nullable
    private VcsLogHighlighter myHighlighter;
    @Nullable
    private MyTask myTask;

    @NotNull
    public static DeepComparator getInstance(@NotNull Project project, @NotNull VcsLogUi ui) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/DeepComparator", "getInstance"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "git4idea/branch/DeepComparator", "getInstance"));
        }
        DeepComparatorHolder holder = (DeepComparatorHolder)ServiceManager.getService((Project)project, DeepComparatorHolder.class);
        DeepComparator deepComparator = holder.getInstance(ui);
        if (deepComparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/DeepComparator", "getInstance"));
        }
        return deepComparator;
    }

    DeepComparator(@NotNull Project project, @NotNull GitRepositoryManager manager, @NotNull VcsLogUi ui, @NotNull Disposable parent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/DeepComparator", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "git4idea/branch/DeepComparator", "<init>"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "git4idea/branch/DeepComparator", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "git4idea/branch/DeepComparator", "<init>"));
        }
        this.myProject = project;
        this.myRepositoryManager = manager;
        this.myUi = ui;
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myLogListener = new VcsLogListener(){

            public void onChange(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
                if (dataPack == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "git4idea/branch/DeepComparator$1", "onChange"));
                }
                if (DeepComparator.this.myTask == null) {
                    return;
                }
                if (refreshHappened) {
                    String comparedBranch = DeepComparator.this.myTask.myComparedBranch;
                    Map repositoriesWithCurrentBranches = DeepComparator.this.myTask.myRepositoriesWithCurrentBranches;
                    VcsLogDataProvider provider = DeepComparator.this.myTask.myProvider;
                    DeepComparator.this.stopTask();
                    Map repositories = DeepComparator.this.getRepositories(DeepComparator.this.myUi.getDataPack().getLogProviders(), comparedBranch);
                    if (((Object)repositories).equals(repositoriesWithCurrentBranches)) {
                        DeepComparator.this.highlightInBackground(comparedBranch, provider);
                    }
                } else {
                    VcsLogBranchFilter branchFilter = DeepComparator.this.myUi.getFilterUi().getFilters().getBranchFilter();
                    if (branchFilter == null || branchFilter.getBranchNames().size() != 1 || !((String)branchFilter.getBranchNames().iterator().next()).equals(DeepComparator.this.myTask.myComparedBranch)) {
                        DeepComparator.this.stopAndUnhighlight();
                    }
                }
            }
        };
        this.myUi.addLogListener(this.myLogListener);
    }

    public void highlightInBackground(@NotNull String branchToCompare, @NotNull VcsLogDataProvider dataProvider) {
        if (branchToCompare == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchToCompare", "git4idea/branch/DeepComparator", "highlightInBackground"));
        }
        if (dataProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "git4idea/branch/DeepComparator", "highlightInBackground"));
        }
        if (this.myTask != null) {
            LOG.error("Shouldn't be possible");
            return;
        }
        Map<GitRepository, GitBranch> repositories = this.getRepositories(this.myUi.getDataPack().getLogProviders(), branchToCompare);
        if (repositories.isEmpty()) {
            this.removeHighlighting();
            return;
        }
        this.myTask = new MyTask(this.myProject, this.myUi, repositories, dataProvider, branchToCompare);
        this.myTask.queue();
    }

    @NotNull
    private Map<GitRepository, GitBranch> getRepositories(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull String branchToCompare) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "git4idea/branch/DeepComparator", "getRepositories"));
        }
        if (branchToCompare == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchToCompare", "git4idea/branch/DeepComparator", "getRepositories"));
        }
        HashMap repos = ContainerUtil.newHashMap();
        for (VirtualFile root : providers.keySet()) {
            GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
            if (repository == null || repository.getCurrentBranch() == null || repository.getBranches().findBranchByName(branchToCompare) == null) continue;
            repos.put(repository, repository.getCurrentBranch());
        }
        HashMap hashMap = repos;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/DeepComparator", "getRepositories"));
        }
        return hashMap;
    }

    public void stopAndUnhighlight() {
        this.stopTask();
        this.removeHighlighting();
    }

    private void stopTask() {
        if (this.myTask != null) {
            this.myTask.cancel();
            this.myTask = null;
        }
    }

    private void removeHighlighting() {
        if (this.myHighlighter != null) {
            this.myUi.removeHighlighter(this.myHighlighter);
        }
    }

    public void dispose() {
        this.stopAndUnhighlight();
        this.myUi.removeLogListener(this.myLogListener);
    }

    public boolean hasHighlightingOrInProgress() {
        return this.myTask != null;
    }

    private class MyTask
    extends Task.Backgroundable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VcsLogUi myUi;
        @NotNull
        private final Map<GitRepository, GitBranch> myRepositoriesWithCurrentBranches;
        @NotNull
        private final VcsLogDataProvider myProvider;
        @NotNull
        private final String myComparedBranch;
        @NotNull
        private final TIntHashSet myNonPickedCommits;
        @Nullable
        private VcsException myException;
        private boolean myCancelled;

        public MyTask(@NotNull Project project, @NotNull VcsLogUi ui, @NotNull Map<GitRepository, GitBranch> repositoriesWithCurrentBranches, @NotNull VcsLogDataProvider dataProvider, String branchToCompare) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/DeepComparator$MyTask", "<init>"));
            }
            if (ui == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "git4idea/branch/DeepComparator$MyTask", "<init>"));
            }
            if (repositoriesWithCurrentBranches == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoriesWithCurrentBranches", "git4idea/branch/DeepComparator$MyTask", "<init>"));
            }
            if (dataProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "git4idea/branch/DeepComparator$MyTask", "<init>"));
            }
            if (branchToCompare == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchToCompare", "git4idea/branch/DeepComparator$MyTask", "<init>"));
            }
            super(project, "Comparing branches...");
            this.myNonPickedCommits = new TIntHashSet();
            this.myProject = project;
            this.myUi = ui;
            this.myRepositoriesWithCurrentBranches = repositoriesWithCurrentBranches;
            this.myProvider = dataProvider;
            this.myComparedBranch = branchToCompare;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/DeepComparator$MyTask", "run"));
            }
            try {
                for (Map.Entry<GitRepository, GitBranch> entry : this.myRepositoriesWithCurrentBranches.entrySet()) {
                    GitRepository repo = entry.getKey();
                    GitBranch currentBranch = entry.getValue();
                    this.myNonPickedCommits.addAll(this.getNonPickedCommitsFromGit(this.myProject, repo.getRoot(), this.myProvider, currentBranch.getName(), this.myComparedBranch).toArray());
                }
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
                this.myException = e;
            }
        }

        public void onSuccess() {
            if (this.myCancelled) {
                return;
            }
            DeepComparator.this.removeHighlighting();
            if (this.myException != null) {
                VcsNotifier.getInstance((Project)this.myProject).notifyError("Couldn't compare with branch " + this.myComparedBranch, this.myException.getMessage());
                return;
            }
            DeepComparator.this.myHighlighter = new VcsLogHighlighter(){

                @NotNull
                public VcsLogHighlighter.VcsCommitStyle getStyle(int commitIndex, boolean isSelected) {
                    VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.foreground((Color)(!MyTask.this.myNonPickedCommits.contains(commitIndex) ? JBColor.GRAY : null));
                    if (vcsCommitStyle == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/DeepComparator$MyTask$1", "getStyle"));
                    }
                    return vcsCommitStyle;
                }
            };
            this.myUi.addHighlighter(DeepComparator.this.myHighlighter);
        }

        public void cancel() {
            this.myCancelled = true;
        }

        @NotNull
        private TIntHashSet getNonPickedCommitsFromGit(@NotNull Project project, @NotNull VirtualFile root, final @NotNull VcsLogDataProvider dataProvider, @NotNull String currentBranch, @NotNull String comparedBranch) throws VcsException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/DeepComparator$MyTask", "getNonPickedCommitsFromGit"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/branch/DeepComparator$MyTask", "getNonPickedCommitsFromGit"));
            }
            if (dataProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "git4idea/branch/DeepComparator$MyTask", "getNonPickedCommitsFromGit"));
            }
            if (currentBranch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentBranch", "git4idea/branch/DeepComparator$MyTask", "getNonPickedCommitsFromGit"));
            }
            if (comparedBranch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparedBranch", "git4idea/branch/DeepComparator$MyTask", "getNonPickedCommitsFromGit"));
            }
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.CHERRY);
            handler.addParameters(currentBranch, comparedBranch);
            final TIntHashSet pickedCommits = new TIntHashSet();
            handler.addLineListener(new GitLineHandlerAdapter(){

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    if (line.startsWith("+")) {
                        try {
                            line = line.substring(2).trim();
                            int firstSpace = line.indexOf(32);
                            if (firstSpace > 0) {
                                line = line.substring(0, firstSpace);
                            }
                            Hash hash = HashImpl.build((String)line);
                            pickedCommits.add(dataProvider.getCommitIndex(hash));
                        }
                        catch (Exception e) {
                            LOG.error("Couldn't parse line [" + line + "]");
                        }
                    }
                }
            });
            handler.runInCurrentThread(null);
            TIntHashSet tIntHashSet = pickedCommits;
            if (tIntHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/DeepComparator$MyTask", "getNonPickedCommitsFromGit"));
            }
            return tIntHashSet;
        }
    }
}

