/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ExternalInfo;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.SchemeElement;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompoundScheme<T extends SchemeElement>
implements ExternalizableScheme {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.options.CompoundScheme");
    protected String myName;
    private final List<T> myElements = new ArrayList<T>();
    private final ExternalInfo myExternalInfo = new ExternalInfo();

    public CompoundScheme(String name) {
        this.myName = name;
    }

    public void addElement(T t) {
        if (!this.contains(t)) {
            this.myElements.add(t);
        }
    }

    public void insertElement(T element, int i) {
        if (!this.contains(element)) {
            this.myElements.add(i, element);
        }
    }

    public List<T> getElements() {
        return Collections.unmodifiableList(new ArrayList<T>(this.myElements));
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/CompoundScheme", "getName"));
        }
        return string;
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/options/CompoundScheme", "setName"));
        }
        this.myName = name;
        for (SchemeElement template : this.myElements) {
            template.setGroupName(name);
        }
    }

    public void removeElement(T template) {
        Iterator<T> templateIterator = this.myElements.iterator();
        while (templateIterator.hasNext()) {
            SchemeElement t = (SchemeElement)templateIterator.next();
            if (t.getKey() == null || !t.getKey().equals(template.getKey())) continue;
            templateIterator.remove();
        }
    }

    public boolean isEmpty() {
        return this.myElements.isEmpty();
    }

    @Override
    @NotNull
    public ExternalInfo getExternalInfo() {
        ExternalInfo externalInfo = this.myExternalInfo;
        if (externalInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/CompoundScheme", "getExternalInfo"));
        }
        return externalInfo;
    }

    public CompoundScheme copy() {
        CompoundScheme result = this.createNewInstance(this.getName());
        for (SchemeElement element : this.myElements) {
            result.addElement(element.copy());
        }
        result.getExternalInfo().copy(this.getExternalInfo());
        return result;
    }

    private CompoundScheme createNewInstance(String name) {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(String.class);
            return (CompoundScheme)constructor.newInstance(name);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean contains(T element) {
        for (SchemeElement t : this.myElements) {
            if (t.getKey() == null || !t.getKey().equals(element.getKey())) continue;
            return true;
        }
        return false;
    }
}

