/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.rules.UsageGroupBase;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageInFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NonCodeUsageGroupingRule
implements UsageGroupingRule {
    private final GeneratedSourcesFilter[] myGeneratedSourcesFilters;
    private final Project myProject;

    public NonCodeUsageGroupingRule(Project project) {
        this.myProject = project;
        this.myGeneratedSourcesFilters = (GeneratedSourcesFilter[])GeneratedSourcesFilter.EP_NAME.getExtensions();
    }

    @Override
    public UsageGroup groupUsage(@NotNull Usage usage) {
        VirtualFile file;
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule", "groupUsage"));
        }
        if (usage instanceof UsageInFile && (file = ((UsageInFile)usage).getFile()) != null) {
            for (GeneratedSourcesFilter filter : this.myGeneratedSourcesFilters) {
                if (!filter.isGeneratedSource(file, this.myProject)) continue;
                return UsageInGeneratedCodeGroup.INSTANCE;
            }
        }
        if (usage instanceof PsiElementUsage) {
            UsageInfo usageInfo;
            if (usage instanceof UsageInfo2UsageAdapter && (usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo()).isDynamicUsage()) {
                return DynamicUsageGroup.INSTANCE;
            }
            if (((PsiElementUsage)usage).isNonCodeUsage()) {
                return NonCodeUsageGroup.INSTANCE;
            }
            return CodeUsageGroup.INSTANCE;
        }
        return null;
    }

    private static class DynamicUsageGroup
    extends UsageGroupBase {
        public static final UsageGroup INSTANCE = new DynamicUsageGroup();
        @NonNls
        private static final String DYNAMIC_CAPTION = "Dynamic usages";

        private DynamicUsageGroup() {
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            if (view == null) {
                if (DYNAMIC_CAPTION == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$DynamicUsageGroup", "getText"));
                }
                return DYNAMIC_CAPTION;
            }
            String dynamicCodeUsagesString = view.getPresentation().getDynamicCodeUsagesString();
            String string = dynamicCodeUsagesString == null ? DYNAMIC_CAPTION : dynamicCodeUsagesString;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$DynamicUsageGroup", "getText"));
            }
            return string;
        }

        public String toString() {
            return "DynamicUsages";
        }

        @Override
        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageGroup", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$DynamicUsageGroup", "compareTo"));
            }
            return usageGroup == this ? 0 : 1;
        }
    }

    private static class NonCodeUsageGroup
    extends UsageGroupBase {
        public static final UsageGroup INSTANCE = new NonCodeUsageGroup();

        private NonCodeUsageGroup() {
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = view == null ? UsageViewBundle.message("node.group.code.usages", new Object[0]) : view.getPresentation().getNonCodeUsagesString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$NonCodeUsageGroup", "getText"));
            }
            return string;
        }

        @Override
        public void update() {
        }

        public String toString() {
            return "NonCodeUsages";
        }

        @Override
        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageGroup", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$NonCodeUsageGroup", "compareTo"));
            }
            return usageGroup == this ? 0 : -1;
        }
    }

    private static class UsageInGeneratedCodeGroup
    extends UsageGroupBase {
        public static final UsageGroup INSTANCE = new UsageInGeneratedCodeGroup();

        private UsageInGeneratedCodeGroup() {
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = view == null ? UsageViewBundle.message("node.usages.in.generated.code", new Object[0]) : view.getPresentation().getUsagesInGeneratedCodeString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$UsageInGeneratedCodeGroup", "getText"));
            }
            return string;
        }

        public String toString() {
            return "UsagesInGeneratedCode";
        }

        @Override
        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageGroup", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$UsageInGeneratedCodeGroup", "compareTo"));
            }
            return usageGroup == this ? 0 : -1;
        }
    }

    private static class CodeUsageGroup
    extends UsageGroupBase {
        private static final UsageGroup INSTANCE = new CodeUsageGroup();

        private CodeUsageGroup() {
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = view == null ? UsageViewBundle.message("node.group.code.usages", new Object[0]) : view.getPresentation().getCodeUsagesString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$CodeUsageGroup", "getText"));
            }
            return string;
        }

        public String toString() {
            return "CodeUsages";
        }

        @Override
        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageGroup", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$CodeUsageGroup", "compareTo"));
            }
            if (usageGroup instanceof DynamicUsageGroup) {
                return -1;
            }
            return usageGroup == this ? 0 : 1;
        }
    }
}

