/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.AddAndroidActivityPath;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.TemplateEntry;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TemplateListProvider
extends ScopedDataBinder.ValueDeriver<TemplateEntry[]> {
    private final TemplateEntry[] myTemplates;

    public TemplateListProvider(@Nullable String formFactor, @NotNull Set<String> categories, @NotNull Set<String> excluded) {
        if (categories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "categories", "com/android/tools/idea/wizard/TemplateListProvider", "<init>"));
        }
        if (excluded == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excluded", "com/android/tools/idea/wizard/TemplateListProvider", "<init>"));
        }
        ArrayList templates = Lists.newArrayList();
        for (String category : categories) {
            templates.addAll(Arrays.asList(TemplateListProvider.getTemplateList(formFactor, category, excluded)));
        }
        Collections.sort(templates, new Comparator<TemplateEntry>(){

            @Override
            public int compare(TemplateEntry o1, TemplateEntry o2) {
                TemplateMetadata m1 = o1.getMetadata();
                TemplateMetadata m2 = o2.getMetadata();
                return StringUtil.naturalCompare((String)m1.getTitle(), (String)m2.getTitle());
            }
        });
        this.myTemplates = templates.toArray(new TemplateEntry[templates.size()]);
    }

    private static TemplateEntry[] getTemplateList(@Nullable String formFactor, @NotNull String category, @Nullable Set<String> excluded) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/android/tools/idea/wizard/TemplateListProvider", "getTemplateList"));
        }
        TemplateManager manager = TemplateManager.getInstance();
        List<File> templates = manager.getTemplatesInCategory(category);
        ArrayList<TemplateEntry> metadataList = new ArrayList<TemplateEntry>(templates.size());
        for (File template : templates) {
            TemplateMetadata metadata = manager.getTemplate(template);
            if (metadata == null || !metadata.isSupported() || excluded != null && excluded.contains(metadata.getTitle()) || formFactor != null && !formFactor.equalsIgnoreCase(metadata.getFormFactor())) continue;
            metadataList.add(new TemplateEntry(template, metadata));
        }
        return (TemplateEntry[])ArrayUtil.toObjectArray(metadataList, TemplateEntry.class);
    }

    @Override
    @Nullable
    public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
        return ImmutableSet.of(AddAndroidActivityPath.KEY_IS_LAUNCHER);
    }

    @Override
    @NotNull
    public TemplateEntry[] deriveValue(ScopedStateStore state, ScopedStateStore.Key changedKey, @Nullable TemplateEntry[] currentValue) {
        Boolean isLauncher = state.get(AddAndroidActivityPath.KEY_IS_LAUNCHER);
        if (!Boolean.TRUE.equals(isLauncher)) {
            if (this.myTemplates == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/TemplateListProvider", "deriveValue"));
            }
            return this.myTemplates;
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)this.myTemplates.length);
        for (TemplateEntry entry : Arrays.asList(this.myTemplates)) {
            if (entry.getMetadata().getParameter("isLauncher") == null) continue;
            list.add(entry);
        }
        TemplateEntry[] templateEntryArray = (TemplateEntry[])ArrayUtil.toObjectArray((Collection)list, TemplateEntry.class);
        if (templateEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/TemplateListProvider", "deriveValue"));
        }
        return templateEntryArray;
    }
}

