/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.execution.ParametersListUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.execution.cmd.GradleCommandLineOptionsConverter;
import org.jetbrains.plugins.gradle.service.task.ExecuteGradleTaskHistoryService;
import org.jetbrains.plugins.gradle.service.task.GradleRunTaskDialog;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleExecuteTaskAction
extends ExternalSystemAction {
    protected boolean isVisible(AnActionEvent e) {
        if (!super.isVisible(e)) {
            return false;
        }
        return GradleConstants.SYSTEM_ID.equals((Object)this.getSystemId(e));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ExternalTaskExecutionInfo taskExecutionInfo;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/action/GradleExecuteTaskAction", "actionPerformed"));
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ExecuteGradleTaskHistoryService historyService = ExecuteGradleTaskHistoryService.getInstance(project);
        GradleRunTaskDialog dialog = new GradleRunTaskDialog(project, historyService.getHistory());
        String lastWorkingDirectory = historyService.getWorkDirectory();
        if (lastWorkingDirectory.length() == 0) {
            lastWorkingDirectory = GradleExecuteTaskAction.obtainAppropriateWorkingDirectory(e);
        }
        dialog.setWorkDirectory(lastWorkingDirectory);
        if (StringUtil.isEmptyOrSpaces((String)historyService.getCanceledCommand())) {
            if (historyService.getHistory().size() > 0) {
                dialog.setCommandLine(historyService.getHistory().get(0));
            }
        } else {
            dialog.setCommandLine(historyService.getCanceledCommand());
        }
        if (!dialog.showAndGet()) {
            historyService.setCanceledCommand(dialog.getCommandLine());
            return;
        }
        historyService.setCanceledCommand(null);
        String fullCommandLine = dialog.getCommandLine();
        fullCommandLine = fullCommandLine.trim();
        String workDirectory = dialog.getWorkDirectory();
        historyService.addCommand(fullCommandLine, workDirectory);
        try {
            taskExecutionInfo = GradleExecuteTaskAction.buildTaskInfo(workDirectory, fullCommandLine);
        }
        catch (CommandLineArgumentException ex) {
            NotificationData notificationData = new NotificationData("<b>Command-line arguments cannot be parsed</b>", "<i>" + fullCommandLine + "</i> \n" + ex.getMessage(), NotificationCategory.WARNING, NotificationSource.TASK_EXECUTION);
            notificationData.setBalloonNotification(true);
            ExternalSystemNotificationManager.getInstance((Project)project).showNotification(GradleConstants.SYSTEM_ID, notificationData);
            return;
        }
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)project);
        ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)taskExecutionInfo.getSettings(), (String)taskExecutionInfo.getExecutorId(), (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        RunnerAndConfigurationSettings configuration = ExternalSystemUtil.createExternalSystemRunnerAndConfigurationSettings((ExternalSystemTaskExecutionSettings)taskExecutionInfo.getSettings(), (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        if (configuration == null) {
            return;
        }
        RunnerAndConfigurationSettings existingConfiguration = runManager.findConfigurationByName(configuration.getName());
        if (existingConfiguration == null) {
            runManager.setTemporaryConfiguration(configuration);
        } else {
            runManager.setSelectedConfiguration(existingConfiguration);
        }
    }

    private static ExternalTaskExecutionInfo buildTaskInfo(@NotNull String projectPath, @NotNull String fullCommandLine) throws CommandLineArgumentException {
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "org/jetbrains/plugins/gradle/action/GradleExecuteTaskAction", "buildTaskInfo"));
        }
        if (fullCommandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullCommandLine", "org/jetbrains/plugins/gradle/action/GradleExecuteTaskAction", "buildTaskInfo"));
        }
        CommandLineParser gradleCmdParser = new CommandLineParser();
        GradleCommandLineOptionsConverter commandLineConverter = new GradleCommandLineOptionsConverter();
        commandLineConverter.configure(gradleCmdParser);
        ParsedCommandLine parsedCommandLine = gradleCmdParser.parse((Iterable)ParametersListUtil.parse((String)fullCommandLine, (boolean)true));
        Map<String, List<String>> optionsMap = commandLineConverter.convert(parsedCommandLine, new HashMap<String, List<String>>());
        List<String> systemProperties = optionsMap.remove("system-prop");
        String vmOptions = systemProperties == null ? "" : StringUtil.join(systemProperties, (Function)new Function<String, String>(){

            public String fun(String entry) {
                return "-D" + entry;
            }
        }, (String)" ");
        String scriptParameters = StringUtil.join(optionsMap.entrySet(), (Function)new Function<Map.Entry<String, List<String>>, String>(){

            public String fun(Map.Entry<String, List<String>> entry) {
                List<String> values = entry.getValue();
                final String longOptionName = entry.getKey();
                if (values != null && !values.isEmpty()) {
                    return StringUtil.join(values, (Function)new Function<String, String>(){

                        public String fun(String entry) {
                            return "--" + longOptionName + ' ' + entry;
                        }
                    }, (String)" ");
                }
                return "--" + longOptionName;
            }
        }, (String)" ");
        List tasks = parsedCommandLine.getExtraArguments();
        ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
        settings.setExternalProjectPath(projectPath);
        settings.setTaskNames(tasks);
        settings.setScriptParameters(scriptParameters);
        settings.setVmOptions(vmOptions);
        settings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.toString());
        return new ExternalTaskExecutionInfo(settings, DefaultRunExecutor.EXECUTOR_ID);
    }

    private static String obtainAppropriateWorkingDirectory(AnActionEvent e) {
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null || selectedNodes.size() != 1) {
            Module module = ExternalSystemActionUtil.getModule((DataContext)e.getDataContext());
            String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
            return projectPath == null ? "" : projectPath;
        }
        ExternalSystemNode node = (ExternalSystemNode)selectedNodes.get(0);
        Object externalData = node.getData();
        if (externalData instanceof ExternalConfigPathAware) {
            return ((ExternalConfigPathAware)externalData).getLinkedExternalProjectPath();
        }
        ExternalConfigPathAware parentExternalConfigPathAware = (ExternalConfigPathAware)node.findParentData(ExternalConfigPathAware.class);
        return parentExternalConfigPathAware != null ? parentExternalConfigPathAware.getLinkedExternalProjectPath() : "";
    }
}

