/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gpp;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;

public class GppImplicitUsageProvider
implements ImplicitUsageProvider {
    private static boolean isGppMetaMethod(PsiMethod method) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length == 0 || !parameters[0].getType().equalsToText("java.lang.String")) {
            return false;
        }
        if ("invokeUnresolvedMethod".equals(method.getName())) {
            return true;
        }
        if ("getUnresolvedProperty".equals(method.getName())) {
            return parameters.length == 1;
        }
        if ("setUnresolvedProperty".equals(method.getName())) {
            return parameters.length == 2;
        }
        return false;
    }

    public boolean isImplicitUsage(PsiElement element) {
        return element instanceof PsiMethod && GppImplicitUsageProvider.isGppMetaMethod((PsiMethod)element);
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        return false;
    }
}

