/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ControlFlowBuilderUtil;

public class RemoveUnnecessaryReturnIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/style/RemoveUnnecessaryReturnIntention", "processIntention"));
        }
        if (element instanceof GrReturnStatement && ((GrReturnStatement)element).getReturnValue() != null) {
            GrExpression value = ((GrReturnStatement)element).getReturnValue();
            ((GrReturnStatement)element).replaceWithStatement(value);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                return element instanceof GrReturnStatement && ((GrReturnStatement)element).getReturnValue() != null && ControlFlowBuilderUtil.isCertainlyReturnStatement((GrStatement)element);
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/style/RemoveUnnecessaryReturnIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }
}

