/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.List;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.plugincomponents.EditorConfigNotifier;
import org.editorconfig.settings.EditorConfigSettings;

public class Utils {
    public static String configValueForKey(List<EditorConfig.OutPair> outPairs, String key) {
        for (EditorConfig.OutPair outPair : outPairs) {
            if (!outPair.getKey().equals(key)) continue;
            return outPair.getVal();
        }
        return "";
    }

    public static boolean isEnabled(CodeStyleSettings currentSettings) {
        return ((EditorConfigSettings)currentSettings.getCustomSettings(EditorConfigSettings.class)).ENABLED;
    }

    public static void invalidConfigMessage(Project project, String configValue, String configKey, String filePath) {
        String message = configValue != null ? "\"" + configValue + "\" is not a valid value" + (!configKey.isEmpty() ? " for " + configKey : "") + " for file " + filePath : "Failed to read .editorconfig file";
        configValue = configValue != null ? configValue : "ioError";
        EditorConfigNotifier.getInstance().error(project, configValue, message);
    }

    public static String getFilePath(Project project, VirtualFile file) {
        if (!file.isInLocalFileSystem()) {
            return project.getBasePath() + "/" + file.getNameWithoutExtension() + "." + file.getFileType().getDefaultExtension();
        }
        return file.getCanonicalPath();
    }
}

