/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AvdUiAction
implements Action,
HyperlinkListener {
    @NotNull
    protected final AvdInfoProvider myAvdInfoProvider;
    @NotNull
    private final String myText;
    @NotNull
    private final String myDescription;
    @NotNull
    private final Icon myIcon;
    private Map<String, Object> myData;

    public AvdUiAction(@NotNull AvdInfoProvider avdInfoProvider, @NotNull String text, @NotNull String description, @NotNull Icon icon) {
        if (avdInfoProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdInfoProvider", "com/android/tools/idea/avdmanager/AvdUiAction", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/avdmanager/AvdUiAction", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/avdmanager/AvdUiAction", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/avdmanager/AvdUiAction", "<init>"));
        }
        this.myData = Maps.newHashMap();
        this.myAvdInfoProvider = avdInfoProvider;
        this.myText = text;
        this.myIcon = icon;
        this.myDescription = description;
        this.putValue("SwingLargeIconKey", icon);
        this.putValue("Name", text);
    }

    @Override
    public Object getValue(String key) {
        return this.myData.get(key);
    }

    @Override
    public void putValue(String key, Object value) {
        this.myData.put(key, value);
    }

    @Override
    @Deprecated
    public void setEnabled(boolean b) {
    }

    @Override
    public abstract boolean isEnabled();

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdUiAction", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdUiAction", "getText"));
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdUiAction", "getIcon"));
        }
        return icon;
    }

    @Nullable
    protected AvdInfo getAvdInfo() {
        return this.myAvdInfoProvider.getAvdInfo();
    }

    protected void refreshAvds() {
        this.myAvdInfoProvider.refreshAvds();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        this.actionPerformed(null);
    }

    public static interface AvdInfoProvider {
        @Nullable
        public AvdInfo getAvdInfo();

        public void refreshAvds();

        public void notifyRun();

        @Nullable
        public Project getProject();
    }
}

