/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;

public class FileHolder {
    private final File myIoFile;
    private final VirtualFile myFile;
    private Boolean myIsDir;

    public FileHolder(File ioFile) {
        this.myIoFile = ioFile;
        this.myFile = null;
    }

    public FileHolder(VirtualFile file) {
        this.myFile = file;
        this.myIoFile = null;
    }

    public String getPath() {
        return this.myFile != null ? this.myFile.getPath() : this.myIoFile.getPath();
    }

    public String getName() {
        return this.myFile != null ? this.myFile.getName() : this.myIoFile.getName();
    }

    public boolean isDirectory() {
        if (this.myIsDir != null) {
            return this.myIsDir;
        }
        return this.myFile != null ? this.myFile.isDirectory() : this.myIoFile.isDirectory();
    }

    public boolean exists() {
        return this.myFile != null ? this.myFile.exists() : this.myIoFile.exists();
    }

    public boolean isValid() {
        return this.myFile != null ? this.myFile.isValid() : true;
    }

    public File getIoFile() {
        return this.myIoFile;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public boolean isVirtual() {
        return this.myFile != null;
    }

    public void setIsDir(boolean isDir) {
        this.myIsDir = isDir;
    }

    public String toString() {
        return "FileHolder{myIoFile=" + this.myIoFile + ", myFile=" + this.myFile + ", myIsDir=" + this.myIsDir + '}';
    }
}

