/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.vcs.log.VcsLogHighlighter;
import java.awt.Color;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCommitStyleFactory {
    public static VcsLogHighlighter.VcsCommitStyle createStyle(@Nullable Color foreground, @Nullable Color background) {
        return new VcsCommitStyleImpl(foreground, background);
    }

    @NotNull
    public static VcsLogHighlighter.VcsCommitStyle foreground(@Nullable Color foreground) {
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.createStyle(foreground, null);
        if (vcsCommitStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/VcsCommitStyleFactory", "foreground"));
        }
        return vcsCommitStyle;
    }

    @NotNull
    public static VcsLogHighlighter.VcsCommitStyle background(@Nullable Color background) {
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.createStyle(null, background);
        if (vcsCommitStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/VcsCommitStyleFactory", "background"));
        }
        return vcsCommitStyle;
    }

    @NotNull
    public static VcsLogHighlighter.VcsCommitStyle combine(@NotNull Collection<VcsLogHighlighter.VcsCommitStyle> styles) {
        if (styles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styles", "com/intellij/vcs/log/VcsCommitStyleFactory", "combine"));
        }
        Color foreground = null;
        Color background = null;
        for (VcsLogHighlighter.VcsCommitStyle style : styles) {
            if (foreground == null && style.getForeground() != null) {
                foreground = style.getForeground();
            }
            if (background == null && style.getBackground() != null) {
                background = style.getBackground();
            }
            if (background == null || foreground == null) continue;
            break;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.createStyle(foreground, background);
        if (vcsCommitStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/VcsCommitStyleFactory", "combine"));
        }
        return vcsCommitStyle;
    }

    private static class VcsCommitStyleImpl
    implements VcsLogHighlighter.VcsCommitStyle {
        @Nullable
        private final Color myForeground;
        @Nullable
        private final Color myBackground;

        public VcsCommitStyleImpl(@Nullable Color foreground, @Nullable Color background) {
            this.myForeground = foreground;
            this.myBackground = background;
        }

        @Override
        @Nullable
        public Color getForeground() {
            return this.myForeground;
        }

        @Override
        @Nullable
        public Color getBackground() {
            return this.myBackground;
        }
    }
}

