/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitSimpleHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeUtil;
import git4idea.util.GitUIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMergeDialog
extends DialogWrapper {
    private JComboBox myGitRoot;
    private JCheckBox myNoCommitCheckBox;
    private JCheckBox myNoFastForwardCheckBox;
    private JCheckBox mySquashCommitCheckBox;
    private JLabel myCurrentBranchText;
    private JPanel myBranchToMergeContainer;
    private ElementsChooser<String> myBranchChooser;
    private JTextField myCommitMessage;
    private JComboBox myStrategy;
    private JPanel myPanel;
    private JCheckBox myAddLogInformationCheckBox;
    @NotNull
    private final Project myProject;
    private final GitVcs myVcs;

    public GitMergeDialog(@NotNull Project project, List<VirtualFile> roots, VirtualFile defaultRoot) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/merge/GitMergeDialog", "<init>"));
        }
        super(project, true);
        this.$$$setupUI$$$();
        this.setTitle(GitBundle.getString("merge.branch.title"));
        this.myProject = project;
        this.myVcs = GitVcs.getInstance(project);
        this.initBranchChooser();
        this.setOKActionEnabled(false);
        this.setOKButtonText(GitBundle.getString("merge.branch.button"));
        GitUIUtil.setupRootChooser(this.myProject, roots, defaultRoot, this.myGitRoot, this.myCurrentBranchText);
        GitUIUtil.imply(this.mySquashCommitCheckBox, true, this.myNoCommitCheckBox, true);
        GitUIUtil.imply(this.mySquashCommitCheckBox, true, this.myAddLogInformationCheckBox, false);
        GitUIUtil.implyDisabled(this.mySquashCommitCheckBox, true, this.myCommitMessage);
        GitUIUtil.exclusive(this.mySquashCommitCheckBox, true, this.myNoFastForwardCheckBox, true);
        this.myGitRoot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                block2: {
                    try {
                        GitMergeDialog.this.updateBranches();
                    }
                    catch (VcsException ex) {
                        if (!GitMergeDialog.this.myVcs.getExecutableValidator().checkExecutableAndShowMessageIfNeeded(GitMergeDialog.this.getRootPane())) break block2;
                        GitMergeDialog.this.myVcs.showErrors(Collections.singletonList(ex), GitBundle.getString("merge.retrieving.branches"));
                    }
                }
            }
        });
        this.init();
    }

    private void initBranchChooser() {
        this.myBranchChooser = new ElementsChooser(true);
        this.myBranchChooser.setToolTipText(GitBundle.getString("merge.branches.tooltip"));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.myBranchToMergeContainer.add((Component)this.myBranchChooser, c);
        GitMergeUtil.setupStrategies(this.myBranchChooser, this.myStrategy);
        ElementsChooser.ElementsMarkListener<String> listener = new ElementsChooser.ElementsMarkListener<String>(){

            public void elementMarkChanged(String element, boolean isMarked) {
                GitMergeDialog.this.setOKActionEnabled(GitMergeDialog.this.myBranchChooser.getMarkedElements().size() != 0);
            }
        };
        listener.elementMarkChanged(null, true);
        this.myBranchChooser.addElementsMarkListener((ElementsChooser.ElementsMarkListener)listener);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myBranchChooser.getComponent();
    }

    public void updateBranches() throws VcsException {
        VirtualFile root = this.getSelectedRoot();
        GitSimpleHandler handler = new GitSimpleHandler(this.myProject, root, GitCommand.BRANCH);
        handler.setSilent(true);
        handler.addParameters("--no-color", "-a", "--no-merged");
        String output = handler.run();
        this.myBranchChooser.clear();
        StringTokenizer lines = new StringTokenizer(output, "\n", false);
        while (lines.hasMoreTokens()) {
            String branch = lines.nextToken().substring(2);
            this.myBranchChooser.addElement((Object)branch, false);
        }
    }

    public GitLineHandler handler() {
        String strategy;
        String msg;
        if (!this.isOK()) {
            throw new IllegalStateException("The handler could be retrieved only if dialog was completed successfully.");
        }
        VirtualFile root = (VirtualFile)this.myGitRoot.getSelectedItem();
        GitLineHandler h = new GitLineHandler(this.myProject, root, GitCommand.MERGE);
        h.ignoreErrorCode(1);
        if (this.myNoCommitCheckBox.isSelected()) {
            h.addParameters("--no-commit");
        }
        if (this.myAddLogInformationCheckBox.isSelected()) {
            h.addParameters("--log");
        }
        if ((msg = this.myCommitMessage.getText().trim()).length() != 0) {
            h.addParameters("-m", msg);
        }
        if (this.mySquashCommitCheckBox.isSelected()) {
            h.addParameters("--squash");
        }
        if (this.myNoFastForwardCheckBox.isSelected()) {
            h.addParameters("--no-ff");
        }
        if (!GitMergeUtil.DEFAULT_STRATEGY.equals(strategy = (String)this.myStrategy.getSelectedItem())) {
            h.addParameters("--strategy", strategy);
        }
        for (String branch : this.myBranchChooser.getMarkedElements()) {
            h.addParameters(branch);
        }
        return h;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.MergeBranches";
    }

    public VirtualFile getSelectedRoot() {
        return (VirtualFile)this.myGitRoot.getSelectedItem();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JTextField jTextField;
        JPanel jPanel;
        JLabel jLabel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JComboBox jComboBox2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGitRoot = jComboBox2 = new JComboBox();
        jComboBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root.tooltip"));
        jPanel2.add(jComboBox2, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.branches"));
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch"));
        jPanel2.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(4, 1, 1, 2, 0, 3, 3, 0, null, null, null));
        this.myNoCommitCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.no.commit"));
        jCheckBox4.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.no.commit.tooltip"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNoFastForwardCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.no.fast.forward"));
        jCheckBox3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.no.fast.forward.tooltip"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySquashCommitCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.squash.commit"));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.squash.tooltip"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAddLogInformationCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.add.log.information"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.add.log.information.tooltip"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCurrentBranchText = jLabel = new JLabel();
        jLabel.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch.tooltip"));
        jLabel.setText("");
        jPanel2.add((Component)jLabel, new GridConstraints(1, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myBranchToMergeContainer = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridConstraints(2, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setVerticalAlignment(0);
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.commit.message"));
        jPanel2.add((Component)jLabel5, new GridConstraints(5, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.strategy"));
        jPanel2.add((Component)jLabel6, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCommitMessage = jTextField = new JTextField();
        jTextField.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.commit.message.tooltip"));
        jPanel2.add((Component)jTextField, new GridConstraints(5, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myStrategy = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("<default>");
        jComboBox.setModel(defaultComboBoxModel);
        jComboBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.strategy.tooltip"));
        ((Component)jComboBox).setEnabled(false);
        jPanel2.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(3, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel2.setLabelFor(jComboBox2);
        jLabel5.setLabelFor(jTextField);
        jLabel6.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

