/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuiteListener;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.coverage.SrcFileAnnotator;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewSuiteListener;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsAdapter;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageDataManagerImpl
extends CoverageDataManager {
    private static final String REPLACE_ACTIVE_SUITES = "&Replace active suites";
    private static final String ADD_TO_ACTIVE_SUITES = "&Add to active suites";
    private static final String DO_NOT_APPLY_COLLECTED_COVERAGE = "Do not apply &collected coverage";
    private final List<CoverageSuiteListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Logger LOG = Logger.getInstance((String)("#" + CoverageDataManagerImpl.class.getName()));
    @NonNls
    private static final String SUITE = "SUITE";
    private final Project myProject;
    private final Set<CoverageSuite> myCoverageSuites = new HashSet();
    private boolean myIsProjectClosing = false;
    private final Object myLock = new Object();
    private boolean mySubCoverageIsActive;
    private CoverageSuitesBundle myCurrentSuitesBundle;
    private final Object ANNOTATORS_LOCK = new Object();
    private final Map<Editor, SrcFileAnnotator> myAnnotators = new HashMap();

    @Override
    public CoverageSuitesBundle getCurrentSuitesBundle() {
        return this.myCurrentSuitesBundle;
    }

    public CoverageDataManagerImpl(Project project) {
        this.myProject = project;
        EditorColorsManager.getInstance().addEditorColorsListener((EditorColorsListener)new EditorColorsAdapter(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                CoverageDataManagerImpl.this.chooseSuitesBundle(CoverageDataManagerImpl.this.myCurrentSuitesBundle);
            }
        }, (Disposable)project);
        this.addSuiteListener(new CoverageViewSuiteListener(this, this.myProject), (Disposable)this.myProject);
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("CoverageDataManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageDataManagerImpl", "getComponentName"));
        }
        return "CoverageDataManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void readExternal(Element element) throws InvalidDataException {
        for (Element suiteElement : element.getChildren(SUITE)) {
            CoverageEngine engine;
            CoverageRunner coverageRunner = BaseCoverageSuite.readRunnerAttribute(suiteElement);
            if (coverageRunner == null) {
                CoverageFileProvider fileProvider = BaseCoverageSuite.readDataFileProviderAttribute(suiteElement);
                if (!fileProvider.isValid()) continue;
                continue;
            }
            CoverageSuite suite = null;
            CoverageEngine[] arr$ = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
            int len$ = arr$.length;
            for (int i$ = 0; !(i$ >= len$ || coverageRunner.acceptsCoverageEngine(engine = arr$[i$]) && (suite = engine.createEmptyCoverageSuite(coverageRunner)) != null); ++i$) {
            }
            if (suite == null) continue;
            try {
                suite.readExternal(suiteElement);
                this.myCoverageSuites.add(suite);
            }
            catch (NumberFormatException e) {}
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (CoverageSuite coverageSuite : this.myCoverageSuites) {
            Element suiteElement = new Element(SUITE);
            element.addContent(suiteElement);
            coverageSuite.writeExternal(suiteElement);
        }
    }

    @Override
    public CoverageSuite addCoverageSuite(String name, CoverageFileProvider fileProvider, String[] filters, long lastCoverageTimeStamp, @Nullable String suiteToMergeWith, CoverageRunner coverageRunner, boolean collectLineInfo, boolean tracingEnabled) {
        CoverageSuite suite = this.createCoverageSuite(coverageRunner, name, fileProvider, filters, lastCoverageTimeStamp, suiteToMergeWith, collectLineInfo, tracingEnabled);
        if (suiteToMergeWith == null || !name.equals(suiteToMergeWith)) {
            this.removeCoverageSuite(suite);
        }
        this.myCoverageSuites.remove(suite);
        this.myCoverageSuites.add(suite);
        return suite;
    }

    @Override
    public CoverageSuite addExternalCoverageSuite(String selectedFileName, long timeStamp, CoverageRunner coverageRunner, CoverageFileProvider fileProvider) {
        CoverageSuite suite = this.createCoverageSuite(coverageRunner, selectedFileName, fileProvider, ArrayUtil.EMPTY_STRING_ARRAY, timeStamp, null, false, false);
        this.myCoverageSuites.add(suite);
        return suite;
    }

    @Override
    public CoverageSuite addCoverageSuite(CoverageEnabledConfiguration config) {
        String name = config.getName() + " Coverage Results";
        String covFilePath = config.getCoverageFilePath();
        assert (covFilePath != null);
        CoverageRunner coverageRunner = config.getCoverageRunner();
        LOG.assertTrue(coverageRunner != null, (Object)("Coverage runner id = " + config.getRunnerId()));
        DefaultCoverageFileProvider fileProvider = new DefaultCoverageFileProvider(new File(covFilePath));
        CoverageSuite suite = this.createCoverageSuite(config, name, coverageRunner, fileProvider);
        this.removeCoverageSuite(suite);
        this.myCoverageSuites.add(suite);
        return suite;
    }

    @Override
    public void removeCoverageSuite(CoverageSuite suite) {
        String fileName = suite.getCoverageDataFileName();
        boolean deleteTraces = suite.isTracingEnabled();
        if (!FileUtil.isAncestor((String)PathManager.getSystemPath(), (String)fileName, (boolean)false)) {
            String message = "Would you like to delete file '" + fileName + "' ";
            if (deleteTraces) {
                message = message + "and traces directory '" + FileUtil.getNameWithoutExtension((File)new File(fileName)) + "' ";
            }
            if (Messages.showYesNoDialog((Project)this.myProject, (String)(message = message + "on disk?"), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon()) == 0) {
                this.deleteCachedCoverage(fileName, deleteTraces);
            }
        } else {
            this.deleteCachedCoverage(fileName, deleteTraces);
        }
        this.myCoverageSuites.remove(suite);
        if (this.myCurrentSuitesBundle != null && this.myCurrentSuitesBundle.contains(suite)) {
            Object[] suites = this.myCurrentSuitesBundle.getSuites();
            this.chooseSuitesBundle((suites = (CoverageSuite[])ArrayUtil.remove((Object[])suites, (Object)suite)).length > 0 ? new CoverageSuitesBundle((CoverageSuite[])suites) : null);
        }
    }

    private void deleteCachedCoverage(String coverageDataFileName, boolean deleteTraces) {
        FileUtil.delete((File)new File(coverageDataFileName));
        if (deleteTraces) {
            FileUtil.delete((File)this.getTracesDirectory(coverageDataFileName));
        }
    }

    @Override
    public CoverageSuite[] getSuites() {
        return this.myCoverageSuites.toArray(new CoverageSuite[this.myCoverageSuites.size()]);
    }

    @Override
    public void chooseSuitesBundle(CoverageSuitesBundle suite) {
        if (this.myCurrentSuitesBundle == suite && suite == null) {
            return;
        }
        LOG.assertTrue(!this.myProject.isDefault());
        this.fireBeforeSuiteChosen();
        this.mySubCoverageIsActive = false;
        if (this.myCurrentSuitesBundle != null) {
            this.myCurrentSuitesBundle.getCoverageEngine().getCoverageAnnotator(this.myProject).onSuiteChosen(suite);
        }
        this.myCurrentSuitesBundle = suite;
        this.disposeAnnotators();
        if (suite == null) {
            this.triggerPresentationUpdate();
            return;
        }
        for (CoverageSuite coverageSuite : this.myCurrentSuitesBundle.getSuites()) {
            boolean suiteFileExists = coverageSuite.getCoverageDataFileProvider().ensureFileExists();
            if (suiteFileExists) continue;
            this.chooseSuitesBundle(null);
            return;
        }
        this.renewCoverageData(suite);
        this.fireAfterSuiteChosen();
    }

    @Override
    public void coverageGathered(final @NotNull CoverageSuite suite) {
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/coverage/CoverageDataManagerImpl", "coverageGathered"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CoverageDataManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (CoverageDataManagerImpl.this.myCurrentSuitesBundle != null) {
                    int answer;
                    String[] stringArray;
                    String message = CodeInsightBundle.message((String)"display.coverage.prompt", (Object[])new Object[]{suite.getPresentableName()});
                    final CoverageOptionsProvider coverageOptionsProvider = CoverageOptionsProvider.getInstance(CoverageDataManagerImpl.this.myProject);
                    DialogWrapper.DoNotAskOption doNotAskOption = new DialogWrapper.DoNotAskOption(){

                        public boolean isToBeShown() {
                            return coverageOptionsProvider.getOptionToReplace() == 3;
                        }

                        public void setToBeShown(boolean value, int exitCode) {
                            coverageOptionsProvider.setOptionsToReplace(value ? 3 : exitCode);
                        }

                        public boolean canBeHidden() {
                            return true;
                        }

                        public boolean shouldSaveOptionsOnCancel() {
                            return true;
                        }

                        @NotNull
                        public String getDoNotShowMessage() {
                            String string = CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                            if (string == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageDataManagerImpl$2$1", "getDoNotShowMessage"));
                            }
                            return string;
                        }
                    };
                    if (CoverageDataManagerImpl.this.myCurrentSuitesBundle.getCoverageEngine() == suite.getCoverageEngine()) {
                        String[] stringArray2 = new String[3];
                        stringArray2[0] = CoverageDataManagerImpl.REPLACE_ACTIVE_SUITES;
                        stringArray2[1] = CoverageDataManagerImpl.ADD_TO_ACTIVE_SUITES;
                        stringArray = stringArray2;
                        stringArray2[2] = CoverageDataManagerImpl.DO_NOT_APPLY_COLLECTED_COVERAGE;
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = CoverageDataManagerImpl.REPLACE_ACTIVE_SUITES;
                        stringArray = stringArray3;
                        stringArray3[1] = CoverageDataManagerImpl.DO_NOT_APPLY_COLLECTED_COVERAGE;
                    }
                    String[] options = stringArray;
                    int n = answer = doNotAskOption.isToBeShown() ? Messages.showDialog((String)message, (String)CodeInsightBundle.message((String)"code.coverage", (Object[])new Object[0]), (String[])options, (int)1, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption) : coverageOptionsProvider.getOptionToReplace();
                    if (answer == 0) {
                        CoverageDataManagerImpl.this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
                    } else if (answer == 1) {
                        CoverageDataManagerImpl.this.chooseSuitesBundle(new CoverageSuitesBundle((CoverageSuite[])ArrayUtil.append((Object[])CoverageDataManagerImpl.this.myCurrentSuitesBundle.getSuites(), (Object)suite)));
                    }
                } else {
                    CoverageDataManagerImpl.this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
                }
            }
        });
    }

    @Override
    public void triggerPresentationUpdate() {
        this.renewInformationInEditors();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (CoverageDataManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                ProjectView.getInstance((Project)CoverageDataManagerImpl.this.myProject).refresh();
                CoverageViewManager.getInstance(CoverageDataManagerImpl.this.myProject).setReady(true);
            }
        });
    }

    @Override
    public void attachToProcess(@NotNull ProcessHandler handler, final @NotNull RunConfigurationBase configuration, final RunnerSettings runnerSettings) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/coverage/CoverageDataManagerImpl", "attachToProcess"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/coverage/CoverageDataManagerImpl", "attachToProcess"));
        }
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                CoverageDataManagerImpl.this.processGatheredCoverage(configuration, runnerSettings);
            }
        });
    }

    @Override
    public void processGatheredCoverage(@NotNull RunConfigurationBase configuration, RunnerSettings runnerSettings) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/coverage/CoverageDataManagerImpl", "processGatheredCoverage"));
        }
        if (runnerSettings instanceof CoverageRunnerData) {
            CoverageDataManagerImpl.processGatheredCoverage(configuration);
        }
    }

    public static void processGatheredCoverage(RunConfigurationBase configuration) {
        Project project = configuration.getProject();
        if (project.isDisposed()) {
            return;
        }
        CoverageDataManager coverageDataManager = CoverageDataManager.getInstance(project);
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate(configuration);
        CoverageSuite coverageSuite = coverageEnabledConfiguration.getCurrentCoverageSuite();
        if (coverageSuite != null) {
            ((BaseCoverageSuite)coverageSuite).setConfiguration(configuration);
            coverageDataManager.coverageGathered(coverageSuite);
        }
    }

    protected void renewCoverageData(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/coverage/CoverageDataManagerImpl", "renewCoverageData"));
        }
        if (this.myCurrentSuitesBundle != null) {
            this.myCurrentSuitesBundle.getCoverageEngine().getCoverageAnnotator(this.myProject).renewCoverageData(suite, this);
        }
    }

    private void renewInformationInEditors() {
        VirtualFile[] openFiles;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        for (VirtualFile openFile : openFiles = fileEditorManager.getOpenFiles()) {
            FileEditor[] allEditors = fileEditorManager.getAllEditors(openFile);
            this.applyInformationToEditor(allEditors, openFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyInformationToEditor(FileEditor[] editors, final VirtualFile file) {
        PsiFile psiFile = this.doInReadActionIfProjectOpen(new Computable<PsiFile>(){

            @Nullable
            public PsiFile compute() {
                return PsiManager.getInstance((Project)CoverageDataManagerImpl.this.myProject).findFile(file);
            }
        });
        if (psiFile != null && this.myCurrentSuitesBundle != null && psiFile.isPhysical()) {
            SrcFileAnnotator annotator;
            Object object;
            Editor textEditor;
            CoverageEngine engine = this.myCurrentSuitesBundle.getCoverageEngine();
            if (!engine.coverageEditorHighlightingApplicableTo(psiFile)) {
                return;
            }
            for (FileEditor editor : editors) {
                if (!(editor instanceof TextEditor)) continue;
                textEditor = ((TextEditor)editor).getEditor();
                object = this.ANNOTATORS_LOCK;
                synchronized (object) {
                    annotator = this.myAnnotators.remove(textEditor);
                }
                if (annotator == null) break;
                Disposer.dispose((Disposable)annotator);
                break;
            }
            for (FileEditor editor : editors) {
                if (!(editor instanceof TextEditor)) continue;
                textEditor = ((TextEditor)editor).getEditor();
                annotator = this.getAnnotator(textEditor);
                if (annotator == null) {
                    annotator = new SrcFileAnnotator(psiFile, textEditor);
                    object = this.ANNOTATORS_LOCK;
                    synchronized (object) {
                        this.myAnnotators.put(textEditor, annotator);
                    }
                }
                if (this.myCurrentSuitesBundle == null || !engine.acceptedByFilters(psiFile, this.myCurrentSuitesBundle)) continue;
                annotator.showCoverageInformation(this.myCurrentSuitesBundle);
            }
        }
    }

    public void projectOpened() {
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new CoverageEditorFactoryListener(), (Disposable)this.myProject);
        ProjectManagerAdapter projectManagerListener = new ProjectManagerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void projectClosing(Project project) {
                Object object = CoverageDataManagerImpl.this.myLock;
                synchronized (object) {
                    CoverageDataManagerImpl.this.myIsProjectClosing = true;
                }
            }
        };
        ProjectManager.getInstance().addProjectManagerListener(this.myProject, (ProjectManagerListener)projectManagerListener);
    }

    public void projectClosed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doInReadActionIfProjectOpen(Computable<T> computation) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myIsProjectClosing) {
                return null;
            }
        }
        return (T)ApplicationManager.getApplication().runReadAction(computation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectSubCoverage(@NotNull CoverageSuitesBundle suite, List<String> testNames) {
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/coverage/CoverageDataManagerImpl", "selectSubCoverage"));
        }
        suite.restoreCoverageData();
        ProjectData data = suite.getCoverageData();
        if (data == null) {
            return;
        }
        this.mySubCoverageIsActive = true;
        HashMap executionTrace = new HashMap();
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            String fileName = coverageSuite.getCoverageDataFileName();
            File tracesDir = this.getTracesDirectory(fileName);
            for (String testName : testNames) {
                File file = new File(tracesDir, FileUtil.sanitizeFileName((String)testName) + ".tr");
                if (!file.exists()) continue;
                FilterInputStream in = null;
                try {
                    in = new DataInputStream(new FileInputStream(file));
                    int traceSize = ((DataInputStream)in).readInt();
                    for (int i = 0; i < traceSize; ++i) {
                        String className = ((DataInputStream)in).readUTF();
                        int linesSize = ((DataInputStream)in).readInt();
                        Set lines = (Set)executionTrace.get(className);
                        if (lines == null) {
                            lines = new HashSet();
                            executionTrace.put(className, lines);
                        }
                        for (int l = 0; l < linesSize; ++l) {
                            lines.add(((DataInputStream)in).readInt());
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }
        ProjectData projectData = new ProjectData();
        for (String className : executionTrace.keySet()) {
            ClassData loadedClassData = projectData.getClassData(className);
            if (loadedClassData == null) {
                loadedClassData = projectData.getOrCreateClassData(className);
            }
            Set lineNumbers = (Set)executionTrace.get(className);
            ClassData oldData = data.getClassData(className);
            LOG.assertTrue(oldData != null, (Object)("missed className: \"" + className + "\""));
            Object[] oldLines = oldData.getLines();
            LOG.assertTrue(oldLines != null);
            int maxNumber = oldLines.length;
            for (Integer lineNumber : lineNumbers) {
                if (lineNumber < maxNumber) continue;
                maxNumber = lineNumber + 1;
            }
            LineData[] lines = new LineData[maxNumber];
            for (Integer line : lineNumbers) {
                LineData oldLineData;
                int lineIdx = line - 1;
                String methodSig = null;
                if (lineIdx < oldData.getLines().length && (oldLineData = oldData.getLineData(lineIdx)) != null) {
                    methodSig = oldLineData.getMethodSignature();
                }
                LineData lineData = new LineData(lineIdx, methodSig);
                if (methodSig != null) {
                    loadedClassData.registerMethodSignature(lineData);
                }
                lineData.setStatus((byte)2);
                lines[lineIdx] = lineData;
            }
            loadedClassData.setLines(lines);
        }
        suite.setCoverageData(projectData);
        this.renewCoverageData(suite);
    }

    private File getTracesDirectory(String fileName) {
        return new File(new File(fileName).getParentFile(), FileUtil.getNameWithoutExtension((File)new File(fileName)));
    }

    @Override
    public void restoreMergedCoverage(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/coverage/CoverageDataManagerImpl", "restoreMergedCoverage"));
        }
        this.mySubCoverageIsActive = false;
        suite.restoreCoverageData();
        this.renewCoverageData(suite);
    }

    @Override
    public void addSuiteListener(final CoverageSuiteListener listener, Disposable parentDisposable) {
        this.myListeners.add(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                CoverageDataManagerImpl.this.myListeners.remove(listener);
            }
        });
    }

    public void fireBeforeSuiteChosen() {
        for (CoverageSuiteListener listener : this.myListeners) {
            listener.beforeSuiteChosen();
        }
    }

    public void fireAfterSuiteChosen() {
        for (CoverageSuiteListener listener : this.myListeners) {
            listener.afterSuiteChosen();
        }
    }

    @Override
    public boolean isSubCoverageActive() {
        return this.mySubCoverageIsActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SrcFileAnnotator getAnnotator(Editor editor) {
        Object object = this.ANNOTATORS_LOCK;
        synchronized (object) {
            return this.myAnnotators.get(editor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAnnotators() {
        Object object = this.ANNOTATORS_LOCK;
        synchronized (object) {
            for (SrcFileAnnotator annotator : this.myAnnotators.values()) {
                if (annotator == null) continue;
                Disposer.dispose((Disposable)annotator);
            }
            this.myAnnotators.clear();
        }
    }

    @NotNull
    private CoverageSuite createCoverageSuite(CoverageEnabledConfiguration config, String name, CoverageRunner coverageRunner, DefaultCoverageFileProvider fileProvider) {
        CoverageEngine engine;
        CoverageSuite suite = null;
        CoverageEngine[] arr$ = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || coverageRunner.acceptsCoverageEngine(engine = arr$[i$]) && engine.isApplicableTo(config.getConfiguration()) && (suite = engine.createCoverageSuite(coverageRunner, name, fileProvider, config)) != null); ++i$) {
        }
        LOG.assertTrue(suite != null, (Object)("Cannot create coverage suite for runner: " + coverageRunner.getPresentableName()));
        CoverageSuite coverageSuite = suite;
        if (coverageSuite == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageDataManagerImpl", "createCoverageSuite"));
        }
        return coverageSuite;
    }

    @NotNull
    private CoverageSuite createCoverageSuite(CoverageRunner coverageRunner, String name, CoverageFileProvider fileProvider, String[] filters, long lastCoverageTimeStamp, String suiteToMergeWith, boolean collectLineInfo, boolean tracingEnabled) {
        CoverageEngine engine;
        CoverageSuite suite = null;
        CoverageEngine[] arr$ = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || coverageRunner.acceptsCoverageEngine(engine = arr$[i$]) && (suite = engine.createCoverageSuite(coverageRunner, name, fileProvider, filters, lastCoverageTimeStamp, suiteToMergeWith, collectLineInfo, tracingEnabled, false, this.myProject)) != null); ++i$) {
        }
        LOG.assertTrue(suite != null, (Object)("Cannot create coverage suite for runner: " + coverageRunner.getPresentableName()));
        CoverageSuite coverageSuite = suite;
        if (coverageSuite == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageDataManagerImpl", "createCoverageSuite"));
        }
        return coverageSuite;
    }

    private class CoverageEditorFactoryListener
    implements EditorFactoryListener {
        private final Alarm myAlarm;
        private final Map<Editor, Runnable> myCurrentEditors;

        private CoverageEditorFactoryListener() {
            this.myAlarm = new Alarm(Alarm.ThreadToUse.OWN_THREAD, (Disposable)CoverageDataManagerImpl.this.myProject);
            this.myCurrentEditors = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/coverage/CoverageDataManagerImpl$CoverageEditorFactoryListener", "editorCreated"));
            }
            Object object = CoverageDataManagerImpl.this.myLock;
            synchronized (object) {
                if (CoverageDataManagerImpl.this.myIsProjectClosing) {
                    return;
                }
            }
            final Editor editor = event.getEditor();
            if (editor.getProject() != CoverageDataManagerImpl.this.myProject) {
                return;
            }
            final PsiFile psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

                @Nullable
                public PsiFile compute() {
                    if (CoverageDataManagerImpl.this.myProject.isDisposed()) {
                        return null;
                    }
                    PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)CoverageDataManagerImpl.this.myProject);
                    Document document = editor.getDocument();
                    return documentManager.getPsiFile(document);
                }
            });
            if (psiFile != null && CoverageDataManagerImpl.this.myCurrentSuitesBundle != null && psiFile.isPhysical()) {
                final CoverageEngine engine = CoverageDataManagerImpl.this.myCurrentSuitesBundle.getCoverageEngine();
                if (!engine.coverageEditorHighlightingApplicableTo(psiFile)) {
                    return;
                }
                SrcFileAnnotator annotator = CoverageDataManagerImpl.this.getAnnotator(editor);
                if (annotator == null) {
                    annotator = new SrcFileAnnotator(psiFile, editor);
                }
                final SrcFileAnnotator finalAnnotator = annotator;
                Object object2 = CoverageDataManagerImpl.this.ANNOTATORS_LOCK;
                synchronized (object2) {
                    CoverageDataManagerImpl.this.myAnnotators.put(editor, finalAnnotator);
                }
                Runnable request = new Runnable(){

                    @Override
                    public void run() {
                        if (CoverageDataManagerImpl.this.myProject.isDisposed()) {
                            return;
                        }
                        if (CoverageDataManagerImpl.this.myCurrentSuitesBundle != null && engine.acceptedByFilters(psiFile, CoverageDataManagerImpl.this.myCurrentSuitesBundle)) {
                            finalAnnotator.showCoverageInformation(CoverageDataManagerImpl.this.myCurrentSuitesBundle);
                        }
                    }
                };
                this.myCurrentEditors.put(editor, request);
                this.myAlarm.addRequest(request, 100);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorReleased(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/coverage/CoverageDataManagerImpl$CoverageEditorFactoryListener", "editorReleased"));
            }
            Editor editor = event.getEditor();
            if (editor.getProject() != CoverageDataManagerImpl.this.myProject) {
                return;
            }
            try {
                SrcFileAnnotator fileAnnotator;
                Object object = CoverageDataManagerImpl.this.ANNOTATORS_LOCK;
                synchronized (object) {
                    fileAnnotator = (SrcFileAnnotator)CoverageDataManagerImpl.this.myAnnotators.remove(editor);
                }
                if (fileAnnotator != null) {
                    Disposer.dispose((Disposable)fileAnnotator);
                }
            }
            finally {
                Runnable request = this.myCurrentEditors.remove(editor);
                if (request != null) {
                    this.myAlarm.cancelRequest(request);
                }
            }
        }
    }
}

