/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Visitor;
import com.android.tools.perflib.heap.io.HprofBuffer;
import com.google.common.collect.Sets;
import com.google.common.primitives.UnsignedBytes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;

public abstract class Instance {
    protected final long mId;
    @NonNull
    protected final StackTrace mStack;
    long mClassId;
    Heap mHeap;
    int mSize;
    int mTopologicalOrder;
    @Nullable
    private Instance mImmediateDominator;
    private long[] mRetainedSizes;
    private final ArrayList<Instance> mReferences = new ArrayList();

    Instance(long id, @NonNull StackTrace stackTrace) {
        this.mId = id;
        this.mStack = stackTrace;
    }

    public long getId() {
        return this.mId;
    }

    public abstract void accept(Visitor var1);

    public void setClassId(long classId) {
        this.mClassId = classId;
    }

    public ClassObj getClassObj() {
        return this.mHeap.mSnapshot.findClass(this.mClassId);
    }

    public final int getCompositeSize() {
        CollectingVisitor visitor = new CollectingVisitor();
        this.accept(visitor);
        int size = 0;
        for (Instance instance : visitor.getVisited()) {
            size += instance.getSize();
        }
        return size;
    }

    public int getSize() {
        return this.mSize;
    }

    public void setSize(int size) {
        this.mSize = size;
    }

    public void setHeap(Heap heap) {
        this.mHeap = heap;
    }

    public Heap getHeap() {
        return this.mHeap;
    }

    public int getTopologicalOrder() {
        return this.mTopologicalOrder;
    }

    public void setTopologicalOrder(int topologicalOrder) {
        this.mTopologicalOrder = topologicalOrder;
    }

    @Nullable
    public Instance getImmediateDominator() {
        return this.mImmediateDominator;
    }

    public void setImmediateDominator(@NonNull Instance dominator) {
        this.mImmediateDominator = dominator;
    }

    public void resetRetainedSize() {
        ArrayList<Heap> allHeaps = this.mHeap.mSnapshot.mHeaps;
        if (this.mRetainedSizes == null) {
            this.mRetainedSizes = new long[allHeaps.size()];
        } else {
            Arrays.fill(this.mRetainedSizes, 0L);
        }
        this.mRetainedSizes[allHeaps.indexOf((Object)this.mHeap)] = this.getSize();
    }

    public void addRetainedSize(int heapIndex, long size) {
        int n = heapIndex;
        this.mRetainedSizes[n] = this.mRetainedSizes[n] + size;
    }

    public long getRetainedSize(int heapIndex) {
        return this.mRetainedSizes[heapIndex];
    }

    public void addReference(Instance reference) {
        this.mReferences.add(reference);
    }

    @NonNull
    public ArrayList<Instance> getReferences() {
        return this.mReferences;
    }

    @Nullable
    protected Object readValue(@NonNull Type type) {
        switch (type) {
            case OBJECT: {
                long id = this.readId();
                Instance result = this.mHeap.mSnapshot.findReference(id);
                if (result != null) {
                    result.addReference(this);
                }
                return result;
            }
            case BOOLEAN: {
                return this.getBuffer().readByte() != 0;
            }
            case CHAR: {
                return Character.valueOf(this.getBuffer().readChar());
            }
            case FLOAT: {
                return Float.valueOf(this.getBuffer().readFloat());
            }
            case DOUBLE: {
                return this.getBuffer().readDouble();
            }
            case BYTE: {
                return this.getBuffer().readByte();
            }
            case SHORT: {
                return this.getBuffer().readShort();
            }
            case INT: {
                return this.getBuffer().readInt();
            }
            case LONG: {
                return this.getBuffer().readLong();
            }
        }
        return null;
    }

    protected long readId() {
        switch (Type.OBJECT.getSize()) {
            case 1: {
                return this.getBuffer().readByte();
            }
            case 2: {
                return this.getBuffer().readShort();
            }
            case 4: {
                return this.getBuffer().readInt();
            }
            case 8: {
                return this.getBuffer().readLong();
            }
        }
        return 0L;
    }

    protected int readUnsignedByte() {
        return UnsignedBytes.toInt((byte)this.getBuffer().readByte());
    }

    protected int readUnsignedShort() {
        return this.getBuffer().readShort() & 0xFFFF;
    }

    protected HprofBuffer getBuffer() {
        return this.mHeap.mSnapshot.mBuffer;
    }

    public static class CollectingVisitor
    implements Visitor {
        private final Set<Instance> mVisited = Sets.newHashSet();

        @Override
        public boolean visitEnter(Instance instance) {
            return this.mVisited.add(instance);
        }

        @Override
        public void visitLeave(Instance instance) {
        }

        public Set<Instance> getVisited() {
            return this.mVisited;
        }
    }
}

