/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.process;

import com.android.annotations.NonNull;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.ide.common.process.ProcessResultImpl;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;

public class DefaultProcessExecutor
implements ProcessExecutor {
    private final ILogger mLogger;

    public DefaultProcessExecutor(ILogger logger) {
        this.mLogger = logger;
    }

    @Override
    @NonNull
    public ProcessResult execute(@NonNull ProcessInfo processInfo, @NonNull ProcessOutputHandler processOutputHandler) {
        ArrayList command = Lists.newArrayList();
        command.add(processInfo.getExecutable());
        command.addAll(processInfo.getArgs());
        String commandString = Joiner.on((char)' ').join((Iterable)command);
        this.mLogger.info("command: " + commandString, new Object[0]);
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            Map<String, Object> envVariableMap = processInfo.getEnvironment();
            if (!envVariableMap.isEmpty()) {
                Map<String, String> env = processBuilder.environment();
                for (Map.Entry<String, Object> entry : envVariableMap.entrySet()) {
                    env.put(entry.getKey(), entry.getValue().toString());
                }
            }
            Process process = processBuilder.start();
            ProcessOutput output = processOutputHandler.createOutput();
            int exitCode = DefaultProcessExecutor.grabProcessOutput(process, output);
            processOutputHandler.handleOutput(output);
            return new ProcessResultImpl(commandString, exitCode);
        }
        catch (IOException e) {
            return new ProcessResultImpl(commandString, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new ProcessResultImpl(commandString, e);
        }
        catch (ProcessException e) {
            return new ProcessResultImpl(commandString, e);
        }
    }

    private static int grabProcessOutput(final @NonNull Process process, final @NonNull ProcessOutput output) throws InterruptedException {
        Thread threadErr = new Thread("stderr"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream stderr = process.getErrorStream();
                OutputStream stream = output.getErrorOutput();
                try {
                    ByteStreams.copy((InputStream)stderr, (OutputStream)stream);
                    stream.flush();
                }
                catch (IOException e) {
                }
                finally {
                    try {
                        Closeables.close((Closeable)stderr, (boolean)true);
                    }
                    catch (IOException e) {}
                    try {
                        Closeables.close((Closeable)stream, (boolean)true);
                    }
                    catch (IOException e) {}
                }
            }
        };
        Thread threadOut = new Thread("stdout"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream stdout = process.getInputStream();
                OutputStream stream = output.getStandardOutput();
                try {
                    ByteStreams.copy((InputStream)stdout, (OutputStream)stream);
                    stream.flush();
                }
                catch (IOException e) {
                }
                finally {
                    try {
                        Closeables.close((Closeable)stdout, (boolean)true);
                    }
                    catch (IOException e) {}
                    try {
                        Closeables.close((Closeable)stream, (boolean)true);
                    }
                    catch (IOException e) {}
                }
            }
        };
        threadErr.start();
        threadOut.start();
        threadErr.join();
        threadOut.join();
        return process.waitFor();
    }
}

