/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.properties;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.properties.PropertiesMap;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdPropertyClient
extends BaseSvnClient
implements PropertyClient {
    private static final Logger LOG = Logger.getInstance(CmdPropertyClient.class);

    @Override
    @Nullable
    public PropertyValue getProperty(@NotNull SvnTarget target, @NotNull String property, boolean revisionProperty, @Nullable SVNRevision revision) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "getProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "getProperty"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(property);
        if (!revisionProperty) {
            CommandUtil.put(parameters, target);
            CommandUtil.put(parameters, revision);
        } else {
            this.assertFile(target);
            CommandUtil.put(parameters, target, false);
            parameters.add("--revprop");
            CommandUtil.put(parameters, this.resolveRevisionNumber(target.getFile(), revision));
        }
        parameters.add("--xml");
        CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.propget, parameters, null);
        PropertyData data = this.parseSingleProperty(target, command);
        return data != null ? data.getValue() : null;
    }

    @Override
    public void getProperty(@NotNull SvnTarget target, @NotNull String property, @Nullable SVNRevision revision, @Nullable Depth depth, @Nullable PropertyConsumer handler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "getProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "getProperty"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(property);
        this.fillListParameters(target, revision, depth, parameters, false);
        CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.propget, parameters, null);
        CmdPropertyClient.parseOutput(target, command, handler);
    }

    @Override
    public void list(@NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable Depth depth, @Nullable PropertyConsumer handler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "list"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        this.fillListParameters(target, revision, depth, parameters, true);
        CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.proplist, parameters, null);
        CmdPropertyClient.parseOutput(target, command, handler);
    }

    @Override
    public void setProperty(@NotNull File file, @NotNull String property, @Nullable PropertyValue value, @Nullable Depth depth, boolean force) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "setProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "setProperty"));
        }
        this.runSetProperty(SvnTarget.fromFile((File)file), property, null, depth, value, force);
    }

    @Override
    public void setProperties(@NotNull File file, @NotNull PropertiesMap properties) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "setProperties"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "setProperties"));
        }
        PropertiesMap currentProperties = this.collectPropertiesToDelete(file);
        currentProperties.putAll((Map)((Object)properties));
        for (Map.Entry entry : currentProperties.entrySet()) {
            this.setProperty(file, (String)entry.getKey(), (PropertyValue)entry.getValue(), Depth.EMPTY, true);
        }
    }

    @NotNull
    private PropertiesMap collectPropertiesToDelete(@NotNull File file) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "collectPropertiesToDelete"));
        }
        final PropertiesMap result = new PropertiesMap();
        this.list(SvnTarget.fromFile((File)file), null, Depth.EMPTY, new PropertyConsumer(){

            @Override
            public void handleProperty(File path, PropertyData property) throws SVNException {
                result.put(property.getName(), null);
            }

            @Override
            public void handleProperty(SVNURL url, PropertyData property) throws SVNException {
            }

            @Override
            public void handleProperty(long revision, PropertyData property) throws SVNException {
            }
        });
        PropertiesMap propertiesMap = result;
        if (propertiesMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "collectPropertiesToDelete"));
        }
        return propertiesMap;
    }

    @Override
    public void setRevisionProperty(@NotNull SvnTarget target, @NotNull String property, @NotNull SVNRevision revision, @Nullable PropertyValue value, boolean force) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "setRevisionProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "setRevisionProperty"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "setRevisionProperty"));
        }
        this.runSetProperty(target, property, revision, null, value, force);
    }

    private void runSetProperty(@NotNull SvnTarget target, @NotNull String property, @Nullable SVNRevision revision, @Nullable Depth depth, @Nullable PropertyValue value, boolean force) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "runSetProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "runSetProperty"));
        }
        boolean isDelete = value == null;
        Command command = this.newCommand(isDelete ? SvnCommandName.propdel : SvnCommandName.propset);
        command.put(property);
        if (revision != null) {
            command.put("--revprop");
            command.put(revision);
        }
        if (!isDelete) {
            command.setPropertyValue(value);
            command.put("--force", force);
        }
        command.put(target);
        command.put(depth);
        this.execute(this.myVcs, target, null, command, null);
    }

    private void fillListParameters(@NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable Depth depth, @NotNull List<String> parameters, boolean verbose) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "fillListParameters"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "fillListParameters"));
        }
        CommandUtil.put(parameters, target);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, depth);
        parameters.add("--xml");
        CommandUtil.put(parameters, verbose, "--verbose");
    }

    @Nullable
    private PropertyData parseSingleProperty(SvnTarget target, @NotNull CommandExecutor command) throws VcsException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "parseSingleProperty"));
        }
        final PropertyData[] data = new PropertyData[1];
        PropertyConsumer handler = new PropertyConsumer(){

            @Override
            public void handleProperty(File path, PropertyData property) throws SVNException {
                data[0] = property;
            }

            @Override
            public void handleProperty(SVNURL url, PropertyData property) throws SVNException {
                data[0] = property;
            }

            @Override
            public void handleProperty(long revision, PropertyData property) throws SVNException {
                data[0] = property;
            }
        };
        CmdPropertyClient.parseOutput(target, command, handler);
        return data[0];
    }

    private static void parseOutput(SvnTarget target, @NotNull CommandExecutor command, PropertyConsumer handler) throws VcsException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "parseOutput"));
        }
        try {
            Properties properties = CommandUtil.parse(command.getOutput(), Properties.class);
            if (properties != null) {
                for (Target childInfo : properties.targets) {
                    SvnTarget childTarget = SvnUtil.append(target, childInfo.path);
                    for (Property property : childInfo.properties) {
                        CmdPropertyClient.invokeHandler(childTarget, CmdPropertyClient.create(property.name, property.value), handler);
                    }
                }
                if (properties.revisionProperties != null) {
                    for (Property property : properties.revisionProperties.properties) {
                        CmdPropertyClient.invokeHandler(properties.revisionProperties.revisionNumber(), CmdPropertyClient.create(property.name, property.value), handler);
                    }
                }
            }
        }
        catch (JAXBException e) {
            LOG.error("Could not parse properties. Command: " + command.getCommandText() + ", Warning: " + command.getErrorOutput(), new Attachment[]{new Attachment("output.xml", command.getOutput())});
            throw new VcsException((Throwable)e);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static void invokeHandler(@NotNull SvnTarget target, @Nullable PropertyData data, @Nullable PropertyConsumer handler) throws SVNException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "invokeHandler"));
        }
        if (handler != null && data != null) {
            if (target.isFile()) {
                handler.handleProperty(target.getFile(), data);
            } else {
                handler.handleProperty(target.getURL(), data);
            }
        }
    }

    private static void invokeHandler(long revision, @Nullable PropertyData data, @Nullable PropertyConsumer handler) throws SVNException {
        if (handler != null && data != null) {
            handler.handleProperty(revision, data);
        }
    }

    @Nullable
    private static PropertyData create(@NotNull String property, @Nullable String value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "create"));
        }
        PropertyData result = null;
        if (value != null) {
            result = new PropertyData(property, PropertyValue.create(value.trim()));
        }
        return result;
    }

    private SVNRevision resolveRevisionNumber(@NotNull File path, @Nullable SVNRevision revision) throws VcsException {
        long result;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "resolveRevisionNumber"));
        }
        long l = result = revision != null ? revision.getNumber() : -1L;
        if (SVNRevision.BASE.equals((Object)revision)) {
            Info info = this.myVcs.getInfo(path, SVNRevision.BASE);
            long l2 = result = info != null ? info.getRevision().getNumber() : -1L;
        }
        if (result == -1L) {
            throw new VcsException("Could not determine revision number for file " + path + " and revision " + revision);
        }
        return SVNRevision.create((long)result);
    }

    public static class Property {
        @XmlAttribute(name="name")
        public String name;
        @XmlValue
        public String value;
    }

    public static class RevisionProperties {
        @XmlAttribute(name="rev")
        public String revision;
        @XmlElement(name="property")
        public List<Property> properties = new ArrayList<Property>();

        public long revisionNumber() {
            return Long.valueOf(this.revision);
        }
    }

    public static class Target {
        @XmlAttribute(name="path")
        public String path;
        @XmlElement(name="property")
        public List<Property> properties = new ArrayList<Property>();
    }

    @XmlRootElement(name="properties")
    public static class Properties {
        @XmlElement(name="target")
        public List<Target> targets = new ArrayList<Target>();
        @XmlElement(name="revprops")
        public RevisionProperties revisionProperties;
    }
}

