/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import icons.XpathIcons;
import javax.swing.Icon;
import org.intellij.lang.xpath.XPath2Language;
import org.intellij.lang.xpath.XPathLanguage;
import org.jetbrains.annotations.NotNull;

public final class XPathFileType
extends LanguageFileType {
    public static final XPathFileType XPATH = new XPathFileType(new XPathLanguage());
    public static final XPathFileType XPATH2 = new XPathFileType(new XPath2Language());

    private XPathFileType(Language language) {
        super(language);
    }

    @NotNull
    public String getName() {
        String string = this.getLanguage().getID();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/XPathFileType", "getName"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        if ("XPath" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/XPathFileType", "getDescription"));
        }
        return "XPath";
    }

    @NotNull
    public String getDefaultExtension() {
        String string = this.getLanguage().getID().toLowerCase();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/XPathFileType", "getDefaultExtension"));
        }
        return string;
    }

    public Icon getIcon() {
        return XpathIcons.Xpath;
    }
}

