/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution.cmd;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import groovyjarjarcommonscli.Option;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.cli.AbstractCommandLineConverter;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineOption;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.ParsedCommandLineOption;
import org.gradle.cli.SystemPropertiesCommandLineConverter;
import org.jetbrains.plugins.gradle.service.execution.cmd.GradleCommandLineOptionsProvider;

public class GradleCommandLineOptionsConverter
extends AbstractCommandLineConverter<Map<String, List<String>>> {
    private final SystemPropertiesCommandLineConverter systemPropertiesCommandLineConverter = new SystemPropertiesCommandLineConverter();

    public Map<String, List<String>> convert(ParsedCommandLine options, Map<String, List<String>> target) throws CommandLineArgumentException {
        Collection supportedOptions = GradleCommandLineOptionsProvider.getSupportedOptions().getOptions();
        for (Option supportedOption : supportedOptions) {
            String longOpt = supportedOption.getLongOpt();
            if (longOpt != null && options.hasOption(longOpt)) {
                ParsedCommandLineOption option = options.option(longOpt);
                target.put(longOpt, option.getValues());
                continue;
            }
            String opt = supportedOption.getOpt();
            if (opt == null || !options.hasOption(opt)) continue;
            ParsedCommandLineOption option = options.option(opt);
            target.put(opt, option.getValues());
        }
        return target;
    }

    public void configure(CommandLineParser parser) {
        this.systemPropertiesCommandLineConverter.configure(parser);
        parser.allowMixedSubcommandsAndOptions();
        Collection supportedOptions = GradleCommandLineOptionsProvider.getSupportedOptions().getOptions();
        for (Option supportedOption : supportedOptions) {
            List objects = ContainerUtil.newSmartList();
            ContainerUtil.addAllNotNull((Collection)objects, (Object[])new String[]{supportedOption.getOpt(), supportedOption.getLongOpt()});
            if (objects.isEmpty()) continue;
            try {
                CommandLineOption option = parser.option(ArrayUtil.toStringArray((Collection)objects));
                if (supportedOption.hasArg()) {
                    option.hasArgument();
                }
                if (supportedOption.hasArgs()) {
                    option.hasArguments();
                }
                option.hasDescription(supportedOption.getDescription());
            }
            catch (IllegalArgumentException ignore) {}
        }
    }
}

