/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.springloaded;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class SpringLoadedPositionManager
implements PositionManager {
    private static final Pattern GENERATED_CLASS_NAME = Pattern.compile("\\$\\$[A-Za-z0-9]{8}");
    private final DebugProcess myDebugProcess;

    public SpringLoadedPositionManager(DebugProcess debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    public SourcePosition getSourcePosition(@Nullable Location location) throws NoDataException {
        throw NoDataException.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition classPosition) throws NoDataException {
        int line;
        String className;
        if (classPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPosition", "org/jetbrains/plugins/groovy/springloaded/SpringLoadedPositionManager", "getAllClasses"));
        }
        AccessToken accessToken = ReadAction.start();
        try {
            className = SpringLoadedPositionManager.findEnclosingName(classPosition);
            if (className == null) {
                throw NoDataException.INSTANCE;
            }
            line = classPosition.getLine();
        }
        finally {
            accessToken.finish();
        }
        List referenceTypes = this.myDebugProcess.getVirtualMachineProxy().classesByName(className);
        if (referenceTypes.isEmpty()) {
            throw NoDataException.INSTANCE;
        }
        HashSet<ReferenceType> res = new HashSet<ReferenceType>();
        for (ReferenceType referenceType : referenceTypes) {
            SpringLoadedPositionManager.findNested(res, referenceType, line);
        }
        if (res.isEmpty()) {
            throw NoDataException.INSTANCE;
        }
        ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>(res);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/springloaded/SpringLoadedPositionManager", "getAllClasses"));
        }
        return arrayList;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/springloaded/SpringLoadedPositionManager", "locationsOfLine"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/groovy/springloaded/SpringLoadedPositionManager", "locationsOfLine"));
        }
        throw NoDataException.INSTANCE;
    }

    @Nullable
    private static String findEnclosingName(SourcePosition position) {
        PsiElement element = SpringLoadedPositionManager.findElementAt(position);
        while (!((element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrTypeDefinition.class, PsiClassImpl.class})) == null || element instanceof GrTypeDefinition && !((GrTypeDefinition)element).isAnonymous() || element instanceof PsiClassImpl && ((PsiClassImpl)element).getName() != null)) {
        }
        if (element != null) {
            return SpringLoadedPositionManager.getClassNameForJvm((PsiClass)element);
        }
        return null;
    }

    @Nullable
    private static String getClassNameForJvm(PsiClass aClass) {
        PsiClass psiClass = aClass.getContainingClass();
        if (psiClass != null) {
            return SpringLoadedPositionManager.getClassNameForJvm(psiClass) + "$" + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getOuterClassName(SourcePosition position) {
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            PsiElement element = SpringLoadedPositionManager.findElementAt(position);
            if (element == null) {
                String string = null;
                return string;
            }
            PsiElement sourceImage = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrClosableBlock.class, GrTypeDefinition.class, PsiClassImpl.class});
            if (sourceImage instanceof PsiClass) {
                String string = SpringLoadedPositionManager.getClassNameForJvm((PsiClass)sourceImage);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            accessToken.finish();
        }
    }

    @Nullable
    private static PsiElement findElementAt(SourcePosition position) {
        PsiFile file = position.getFile();
        if (!(file instanceof GroovyFileBase) && !(file instanceof PsiJavaFile)) {
            return null;
        }
        return file.findElementAt(position.getOffset());
    }

    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) throws NoDataException {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "org/jetbrains/plugins/groovy/springloaded/SpringLoadedPositionManager", "createPrepareRequest"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/groovy/springloaded/SpringLoadedPositionManager", "createPrepareRequest"));
        }
        String className = SpringLoadedPositionManager.getOuterClassName(position);
        if (className == null) {
            throw NoDataException.INSTANCE;
        }
        return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(requestor, className + "*");
    }

    private static boolean isSpringLoadedGeneratedClass(ReferenceType ownerClass, ReferenceType aClass) {
        String name = aClass.name();
        String ownerClassName = ownerClass.name();
        return name.length() == ownerClassName.length() + 2 + 8 && name.startsWith(ownerClassName) && GENERATED_CLASS_NAME.matcher(name.substring(ownerClassName.length())).matches();
    }

    private static void findNested(Set<ReferenceType> res, ReferenceType fromClass, int line) {
        if (!fromClass.isPrepared()) {
            return;
        }
        List<ReferenceType> nestedTypes = fromClass.nestedTypes();
        ReferenceType springLoadedGeneratedClass = null;
        for (ReferenceType nested : nestedTypes) {
            if (!nested.isPrepared()) continue;
            if (SpringLoadedPositionManager.isSpringLoadedGeneratedClass(fromClass, nested)) {
                if (springLoadedGeneratedClass != null && springLoadedGeneratedClass.name().equals(nested.name())) continue;
                springLoadedGeneratedClass = nested;
                continue;
            }
            SpringLoadedPositionManager.findNested(res, nested, line);
        }
        try {
            ReferenceType effectiveRef;
            int lineNumber = line + 1;
            ReferenceType referenceType = effectiveRef = springLoadedGeneratedClass == null ? fromClass : springLoadedGeneratedClass;
            if (!effectiveRef.locationsOfLine(lineNumber).isEmpty()) {
                res.add(effectiveRef);
            }
        }
        catch (ObjectCollectedException ignored) {
        }
        catch (AbsentInformationException ignored) {
            // empty catch block
        }
    }
}

