/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashMap;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

class RefCountHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.RefCountHolder");
    private final PsiFile myFile;
    private final BidirectionalMap<PsiReference, PsiElement> myLocalRefsMap;
    private final Map<PsiAnchor, Boolean> myDclsUsedMap;
    private final Map<PsiReference, PsiImportStatementBase> myImportStatements;
    private final AtomicReference<ProgressIndicator> myState;
    private static final ProgressIndicator READY = new DaemonProgressIndicator(){
        {
            this.cancel();
        }

        @Override
        public String toString() {
            return "READY";
        }
    };
    private static final ProgressIndicator EMPTY = new DaemonProgressIndicator(){
        {
            this.cancel();
        }

        @Override
        public String toString() {
            return "EMPTY";
        }
    };
    private static final Key<Reference<RefCountHolder>> REF_COUNT_HOLDER_IN_FILE_KEY = Key.create((String)"REF_COUNT_HOLDER_IN_FILE_KEY");

    @NotNull
    public static RefCountHolder get(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "get"));
        }
        Reference ref = (Reference)file.getUserData(REF_COUNT_HOLDER_IN_FILE_KEY);
        RefCountHolder holder = (RefCountHolder)SoftReference.dereference((Reference)ref);
        if (holder == null) {
            boolean replaced;
            holder = new RefCountHolder(file);
            java.lang.ref.SoftReference<RefCountHolder> newRef = new java.lang.ref.SoftReference<RefCountHolder>(holder);
            while (!(replaced = ((UserDataHolderEx)file).replace(REF_COUNT_HOLDER_IN_FILE_KEY, (Object)ref, newRef))) {
                ref = (Reference)file.getUserData(REF_COUNT_HOLDER_IN_FILE_KEY);
                RefCountHolder newHolder = (RefCountHolder)SoftReference.dereference((Reference)ref);
                if (newHolder == null) continue;
                holder = newHolder;
                break;
            }
        }
        RefCountHolder refCountHolder = holder;
        if (refCountHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "get"));
        }
        return refCountHolder;
    }

    private RefCountHolder(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "<init>"));
        }
        this.myLocalRefsMap = new BidirectionalMap();
        this.myDclsUsedMap = new THashMap();
        this.myImportStatements = new THashMap();
        this.myState = new AtomicReference<ProgressIndicator>(EMPTY);
        this.myFile = file;
        RefCountHolder.log("c: created for ", file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        BidirectionalMap<PsiReference, PsiElement> bidirectionalMap = this.myLocalRefsMap;
        synchronized (bidirectionalMap) {
            this.myLocalRefsMap.clear();
        }
        this.myImportStatements.clear();
        this.myDclsUsedMap.clear();
    }

    public void registerLocallyReferenced(@NotNull PsiNamedElement result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "registerLocallyReferenced"));
        }
        this.myDclsUsedMap.put(PsiAnchor.create((PsiElement)result), Boolean.TRUE);
    }

    public void registerReference(@NotNull PsiJavaReference ref, @NotNull JavaResolveResult resolveResult) {
        PsiElement resolveScope;
        PsiFile psiFile;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "registerReference"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "registerReference"));
        }
        PsiElement refElement = resolveResult.getElement();
        PsiFile psiFile2 = psiFile = refElement == null ? null : refElement.getContainingFile();
        if (psiFile != null) {
            psiFile = (PsiFile)psiFile.getNavigationElement();
        }
        if (refElement != null && psiFile != null && this.myFile.getViewProvider().equals(psiFile.getViewProvider())) {
            this.registerLocalRef((PsiReference)ref, refElement.getNavigationElement());
        }
        if ((resolveScope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStatementBase) {
            this.registerImportStatement((PsiReference)ref, (PsiImportStatementBase)resolveScope);
        }
    }

    private void registerImportStatement(@NotNull PsiReference ref, @NotNull PsiImportStatementBase importStatement) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "registerImportStatement"));
        }
        if (importStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatement", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "registerImportStatement"));
        }
        this.myImportStatements.put(ref, importStatement);
    }

    boolean isRedundant(@NotNull PsiImportStatementBase importStatement) {
        if (importStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatement", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "isRedundant"));
        }
        return !this.myImportStatements.containsValue(importStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerLocalRef(@NotNull PsiReference ref, PsiElement refElement) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "registerLocalRef"));
        }
        if (refElement instanceof PsiMethod && PsiTreeUtil.isAncestor((PsiElement)refElement, (PsiElement)ref.getElement(), (boolean)true)) {
            return;
        }
        if (refElement instanceof PsiClass && PsiTreeUtil.isAncestor((PsiElement)refElement, (PsiElement)ref.getElement(), (boolean)true)) {
            return;
        }
        BidirectionalMap<PsiReference, PsiElement> bidirectionalMap = this.myLocalRefsMap;
        synchronized (bidirectionalMap) {
            this.myLocalRefsMap.put((Object)ref, (Object)refElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalidRefs() {
        BidirectionalMap<PsiReference, PsiElement> bidirectionalMap = this.myLocalRefsMap;
        synchronized (bidirectionalMap) {
            Iterator iterator = this.myLocalRefsMap.keySet().iterator();
            while (iterator.hasNext()) {
                PsiReference ref = (PsiReference)iterator.next();
                if (ref.getElement().isValid()) continue;
                PsiElement value = (PsiElement)this.myLocalRefsMap.get((Object)ref);
                iterator.remove();
                List array = this.myLocalRefsMap.getKeysByValue((Object)value);
                LOG.assertTrue(array != null);
                array.remove(ref);
            }
        }
        Iterator<PsiReference> iterator = this.myImportStatements.keySet().iterator();
        while (iterator.hasNext()) {
            PsiReference ref = iterator.next();
            if (ref.getElement().isValid()) continue;
            iterator.remove();
        }
        RefCountHolder.removeInvalidFrom(this.myDclsUsedMap.keySet());
    }

    private static void removeInvalidFrom(@NotNull Collection<? extends PsiAnchor> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "removeInvalidFrom"));
        }
        Iterator<? extends PsiAnchor> it = collection.iterator();
        while (it.hasNext()) {
            PsiAnchor element = it.next();
            if (element.retrieve() != null) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReferenced(@NotNull PsiNamedElement element) {
        List array;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "isReferenced"));
        }
        BidirectionalMap<PsiReference, PsiElement> bidirectionalMap = this.myLocalRefsMap;
        synchronized (bidirectionalMap) {
            array = this.myLocalRefsMap.getKeysByValue((Object)element);
        }
        if (array != null && !array.isEmpty() && !RefCountHolder.isParameterUsedRecursively((PsiElement)element, array)) {
            return true;
        }
        Boolean usedStatus = this.myDclsUsedMap.get(PsiAnchor.create((PsiElement)element));
        return usedStatus == Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReferencedByMethodReference(@NotNull PsiMethod method, @NotNull LanguageLevel languageLevel) {
        List array;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "isReferencedByMethodReference"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "isReferencedByMethodReference"));
        }
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            return false;
        }
        BidirectionalMap<PsiReference, PsiElement> bidirectionalMap = this.myLocalRefsMap;
        synchronized (bidirectionalMap) {
            array = this.myLocalRefsMap.getKeysByValue((Object)method);
        }
        if (array != null && !array.isEmpty()) {
            for (PsiReference reference : array) {
                PsiElement element = reference.getElement();
                if (element == null || !(element instanceof PsiMethodReferenceExpression)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isParameterUsedRecursively(@NotNull PsiElement element, @NotNull List<PsiReference> array) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "isParameterUsedRecursively"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "isParameterUsedRecursively"));
        }
        if (!(element instanceof PsiParameter)) {
            return false;
        }
        PsiParameter parameter = (PsiParameter)element;
        PsiElement scope = parameter.getDeclarationScope();
        if (!(scope instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)scope;
        int paramIndex = ArrayUtilRt.find((Object[])method.getParameterList().getParameters(), (Object)parameter);
        for (PsiReference reference : array) {
            if (!(reference instanceof PsiElement)) {
                return false;
            }
            PsiElement argument = (PsiElement)reference;
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)new PsiMatcherImpl(argument).dot(PsiMatchers.hasClass(PsiReferenceExpression.class)).parent(PsiMatchers.hasClass(PsiExpressionList.class)).parent(PsiMatchers.hasClass(PsiMethodCallExpression.class)).getElement();
            if (methodCallExpression == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            if (method != methodExpression.resolve()) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            Object[] arguments = argumentList.getExpressions();
            int argumentIndex = ArrayUtilRt.find((Object[])arguments, (Object)argument);
            if (paramIndex == argumentIndex) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReferencedForRead(@NotNull PsiVariable variable) {
        List array;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "isReferencedForRead"));
        }
        BidirectionalMap<PsiReference, PsiElement> bidirectionalMap = this.myLocalRefsMap;
        synchronized (bidirectionalMap) {
            array = this.myLocalRefsMap.getKeysByValue((Object)variable);
        }
        if (array == null) {
            return false;
        }
        for (PsiReference ref : array) {
            PsiElement refElement = ref.getElement();
            if (!(refElement instanceof PsiExpression)) {
                return true;
            }
            if (!PsiUtil.isAccessedForReading((PsiExpression)((PsiExpression)refElement)) || refElement.getParent() instanceof PsiExpression && refElement.getParent().getParent() instanceof PsiExpressionStatement && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)refElement))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReferencedForWrite(@NotNull PsiVariable variable) {
        List array;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "isReferencedForWrite"));
        }
        BidirectionalMap<PsiReference, PsiElement> bidirectionalMap = this.myLocalRefsMap;
        synchronized (bidirectionalMap) {
            array = this.myLocalRefsMap.getKeysByValue((Object)variable);
        }
        if (array == null) {
            return false;
        }
        for (PsiReference ref : array) {
            PsiElement refElement = ref.getElement();
            if (!(refElement instanceof PsiExpression)) {
                return true;
            }
            if (!PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)refElement))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(@NotNull PsiFile file, TextRange dirtyScope, @NotNull ProgressIndicator indicator, @NotNull Runnable analyze) {
        boolean bl;
        ProgressIndicator result;
        block14: {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "analyze"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "analyze"));
            }
            if (analyze == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analyze", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "analyze"));
            }
            if (this.myState.compareAndSet(EMPTY, indicator)) {
                if (!file.getTextRange().equals((Object)dirtyScope)) {
                    this.myState.set(EMPTY);
                    return false;
                }
                result = EMPTY;
            } else if (this.myState.compareAndSet(READY, indicator)) {
                result = READY;
            } else {
                RefCountHolder.log("a: failed to change ", this.myState, "->", indicator);
                return false;
            }
            try {
                RefCountHolder.log("a: changed ", this.myState, "->", indicator);
                if (dirtyScope != null) {
                    if (dirtyScope.equals((Object)file.getTextRange())) {
                        this.clear();
                    } else {
                        this.removeInvalidRefs();
                    }
                }
                analyze.run();
                result = READY;
                bl = true;
                boolean set = this.myState.compareAndSet(indicator, result);
                if ($assertionsDisabled || set) break block14;
            }
            catch (Throwable throwable) {
                boolean set = this.myState.compareAndSet(indicator, result);
                assert (set) : this.myState.get();
                RefCountHolder.log("a: changed after analyze", indicator, "->", result);
                throw throwable;
            }
            throw new AssertionError(this.myState.get());
        }
        RefCountHolder.log("a: changed after analyze", indicator, "->", result);
        return bl;
    }

    private static void log(Object ... info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "log"));
        }
        FileStatusMap.log(info);
    }
}

