/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.DebuggerTreePanel;
import com.intellij.debugger.ui.impl.ThreadsDebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTree;
import org.jetbrains.annotations.NonNls;

public class ThreadsPanel
extends DebuggerTreePanel {
    @NonNls
    private static final String HELP_ID = "debugging.debugThreads";
    private final Alarm myUpdateLabelsAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private static final int LABELS_UPDATE_DELAY_MS = 200;

    public ThreadsPanel(Project project, final DebuggerStateManager stateManager) {
        super(project, stateManager);
        Disposable disposable = DebuggerAction.installEditAction((JTree)((Object)this.getThreadsTree()), "Debugger.EditFrameSource");
        this.registerDisposable(disposable);
        this.getThreadsTree().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                NodeDescriptorImpl descriptor;
                DebuggerTreeNodeImpl node;
                if (e.getKeyCode() == 10 && ThreadsPanel.this.getThreadsTree().getSelectionCount() == 1 && (node = (DebuggerTreeNodeImpl)ThreadsPanel.this.getThreadsTree().getLastSelectedPathComponent()) != null && (descriptor = node.getDescriptor()) instanceof StackFrameDescriptorImpl) {
                    ThreadsPanel.this.selectFrame(node);
                }
            }
        });
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.getThreadsTree())), "Center");
        stateManager.addListener(new DebuggerContextListener(){

            @Override
            public void changeEvent(DebuggerContextImpl newContext, int event) {
                if (0 == event || 4 == event) {
                    ThreadsPanel.this.startLabelsUpdate();
                } else if (6 == event || 1 == event || 10 == event) {
                    ThreadsPanel.this.myUpdateLabelsAlarm.cancelAllRequests();
                }
                if (1 == event || 10 == event) {
                    stateManager.removeListener(this);
                }
            }
        });
        this.startLabelsUpdate();
    }

    private void startLabelsUpdate() {
        if (this.myUpdateLabelsAlarm.isDisposed()) {
            return;
        }
        this.myUpdateLabelsAlarm.cancelAllRequests();
        this.myUpdateLabelsAlarm.addRequest(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean updateScheduled = false;
                try {
                    DebugProcessImpl process;
                    ThreadsDebuggerTree tree;
                    DebuggerTreeNodeImpl root;
                    if (ThreadsPanel.this.isUpdateEnabled() && (root = (DebuggerTreeNodeImpl)(tree = ThreadsPanel.this.getThreadsTree()).getModel().getRoot()) != null && (process = ThreadsPanel.this.getContext().getDebugProcess()) != null) {
                        process.getManagerThread().invoke(new DebuggerCommandImpl(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            protected void action() throws Exception {
                                try {
                                    ThreadsPanel.updateNodeLabels(root);
                                }
                                finally {
                                    this.reschedule();
                                }
                            }

                            @Override
                            protected void commandCancelled() {
                                this.reschedule();
                            }
                        });
                        updateScheduled = true;
                    }
                }
                finally {
                    if (!updateScheduled) {
                        this.reschedule();
                    }
                }
            }

            private void reschedule() {
                DebuggerSession session = ThreadsPanel.this.getContext().getDebuggerSession();
                if (session != null && session.isAttached() && !session.isPaused() && !ThreadsPanel.this.myUpdateLabelsAlarm.isDisposed()) {
                    ThreadsPanel.this.myUpdateLabelsAlarm.addRequest((Runnable)this, 200, ModalityState.NON_MODAL);
                }
            }
        }, 200, ModalityState.NON_MODAL);
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.myUpdateLabelsAlarm);
        super.dispose();
    }

    private static void updateNodeLabels(DebuggerTreeNodeImpl from) {
        int childCount = from.getChildCount();
        for (int idx = 0; idx < childCount; ++idx) {
            final DebuggerTreeNodeImpl child = (DebuggerTreeNodeImpl)from.getChildAt(idx);
            child.getDescriptor().updateRepresentation(null, new DescriptorLabelListener(){

                @Override
                public void labelChanged() {
                    child.labelChanged();
                }
            });
            ThreadsPanel.updateNodeLabels(child);
        }
    }

    @Override
    protected DebuggerTree createTreeView() {
        return new ThreadsDebuggerTree(this.getProject());
    }

    @Override
    protected ActionPopupMenu createPopupMenu() {
        DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("Debugger.ThreadsPanelPopup");
        return ActionManager.getInstance().createActionPopupMenu("Debugger.ThreadsPanelPopup", (ActionGroup)group);
    }

    @Override
    public Object getData(String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    private void selectFrame(DebuggerTreeNodeImpl node) {
        StackFrameProxyImpl frame = ((StackFrameDescriptorImpl)node.getDescriptor()).getFrameProxy();
        DebuggerContextUtil.setStackFrame(this.getContextManager(), frame);
    }

    public ThreadsDebuggerTree getThreadsTree() {
        return (ThreadsDebuggerTree)this.getTree();
    }
}

