/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.extractMethodObject.ExtractLightMethodObjectHandler;
import com.intellij.util.PathsList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.NotNull;

public class CompilingEvaluatorImpl
extends CompilingEvaluator {
    public CompilingEvaluatorImpl(@NotNull PsiElement context, @NotNull ExtractLightMethodObjectHandler.ExtractedData data) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl", "<init>"));
        }
        super(context, data);
    }

    @Override
    @NotNull
    protected Collection<CompilingEvaluator.OutputFileObject> compile(String target) throws EvaluateException {
        if (!SystemInfo.isJavaVersionAtLeast((String)target)) {
            throw new EvaluateException("Unable to compile for target level " + target + ". Need to run IDEA on java version at least " + target + ", currently running on " + SystemInfo.JAVA_RUNTIME_VERSION);
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        CompilingEvaluator.MemoryFileManager manager = new CompilingEvaluator.MemoryFileManager(compiler);
        DiagnosticCollector diagnostic = new DiagnosticCollector();
        Module module = (Module)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module>(){

            public Module compute() {
                return ModuleUtilCore.findModuleForPsiElement((PsiElement)CompilingEvaluatorImpl.this.myPsiContext);
            }
        });
        ArrayList<String> options = new ArrayList<String>();
        if (module != null) {
            options.add("-cp");
            PathsList cp = ModuleRootManager.getInstance((Module)module).orderEntries().compileOnly().recursively().exportedOnly().withoutSdk().getPathsList();
            options.add(cp.getPathsString());
        }
        if (!StringUtil.isEmpty((String)target)) {
            options.add("-source");
            options.add(target);
            options.add("-target");
            options.add(target);
        }
        try {
            if (!compiler.getTask(null, manager, diagnostic, options, null, Collections.singletonList(new CompilingEvaluator.SourceFileObject(this.getMainClassName(), JavaFileObject.Kind.SOURCE, this.getClassCode()))).call().booleanValue()) {
                StringBuilder res = new StringBuilder("Compilation failed:\n");
                for (Diagnostic d : diagnostic.getDiagnostics()) {
                    res.append(d);
                }
                throw new EvaluateException(res.toString());
            }
        }
        catch (Exception e) {
            throw new EvaluateException(e.getMessage());
        }
        Collection<CompilingEvaluator.OutputFileObject> collection = manager.classes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl", "compile"));
        }
        return collection;
    }

    protected String getClassCode() {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return CompilingEvaluatorImpl.this.myData.getGeneratedInnerClass().getContainingFile().getText();
            }
        });
    }

    protected String getMainClassName() {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return FileUtil.getNameWithoutExtension((String)CompilingEvaluatorImpl.this.myData.getGeneratedInnerClass().getContainingFile().getName());
            }
        });
    }
}

