/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class DiffLineSeparatorRenderer
implements LineMarkerRenderer,
LineSeparatorRenderer {
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final BooleanGetter myCondition;
    private static final int X_STEP = 4;
    private static final int Y_STEP = 4;
    private static final int Y_STEP_2 = 1;
    private static final int JOIN_DX = 4;
    private static final int JOIN_DY = 2;
    private static final Color[] LINE_COLORS = new Color[]{new JBColor((Color)Gray._217, (Color)Gray._35), new JBColor((Color)Gray._200, (Color)Gray._30), new JBColor((Color)Gray._208, (Color)Gray._32), new JBColor((Color)Gray._211, (Color)Gray._34), new JBColor((Color)Gray._217, (Color)Gray._34)};

    public DiffLineSeparatorRenderer(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffLineSeparatorRenderer", "<init>"));
        }
        this(editor, BooleanGetter.TRUE);
    }

    public DiffLineSeparatorRenderer(@NotNull Editor editor, @NotNull BooleanGetter condition) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffLineSeparatorRenderer", "<init>"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/diff/util/DiffLineSeparatorRenderer", "<init>"));
        }
        this.myEditor = editor;
        this.myCondition = condition;
    }

    public static void drawConnectorLine(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2) {
        int[] yPoints;
        int[] xPoints;
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffLineSeparatorRenderer", "drawConnectorLine"));
        }
        int y1 = (start1 + end1) / 2;
        int y2 = (start2 + end2) / 2;
        int step = 3;
        if (Math.abs(x2 - x1) < Math.abs(y2 - y1)) {
            if (y2 < y1) {
                xPoints = new int[]{x1, x2 - 4, x2, x2, x1 + 4, x1};
                yPoints = new int[]{y1 - step, y2 - step + 2, y2 - step, y2 + step, y1 + step - 2, y1 + step};
            } else {
                xPoints = new int[]{x1, x1 + 4, x2, x2, x2 - 4, x1};
                yPoints = new int[]{y1 - step, y1 - step + 2, y2 - step, y2 + step, y2 + step - 2, y1 + step};
            }
        } else {
            xPoints = new int[]{x1, x2, x2, x1};
            yPoints = new int[]{y1 - step, y2 - step, y2 + step, y1 + step};
        }
        DiffLineSeparatorRenderer.paintLine(g, xPoints, yPoints);
    }

    public void paint(Editor editor, Graphics g, Rectangle r) {
        if (!this.myCondition.get()) {
            return;
        }
        int y = r.y;
        int lineHeight = this.myEditor.getLineHeight();
        DiffLineSeparatorRenderer.draw(g, 0, y, lineHeight);
    }

    public void drawLine(Graphics g, int x1, int x2, int y) {
        if (!this.myCondition.get()) {
            return;
        }
        int gutterWidth = ((EditorEx)this.myEditor).getGutterComponentEx().getWidth();
        int lineHeight = this.myEditor.getLineHeight();
        DiffLineSeparatorRenderer.draw(g, -gutterWidth, ++y, lineHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void draw(@NotNull Graphics g, int shiftX, int shiftY, int lineHeight) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffLineSeparatorRenderer", "draw"));
        }
        int halfHeight = lineHeight / 2;
        Rectangle clip = g.getClipBounds();
        int count = clip.width / 4 + 3;
        int shift = (clip.x - shiftX) / 4;
        int[] xPoints = new int[2 * count];
        int[] yPoints = new int[2 * count];
        for (int index = 0; index < count; ++index) {
            int yPos2;
            int yPos1;
            int absIndex = index + shift;
            int xPos = absIndex * 4 + shiftX;
            if (absIndex == 0) {
                yPos1 = halfHeight + shiftY - 4 + 1;
                yPos2 = halfHeight + shiftY + 4 - 1;
            } else if (absIndex % 2 == 0) {
                yPos1 = halfHeight + shiftY - 1;
                yPos2 = halfHeight + shiftY + 4 + 1;
            } else {
                yPos1 = halfHeight + shiftY - 4 - 1;
                yPos2 = halfHeight + shiftY + 1;
            }
            xPoints[index] = xPos;
            yPoints[index] = yPos1;
            xPoints[2 * count - index - 1] = xPos;
            yPoints[2 * count - index - 1] = yPos2;
        }
        GraphicsConfig config = GraphicsUtil.disableAAPainting((Graphics)g);
        try {
            DiffLineSeparatorRenderer.paintLine(g, xPoints, yPoints);
        }
        finally {
            config.restore();
        }
    }

    private static void paintLine(@NotNull Graphics g, @NotNull int[] xPoints, @NotNull int[] yPoints) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffLineSeparatorRenderer", "paintLine"));
        }
        if (xPoints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xPoints", "com/intellij/diff/util/DiffLineSeparatorRenderer", "paintLine"));
        }
        if (yPoints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yPoints", "com/intellij/diff/util/DiffLineSeparatorRenderer", "paintLine"));
        }
        Graphics2D gg = (Graphics2D)g;
        gg.setColor(LINE_COLORS[0]);
        gg.fillPolygon(xPoints, yPoints, xPoints.length);
        gg.drawPolyline(xPoints, yPoints, xPoints.length);
        AffineTransform oldTransform = gg.getTransform();
        gg.setColor(LINE_COLORS[1]);
        gg.drawPolyline(xPoints, yPoints, xPoints.length / 2);
        gg.translate(0, 1);
        gg.setColor(LINE_COLORS[2]);
        gg.drawPolyline(xPoints, yPoints, xPoints.length / 2);
        gg.translate(0, 1);
        gg.setColor(LINE_COLORS[3]);
        gg.drawPolyline(xPoints, yPoints, xPoints.length / 2);
        gg.setTransform(oldTransform);
        int[] xBottomPoints = Arrays.copyOfRange(xPoints, xPoints.length / 2, xPoints.length);
        int[] yBottomPoints = Arrays.copyOfRange(yPoints, xPoints.length / 2, xPoints.length);
        gg.setColor(LINE_COLORS[4]);
        gg.drawPolyline(xBottomPoints, yBottomPoints, xPoints.length / 2);
    }
}

