/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.errorreport.itn;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.errorreport.error.InternalEAPException;
import com.intellij.errorreport.error.NoSuchEAPUserException;
import com.intellij.errorreport.error.UpdateAvailableException;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.net.ssl.CertificateUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;

public class ITNProxy {
    private static final String NEW_THREAD_VIEW_URL = "https://ea.jetbrains.com/browser/ea_reports/";
    private static final String NEW_THREAD_POST_URL = "https://ea-report.jetbrains.com/trackerRpc/idea/createScr";
    private static final String ENCODING = "UTF8";
    private static SSLContext ourSslContext;
    private static final String JB_CA_CERT = "-----BEGIN CERTIFICATE-----\nMIIFvjCCA6agAwIBAgIQMYHnK1dpIZVCoitWqBwhXjANBgkqhkiG9w0BAQsFADBn\nMRMwEQYKCZImiZPyLGQBGRYDTmV0MRgwFgYKCZImiZPyLGQBGRYISW50ZWxsaUox\nFDASBgoJkiaJk/IsZAEZFgRMYWJzMSAwHgYDVQQDExdKZXRCcmFpbnMgRW50ZXJw\ncmlzZSBDQTAeFw0xMjEyMjkxMDEyMzJaFw0zMjEyMjkxMDIyMzBaMGcxEzARBgoJ\nkiaJk/IsZAEZFgNOZXQxGDAWBgoJkiaJk/IsZAEZFghJbnRlbGxpSjEUMBIGCgmS\nJomT8ixkARkWBExhYnMxIDAeBgNVBAMTF0pldEJyYWlucyBFbnRlcnByaXNlIENB\nMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAzPCE2gPgKECo5CB3BTAw\n4XrrNpg+YwTMzeNNDYs4VdPzBq0snWsbm5qP6z1GBGUTr4agERQUxc4//gZMR0UJ\n89GWVNYPbZ/MrkfyaOiem8xosuZ+7WoFu4nYnKbBBMBA7S2idrPSmPv2wYiHJCY7\neN2AdViiFSAUeGw/7pIgou92/4Bbm6SSzRBKBYfRIfwq0ZgETSIjhNR5o3XJB5i2\nCkSjMk7kNiMWBaq+Alv+Um/xMFnl5jiq9H7YAALgH/mZHr8ANniSyBwkj4r/7GQ3\nUIYwoLrGxSOSEY9UhEpdqQkRbSSjQiFYMlhYEAtLERK4KZObTuUgdiE6Wk38EOKZ\nwy1eE/EIh8vWBHFSH5opPSK4dyamxj9o5c2g1hJ07ZBUCV/nsrKb+ruMkwBfI286\n+HPTMUmoKuUfSfHZ5TiuF5EvcSD7Df2ZCFpRugPs26FRGvtsiBMEmu4u6fu5RNkh\ns7Ueq6ISblt6dj/youywiAZnyrtNKJVyK0m051g9b2IokHjrk9XTswTqBHDjZKYr\nYG/5jDSSzvR/ptR9YIrHF0a9A6LQLZ6ews4FUO6O/RhiYXV8FggD7ZUg019OBUx3\nrF1L3GBYA8YhYP/N18r8DqOaFgUiRDyeRMbka9OXZ2KJT6iL+mOfg/svSW8lc4Ly\nEgcyJ9sk7MRwrhlp3Kc0W7UCAwEAAaNmMGQwEwYJKwYBBAGCNxQCBAYeBABDAEEw\nCwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFB/HK/yYoWW9\nvr2XAyhcMmV3gSfGMBAGCSsGAQQBgjcVAQQDAgEAMA0GCSqGSIb3DQEBCwUAA4IC\nAQBnYu49dZRBK9W3voy6bgzz64sZfX51/RIA6aaoHAH3U1bC8EepChqWeRgijGCD\nCBvLTk7bk/7fgXPPvL+8RwYaxEewCi7t1RQKqPmNvUnEnw28OLvYLBEO7a4yeN5Y\nYaZwdfVH+0qMvTqMQku5p5Xx3dY+DAm4EqXEFD0svfeMJmOA+R1CIqRz1CXnN2FY\nA+86m7WLmGZ8oWlRUJDa1etqrE3ZxXHH/IunVJOGOfaQVkid3u3ageyUOnMw/iME\n7vi0UNVYVsCjXYZxrzCDLCxtguZaV4rMYvLRt1oUxZ+VnmdVa3aW0W//GQ70sqh2\nKQDtIF6Iumf8ya4vA0+K+AAowOSR/k4jQzlWQdZvJNMHP/Jc0OyJyHEegjtWssrS\nNoRtI6V4j277ugWF1Xpt1x0YxYyGSZTI4rqGLqVT8x6Llr24YaHCdp56rKWC/5ob\nIFZ7tJys7oQqof11ANDExrnHv/FEE39VDlfEIUVGyCpsyKbzO7MPfdOce2bIaQOS\ndQ76TpYClrnezikJgp9MSQmd3+ozs9w1upGynHNGNmVhzZ5sex9voWcGoyjmOFhs\nwg13S9Hjy3VYq8y0krRYLEGLctd4vnxWGzJzUNSnqezwHZRl4v4Ejp3dQUZP+5sY\n1F81Vj1G264YnZAcWp5x3GTI4K6+k9Xx3pwUPcKOYdlpZQ==\n-----END CERTIFICATE-----\n";

    public static void sendError(Project project, final String login, final String password, final ErrorBean error, final Consumer<Integer> callback, final Consumer<Exception> errback) {
        if (StringUtil.isEmpty((String)login)) {
            return;
        }
        Task.Backgroundable task = new Task.Backgroundable(project, DiagnosticBundle.message("title.submitting.error.report", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/errorreport/itn/ITNProxy$1", "run"));
                }
                try {
                    int threadId = ITNProxy.postNewThread(login, password, error);
                    callback.consume((Object)threadId);
                }
                catch (Exception ex) {
                    errback.consume((Object)ex);
                }
            }
        };
        if (project == null) {
            task.run((ProgressIndicator)new EmptyProgressIndicator());
        } else {
            ProgressManager.getInstance().run((Task)task);
        }
    }

    public static String getBrowseUrl(int threadId) {
        return NEW_THREAD_VIEW_URL + threadId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int postNewThread(String login, String password, ErrorBean error) throws Exception {
        String response;
        Map<String, String> params;
        HttpURLConnection connection;
        int responseCode;
        if (ourSslContext == null) {
            ourSslContext = ITNProxy.initContext();
        }
        if ((responseCode = (connection = ITNProxy.post(new URL(NEW_THREAD_POST_URL), ITNProxy.join(params = ITNProxy.createParameters(login, password, error)))).getResponseCode()) != 200) {
            throw new InternalEAPException(DiagnosticBundle.message("error.http.result.code", responseCode));
        }
        InputStream is = connection.getInputStream();
        try {
            byte[] bytes = FileUtil.loadBytes((InputStream)is);
            response = new String(bytes, ENCODING);
        }
        finally {
            is.close();
        }
        if ("unauthorized".equals(response)) {
            throw new NoSuchEAPUserException(login);
        }
        if (response.startsWith("update ")) {
            throw new UpdateAvailableException(response.substring(7));
        }
        if (response.startsWith("message ")) {
            throw new InternalEAPException(response.substring(8));
        }
        try {
            return Integer.valueOf(response.trim());
        }
        catch (NumberFormatException ex) {
            throw new InternalEAPException(DiagnosticBundle.message("error.itn.returns.wrong.data", new Object[0]));
        }
    }

    private static Map<String, String> createParameters(String login, String password, ErrorBean error) {
        LinkedHashMap params = ContainerUtil.newLinkedHashMap((int)40);
        params.put("protocol.version", "1");
        params.put("user.login", login);
        params.put("user.password", password);
        params.put("os.name", SystemProperties.getOsName());
        params.put("java.version", SystemProperties.getJavaVersion());
        params.put("java.vm.vendor", SystemProperties.getJavaVmVendor());
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        ApplicationNamesInfo namesInfo = ApplicationNamesInfo.getInstance();
        Application application = ApplicationManager.getApplication();
        params.put("app.name", namesInfo.getProductName());
        params.put("app.name.full", namesInfo.getFullProductName());
        params.put("app.name.version", appInfo.getVersionName());
        params.put("app.eap", Boolean.toString(appInfo.isEAP()));
        params.put("app.internal", Boolean.toString(application.isInternal()));
        params.put("app.build", appInfo.getApiVersion());
        params.put("app.version.major", appInfo.getMajorVersion());
        params.put("app.version.minor", appInfo.getMinorVersion());
        params.put("app.build.date", ITNProxy.format(appInfo.getBuildDate()));
        params.put("app.build.date.release", ITNProxy.format(appInfo.getMajorReleaseBuildDate()));
        params.put("app.compilation.timestamp", IdeaLogger.getOurCompilationTimestamp());
        BuildNumber build = appInfo.getBuild();
        String buildNumberWithAllDetails = build.asStringWithAllDetails();
        params.put("app.product.code", build.getProductCode());
        if (StringUtil.startsWith((CharSequence)buildNumberWithAllDetails, (CharSequence)(build.getProductCode() + "-"))) {
            buildNumberWithAllDetails = buildNumberWithAllDetails.substring(build.getProductCode().length() + 1);
        }
        params.put("app.build.number", buildNumberWithAllDetails);
        UpdateSettings updateSettings = UpdateSettings.getInstance();
        params.put("update.channel.status", updateSettings.getSelectedChannelStatus().getCode());
        params.put("update.ignored.builds", StringUtil.join(updateSettings.getIgnoredBuildNumbers(), (String)","));
        params.put("plugin.name", error.getPluginName());
        params.put("plugin.version", error.getPluginVersion());
        params.put("last.action", error.getLastAction());
        params.put("previous.exception", error.getPreviousException() == null ? null : Integer.toString(error.getPreviousException()));
        params.put("error.message", error.getMessage());
        params.put("error.stacktrace", error.getStackTrace());
        params.put("error.description", error.getDescription());
        params.put("assignee.id", error.getAssigneeId() == null ? null : Integer.toString(error.getAssigneeId()));
        for (Attachment attachment : error.getAttachments()) {
            params.put("attachment.name", attachment.getName());
            params.put("attachment.value", attachment.getEncodedBytes());
        }
        return params;
    }

    private static String format(Calendar calendar) {
        return calendar == null ? null : Long.toString(calendar.getTime().getTime());
    }

    private static byte[] join(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> param : params.entrySet()) {
            if (StringUtil.isEmpty((String)param.getKey())) {
                throw new IllegalArgumentException(param.toString());
            }
            if (builder.length() > 0) {
                builder.append('&');
            }
            if (!StringUtil.isNotEmpty((String)param.getValue())) continue;
            builder.append(param.getKey()).append('=').append(URLEncoder.encode(param.getValue(), ENCODING));
        }
        return builder.toString().getBytes(ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection post(URL url, byte[] bytes) throws IOException {
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setSSLSocketFactory(ourSslContext.getSocketFactory());
        if (!NetUtils.isSniEnabled()) {
            connection.setHostnameVerifier(new EaHostnameVerifier(url.getHost(), "ftp.intellij.net"));
        }
        connection.setRequestMethod("POST");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF8");
        connection.setRequestProperty("Content-Length", Integer.toString(bytes.length));
        OutputStream out = connection.getOutputStream();
        try {
            out.write(bytes);
        }
        finally {
            out.close();
        }
        return connection;
    }

    private static synchronized SSLContext initContext() throws GeneralSecurityException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate ca = cf.generateCertificate(new ByteArrayInputStream(JB_CA_CERT.getBytes(ENCODING)));
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        ks.setCertificateEntry("JetBrains CA", ca);
        TrustManagerFactory jbTmf = TrustManagerFactory.getInstance("X.509");
        jbTmf.init(ks);
        TrustManagerFactory sysTmf = TrustManagerFactory.getInstance("X.509");
        sysTmf.init((KeyStore)null);
        SSLContext ctx = SSLContext.getInstance("TLS");
        CompositeX509TrustManager composite = new CompositeX509TrustManager(jbTmf.getTrustManagers(), sysTmf.getTrustManagers());
        ctx.init(null, new TrustManager[]{composite}, null);
        return ctx;
    }

    private static class CompositeX509TrustManager
    implements X509TrustManager {
        private final List<X509TrustManager> myManagers = ContainerUtil.newArrayList();

        public CompositeX509TrustManager(TrustManager[] ... managerSets) {
            TrustManager[][] arr$ = managerSets;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                TrustManager[] set;
                for (TrustManager manager : set = arr$[i$]) {
                    if (!(manager instanceof X509TrustManager)) continue;
                    this.myManagers.add((X509TrustManager)manager);
                }
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certificates, String s) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certificates, String s) throws CertificateException {
            for (X509TrustManager manager : this.myManagers) {
                try {
                    manager.checkServerTrusted(certificates, s);
                    return;
                }
                catch (CertificateException ignored) {
                }
            }
            throw new CertificateException("No trusting managers found for " + s);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            ArrayList result = ContainerUtil.newArrayList();
            for (X509TrustManager manager : this.myManagers) {
                ContainerUtil.addAll((Collection)result, (Object[])manager.getAcceptedIssuers());
            }
            return result.toArray(new X509Certificate[result.size()]);
        }
    }

    private static class EaHostnameVerifier
    implements HostnameVerifier {
        private final Set<String> myAllowedHosts;

        public EaHostnameVerifier(String ... allowedHosts) {
            if (allowedHosts == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedHosts", "com/intellij/errorreport/itn/ITNProxy$EaHostnameVerifier", "<init>"));
            }
            this.myAllowedHosts = ContainerUtil.newHashSet((Object[])allowedHosts);
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            try {
                Certificate certificate;
                Certificate[] certificates = session.getPeerCertificates();
                if (certificates.length > 0 && (certificate = certificates[0]) instanceof X509Certificate) {
                    String cn = CertificateUtil.getCommonName((X509Certificate)((X509Certificate)certificate));
                    return this.myAllowedHosts.contains(cn);
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
            return false;
        }
    }
}

