/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class PatternConfigurationDelegate {
    protected abstract boolean isTestClass(PsiClass var1);

    protected abstract boolean isTestMethod(boolean var1, PsiElement var2);

    public Module findModule(ModuleBasedConfiguration configuration, Module contextModule, Set<String> patterns) {
        return JavaExecutionUtil.findModule((Module)contextModule, patterns, (Project)configuration.getProject(), (Condition)new Condition<PsiClass>(){

            public boolean value(PsiClass psiClass) {
                return PatternConfigurationDelegate.this.isTestClass(psiClass);
            }
        });
    }

    public boolean isMultipleElementsSelected(ConfigurationContext context) {
        if (TestsUIUtil.isMultipleSelectionImpossible(context.getDataContext())) {
            return false;
        }
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        PsiElement[] elements = this.collectPatternElements(context, classes);
        return elements != null && this.collectTestMembers(elements, false).size() > 1;
    }

    public boolean isConfiguredFromContext(ConfigurationContext context, Set<String> patterns) {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        this.collectPatternElements(context, classes);
        return Comparing.equal(classes, patterns);
    }

    public PsiElement checkPatterns(ConfigurationContext context, LinkedHashSet<String> classes) {
        PsiElement[] elements = this.collectPatternElements(context, classes);
        if (elements == null || this.collectTestMembers(elements, false).size() <= 1) {
            return null;
        }
        return elements[0];
    }

    public Set<PsiElement> collectTestMembers(PsiElement[] psiElements, boolean checkAbstract) {
        LinkedHashSet<PsiElement> foundMembers = new LinkedHashSet<PsiElement>();
        for (PsiElement psiElement : psiElements) {
            PsiPackage aPackage;
            if (psiElement instanceof PsiClassOwner) {
                PsiClass[] classes;
                for (PsiClass aClass : classes = ((PsiClassOwner)psiElement).getClasses()) {
                    if (!this.isTestClass(aClass)) continue;
                    foundMembers.add((PsiElement)aClass);
                }
                continue;
            }
            if (psiElement instanceof PsiClass) {
                if (!this.isTestClass((PsiClass)psiElement)) continue;
                foundMembers.add(psiElement);
                continue;
            }
            if (psiElement instanceof PsiMethod) {
                if (!this.isTestMethod(checkAbstract, psiElement)) continue;
                foundMembers.add(psiElement);
                continue;
            }
            if (!(psiElement instanceof PsiDirectory) || (aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)psiElement)) == null) continue;
            foundMembers.add((PsiElement)aPackage);
        }
        return foundMembers;
    }

    private PsiElement[] collectPatternElements(ConfigurationContext context, LinkedHashSet<String> classes) {
        DataContext dataContext = context.getDataContext();
        Location[] locations = (Location[])Location.DATA_KEYS.getData(dataContext);
        if (locations != null) {
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
            for (Location location : locations) {
                PsiElement psiElement = location.getPsiElement();
                classes.add(PatternConfigurationDelegate.getQName(psiElement, location));
                elements.add(psiElement);
            }
            return elements.toArray(new PsiElement[elements.size()]);
        }
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (elements != null) {
            for (PsiElement psiClass : this.collectTestMembers(elements, true)) {
                classes.add(PatternConfigurationDelegate.getQName(psiClass));
            }
            return elements;
        }
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (files != null) {
            ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
            PsiManager psiManager = PsiManager.getInstance((Project)context.getProject());
            for (VirtualFile file : files) {
                PsiFile psiFile = psiManager.findFile(file);
                if (!(psiFile instanceof PsiClassOwner)) continue;
                for (PsiElement psiMember : this.collectTestMembers((PsiElement[])((PsiClassOwner)psiFile).getClasses(), true)) {
                    classes.add(((PsiClass)psiMember).getQualifiedName());
                }
                psiFiles.add(psiFile);
            }
            return psiFiles.toArray(new PsiElement[psiFiles.size()]);
        }
        return null;
    }

    public static String getQName(PsiElement psiMember) {
        return PatternConfigurationDelegate.getQName(psiMember, null);
    }

    public static String getQName(PsiElement psiMember, Location location) {
        if (psiMember instanceof PsiClass) {
            return ((PsiClass)psiMember).getQualifiedName();
        }
        if (psiMember instanceof PsiMember) {
            PsiClass containingClass;
            PsiClass psiClass = containingClass = location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : ((PsiMember)psiMember).getContainingClass();
            assert (containingClass != null);
            return containingClass.getQualifiedName() + "," + ((PsiMember)psiMember).getName();
        }
        if (psiMember instanceof PsiPackage) {
            return ((PsiPackage)psiMember).getQualifiedName();
        }
        assert (false);
        return null;
    }
}

