/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.EdtSortingModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.ui.ScreenUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseByNamePopup
extends ChooseByNameBase
implements ChooseByNamePopupComponent {
    public static final Key<ChooseByNamePopup> CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY = new Key("ChooseByNamePopup");
    private Component myOldFocusOwner;
    private boolean myShowListForEmptyPattern;
    private final boolean myMayRequestCurrentWindow;
    private final ChooseByNamePopup myOldPopup;
    private ActionMap myActionMap;
    private InputMap myInputMap;
    private String myAdText;
    private static final Pattern patternToDetectLinesAndColumns = Pattern.compile("([^:]+)(?::|@|,|)\\[?(\\d+)?(?:(?:\\D)(\\d+)?)?\\]?");
    public static final Pattern patternToDetectAnonymousClasses = Pattern.compile("([\\.\\w]+)((\\$[\\d]+)*(\\$)?)");
    private static final Pattern patternToDetectMembers = Pattern.compile("(.+)(#)(.*)");

    protected ChooseByNamePopup(@Nullable Project project, @NotNull ChooseByNameModel model, @NotNull ChooseByNameItemProvider provider, @Nullable ChooseByNamePopup oldPopup, @Nullable String predefinedText, boolean mayRequestOpenInCurrentWindow, int initialIndex) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/gotoByName/ChooseByNamePopup", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/util/gotoByName/ChooseByNamePopup", "<init>"));
        }
        super(project, model, provider, oldPopup != null ? oldPopup.getEnteredText() : predefinedText, initialIndex);
        this.myOldFocusOwner = null;
        this.myShowListForEmptyPattern = false;
        this.myOldPopup = oldPopup;
        if (oldPopup != null) {
            this.myOldFocusOwner = oldPopup.myPreviouslyFocusedComponent;
        }
        this.myMayRequestCurrentWindow = mayRequestOpenInCurrentWindow;
        this.myAdText = this.myMayRequestCurrentWindow ? "Press " + KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(10, 1)) + " to open in current window" : null;
    }

    public String getEnteredText() {
        return this.myTextField.getText();
    }

    public int getSelectedIndex() {
        return this.myList.getSelectedIndex();
    }

    @Override
    protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
        super.initUI(callback, modalityState, allowMultipleSelection);
        if (this.myOldPopup != null) {
            this.myTextField.setCaretPosition(this.myOldPopup.myTextField.getCaretPosition());
        }
        if (this.myInitialText != null) {
            int selEnd;
            int selStart = this.myOldPopup == null ? 0 : this.myOldPopup.myTextField.getSelectionStart();
            int n = selEnd = this.myOldPopup == null ? this.myInitialText.length() : this.myOldPopup.myTextField.getSelectionEnd();
            if (selEnd > selStart) {
                this.myTextField.select(selStart, selEnd);
            }
            this.rebuildList(this.myInitialIndex, 0, ModalityState.current(), null);
        }
        if (this.myOldFocusOwner != null) {
            this.myPreviouslyFocusedComponent = this.myOldFocusOwner;
            this.myOldFocusOwner = null;
        }
        if (this.myInputMap != null && this.myActionMap != null) {
            for (KeyStroke keyStroke : this.myInputMap.keys()) {
                Object key = this.myInputMap.get(keyStroke);
                this.myTextField.getInputMap().put(keyStroke, key);
                this.myTextField.getActionMap().put(key, this.myActionMap.get(key));
            }
        }
    }

    @Override
    public boolean isOpenInCurrentWindowRequested() {
        return super.isOpenInCurrentWindowRequested() && this.myMayRequestCurrentWindow;
    }

    @Override
    protected boolean isCheckboxVisible() {
        return true;
    }

    @Override
    protected boolean isShowListForEmptyPattern() {
        return this.myShowListForEmptyPattern;
    }

    public void setShowListForEmptyPattern(boolean showListForEmptyPattern) {
        this.myShowListForEmptyPattern = showListForEmptyPattern;
    }

    @Override
    protected boolean isCloseByFocusLost() {
        return UISettings.getInstance().HIDE_NAVIGATION_ON_FOCUS_LOSS;
    }

    @Override
    protected void showList() {
        JLayeredPane layeredPane = this.myTextField.getRootPane().getLayeredPane();
        Rectangle bounds = new Rectangle(this.myTextFieldPanel.getLocationOnScreen(), this.myTextField.getSize());
        bounds.y = bounds.y + (this.myTextFieldPanel.getHeight() + (SystemInfo.isMac ? 3 : 1));
        Dimension preferredScrollPaneSize = this.myListScrollPane.getPreferredSize();
        if (this.myList.getModel().getSize() == 0) {
            preferredScrollPaneSize.height = UIManager.getFont("Label.font").getSize();
        }
        preferredScrollPaneSize.width = Math.max(this.myTextFieldPanel.getWidth(), preferredScrollPaneSize.width);
        Rectangle preferredBounds = new Rectangle(bounds.x, bounds.y, preferredScrollPaneSize.width, preferredScrollPaneSize.height);
        Rectangle original = new Rectangle(preferredBounds);
        ScreenUtil.fitToScreen((Rectangle)preferredBounds);
        if (original.width > preferredBounds.width) {
            int height = this.myListScrollPane.getHorizontalScrollBar().getPreferredSize().height;
            preferredBounds.height += height;
        }
        this.myListScrollPane.setVisible(true);
        this.myListScrollPane.setBorder(null);
        String adText = this.getAdText();
        if (this.myDropdownPopup == null) {
            ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myListScrollPane, (JComponent)this.myListScrollPane);
            builder.setFocusable(false).setLocateWithinScreenBounds(false).setRequestFocus(false).setCancelKeyEnabled(false).setFocusOwners((Component[])new JComponent[]{this.myTextField}).setBelongsToGlobalPopupStack(false).setModalContext(false).setAdText(adText).setMayBeParent(true);
            builder.setCancelCallback((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return Boolean.TRUE;
                }
            });
            this.myDropdownPopup = builder.createPopup();
            this.myDropdownPopup.setLocation(preferredBounds.getLocation());
            this.myDropdownPopup.setSize(preferredBounds.getSize());
            this.myDropdownPopup.show((Component)layeredPane);
        } else {
            this.myDropdownPopup.setLocation(preferredBounds.getLocation());
            Dimension currentSize = this.myDropdownPopup.getSize();
            if (UISettings.getInstance().HIDE_NAVIGATION_ON_FOCUS_LOSS || preferredBounds.width > currentSize.width || preferredBounds.height > currentSize.height) {
                this.myDropdownPopup.setSize(preferredBounds.getSize());
            }
        }
    }

    @Override
    protected void hideList() {
        if (this.myDropdownPopup != null) {
            this.myDropdownPopup.cancel();
            this.myDropdownPopup = null;
        }
    }

    @Override
    public void close(boolean isOk) {
        if (this.checkDisposed()) {
            return;
        }
        if (isOk) {
            this.myModel.saveInitialCheckBoxState(this.myCheckBox.isSelected());
            List<Object> chosenElements = this.getChosenElements();
            if (chosenElements != null) {
                if (this.myActionListener instanceof ChooseByNamePopupComponent.MultiElementsCallback) {
                    ((ChooseByNamePopupComponent.MultiElementsCallback)this.myActionListener).elementsChosen(chosenElements);
                } else {
                    for (Object element : chosenElements) {
                        this.myActionListener.elementChosen(element);
                        String text = this.myModel.getFullName(element);
                        if (text == null) continue;
                        StatisticsManager.getInstance().incUseCount(new StatisticsInfo(this.statisticsContext(), text));
                    }
                }
            } else {
                return;
            }
            if (!chosenElements.isEmpty()) {
                String enteredText = this.getEnteredText();
                if (enteredText.indexOf(42) >= 0) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.wildcards");
                } else {
                    for (Object element : chosenElements) {
                        String name = this.myModel.getElementName(element);
                        if (name == null || StringUtil.startsWithIgnoreCase((String)name, (String)enteredText)) continue;
                        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.camelprefix");
                        break;
                    }
                }
            } else {
                return;
            }
        }
        this.setDisposed(true);
        this.myAlarm.cancelAllRequests();
        if (this.myProject != null) {
            this.myProject.putUserData(CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, null);
        }
        this.cleanupUI(isOk);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (this.myActionListener != null) {
            this.myActionListener.onClose();
        }
    }

    private void cleanupUI(boolean ok) {
        if (this.myTextPopup != null) {
            if (ok) {
                this.myTextPopup.closeOk(null);
            } else {
                this.myTextPopup.cancel();
            }
            this.myTextPopup = null;
        }
        if (this.myDropdownPopup != null) {
            if (ok) {
                this.myDropdownPopup.closeOk(null);
            } else {
                this.myDropdownPopup.cancel();
            }
            this.myDropdownPopup = null;
        }
    }

    public static ChooseByNamePopup createPopup(Project project, ChooseByNameModel model, PsiElement context) {
        return ChooseByNamePopup.createPopup(project, model, new DefaultChooseByNameItemProvider(context), null);
    }

    public static ChooseByNamePopup createPopup(Project project, ChooseByNameModel model, PsiElement context, @Nullable String predefinedText) {
        return ChooseByNamePopup.createPopup(project, model, new DefaultChooseByNameItemProvider(context), predefinedText, false, 0);
    }

    public static ChooseByNamePopup createPopup(Project project, ChooseByNameModel model, PsiElement context, @Nullable String predefinedText, boolean mayRequestOpenInCurrentWindow, int initialIndex) {
        return ChooseByNamePopup.createPopup(project, model, new DefaultChooseByNameItemProvider(context), predefinedText, mayRequestOpenInCurrentWindow, initialIndex);
    }

    public static ChooseByNamePopup createPopup(Project project, @NotNull ChooseByNameModel model, @NotNull ChooseByNameItemProvider provider) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/gotoByName/ChooseByNamePopup", "createPopup"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/util/gotoByName/ChooseByNamePopup", "createPopup"));
        }
        return ChooseByNamePopup.createPopup(project, model, provider, null);
    }

    public static ChooseByNamePopup createPopup(Project project, @NotNull ChooseByNameModel model, @NotNull ChooseByNameItemProvider provider, @Nullable String predefinedText) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/gotoByName/ChooseByNamePopup", "createPopup"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/util/gotoByName/ChooseByNamePopup", "createPopup"));
        }
        return ChooseByNamePopup.createPopup(project, model, provider, predefinedText, false, 0);
    }

    public static ChooseByNamePopup createPopup(Project project, final @NotNull ChooseByNameModel model, @NotNull ChooseByNameItemProvider provider, @Nullable String predefinedText, boolean mayRequestOpenInCurrentWindow, int initialIndex) {
        ChooseByNamePopup oldPopup;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/gotoByName/ChooseByNamePopup", "createPopup"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/util/gotoByName/ChooseByNamePopup", "createPopup"));
        }
        ChooseByNamePopup chooseByNamePopup = oldPopup = project == null ? null : (ChooseByNamePopup)project.getUserData(CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY);
        if (oldPopup != null) {
            oldPopup.close(false);
        }
        ChooseByNamePopup newPopup = new ChooseByNamePopup(project, model, provider, oldPopup, predefinedText, mayRequestOpenInCurrentWindow, initialIndex){

            @Override
            @NotNull
            protected Set<Object> filter(@NotNull Set<Object> elements) {
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/gotoByName/ChooseByNamePopup$2", "filter"));
                }
                Set<Object> set = model instanceof EdtSortingModel ? super.filter(((EdtSortingModel)model).sort(elements)) : super.filter(elements);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNamePopup$2", "filter"));
                }
                return set;
            }
        };
        if (project != null) {
            project.putUserData(CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, (Object)newPopup);
        }
        return newPopup;
    }

    @Override
    public String transformPattern(String pattern) {
        ChooseByNameModel model = this.getModel();
        return ChooseByNamePopup.getTransformedPattern(pattern, model);
    }

    public static String getTransformedPattern(String pattern, ChooseByNameModel model) {
        Matcher matcher;
        Pattern regex = null;
        if (pattern.indexOf(58) != -1 || pattern.indexOf(44) != -1 || pattern.indexOf(59) != -1 || pattern.indexOf(64) != -1) {
            regex = patternToDetectLinesAndColumns;
        }
        if (model instanceof GotoClassModel2) {
            if (pattern.indexOf(35) != -1) {
                regex = patternToDetectMembers;
            }
            if (pattern.indexOf(36) != -1) {
                regex = patternToDetectAnonymousClasses;
            }
        }
        if (regex != null && (matcher = regex.matcher(pattern)).matches()) {
            pattern = matcher.group(1);
        }
        return pattern;
    }

    public int getLinePosition() {
        return this.getLineOrColumn(true);
    }

    private int getLineOrColumn(boolean line) {
        Matcher matcher = patternToDetectLinesAndColumns.matcher(this.getEnteredText());
        if (matcher.matches()) {
            int groupNumber = line ? 2 : 3;
            try {
                String group;
                if (groupNumber <= matcher.groupCount() && (group = matcher.group(groupNumber)) != null) {
                    return Integer.parseInt(group) - 1;
                }
                if (!line && this.getLineOrColumn(true) != -1) {
                    return 0;
                }
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        return -1;
    }

    @Nullable
    public String getPathToAnonymous() {
        String path;
        Matcher matcher = patternToDetectAnonymousClasses.matcher(this.getEnteredText());
        if (matcher.matches() && (path = matcher.group(2)) != null) {
            if ((path = path.trim()).endsWith("$") && path.length() >= 2) {
                path = path.substring(0, path.length() - 2);
            }
            if (!path.isEmpty()) {
                return path;
            }
        }
        return null;
    }

    public int getColumnPosition() {
        return this.getLineOrColumn(false);
    }

    @Nullable
    public String getMemberPattern() {
        int index = this.getEnteredText().lastIndexOf(35);
        if (index == -1) {
            return null;
        }
        String name = this.getEnteredText().substring(index + 1).trim();
        return StringUtil.isEmpty((String)name) ? null : name;
    }

    public void registerAction(@NonNls String aActionName, KeyStroke keyStroke, Action aAction) {
        if (this.myInputMap == null) {
            this.myInputMap = new InputMap();
        }
        if (this.myActionMap == null) {
            this.myActionMap = new ActionMap();
        }
        this.myInputMap.put(keyStroke, aActionName);
        this.myActionMap.put(aActionName, aAction);
    }

    public String getAdText() {
        return this.myAdText;
    }

    public void setAdText(String adText) {
        this.myAdText = adText;
    }

    public void addMouseClickListener(MouseListener listener) {
        this.myList.addMouseListener(listener);
    }

    public Object getSelectionByPoint(Point point) {
        int index = this.myList.locationToIndex(point);
        return index > -1 ? this.myList.getModel().getElementAt(index) : null;
    }

    public void repaintList() {
        this.myList.repaint();
    }
}

