/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.BaseFileConfigurableStoreImpl;
import com.intellij.openapi.components.impl.stores.FileBasedStorage;
import com.intellij.openapi.components.impl.stores.IModuleStore;
import com.intellij.openapi.components.impl.stores.ModuleStateStorageManager;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleStoreImpl
extends BaseFileConfigurableStoreImpl
implements IModuleStore {
    private static final Logger LOG = Logger.getInstance(ModuleStoreImpl.class);
    private final ModuleImpl myModule;

    public ModuleStoreImpl(@NotNull ModuleImpl module, @NotNull PathMacroManager pathMacroManager) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "<init>"));
        }
        if (pathMacroManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathMacroManager", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "<init>"));
        }
        super(pathMacroManager);
        this.myModule = module;
    }

    @Override
    @NotNull
    protected FileBasedStorage getMainStorage() {
        FileBasedStorage storage = (FileBasedStorage)this.getStateStorageManager().getStateStorage("$MODULE_FILE$", RoamingType.PER_USER);
        assert (storage != null);
        FileBasedStorage fileBasedStorage = storage;
        if (fileBasedStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "getMainStorage"));
        }
        return fileBasedStorage;
    }

    @Override
    protected Project getProject() {
        return this.myModule.getProject();
    }

    @Override
    public void load() throws IOException {
        Collection<String> macros;
        super.load();
        String moduleTypeId = (String)this.getMainStorageData().myOptions.get("type");
        this.myModule.setOption("type", ModuleTypeManager.getInstance().findByID(moduleTypeId).getId());
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final TrackingPathMacroSubstitutor substitutor = this.getStateStorageManager().getMacroSubstitutor();
        if (substitutor != null && !(macros = substitutor.getUnknownMacros(null)).isEmpty()) {
            final Project project = this.myModule.getProject();
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

                @Override
                public void run() {
                    StorageUtil.notifyUnknownMacros(substitutor, project, null);
                }
            });
        }
    }

    @Override
    public ModuleFileData getMainStorageData() {
        return (ModuleFileData)super.getMainStorageData();
    }

    @Override
    public void setModuleFilePath(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "setModuleFilePath"));
        }
        String path = filePath.replace(File.separatorChar, '/');
        LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        StateStorageManager storageManager = this.getStateStorageManager();
        storageManager.clearStateStorage("$MODULE_FILE$");
        storageManager.addMacro("$MODULE_FILE$", path);
    }

    @Override
    @Nullable
    public VirtualFile getModuleFile() {
        return this.getMainStorage().getVirtualFile();
    }

    @Override
    @NotNull
    public String getModuleFilePath() {
        String string = this.getMainStorage().getFilePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "getModuleFilePath"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getModuleFileName() {
        String string = PathUtilRt.getFileName((String)this.getMainStorage().getFilePath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "getModuleFileName"));
        }
        return string;
    }

    @Override
    public void setOption(@NotNull String optionName, @NotNull String optionValue) {
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "setOption"));
        }
        if (optionValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionValue", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "setOption"));
        }
        try {
            this.getMainStorageData().setOption(optionName, optionValue);
        }
        catch (StateStorageException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void clearOption(@NotNull String optionName) {
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "clearOption"));
        }
        try {
            this.getMainStorageData().clearOption(optionName);
        }
        catch (StateStorageException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public String getOptionValue(@NotNull String optionName) {
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "getOptionValue"));
        }
        try {
            return this.getMainStorageData().getOptionValue(optionName);
        }
        catch (StateStorageException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Override
    protected boolean optimizeTestLoading() {
        return ((ProjectEx)this.myModule.getProject()).isOptimiseTestLoadSpeed();
    }

    @Override
    @NotNull
    protected MessageBus getMessageBus() {
        MessageBus messageBus = this.myModule.getMessageBus();
        if (messageBus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "getMessageBus"));
        }
        return messageBus;
    }

    @Override
    @NotNull
    protected StateStorageManager createStateStorageManager() {
        ModuleStateStorageManager moduleStateStorageManager = new ModuleStateStorageManager(this.myPathMacroManager.createTrackingSubstitutor(), this.myModule);
        if (moduleStateStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "createStateStorageManager"));
        }
        return moduleStateStorageManager;
    }

    static class ModuleFileData
    extends BaseFileConfigurableStoreImpl.BaseStorageData {
        private final Map<String, String> myOptions;
        private final Module myModule;
        private boolean dirty;

        public ModuleFileData(@NotNull String rootElementName, @NotNull Module module) {
            if (rootElementName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElementName", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "<init>"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "<init>"));
            }
            super(rootElementName);
            this.dirty = true;
            this.myModule = module;
            this.myOptions = new TreeMap<String, String>();
        }

        public boolean isDirty() {
            return this.dirty;
        }

        private ModuleFileData(@NotNull ModuleFileData storageData) {
            if (storageData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "<init>"));
            }
            super(storageData);
            this.dirty = true;
            this.myModule = storageData.myModule;
            this.dirty = storageData.dirty;
            this.myOptions = new TreeMap<String, String>(storageData.myOptions);
        }

        @Override
        public void load(@NotNull Element rootElement, @Nullable PathMacroSubstitutor pathMacroSubstitutor, boolean intern) {
            if (rootElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "load"));
            }
            super.load(rootElement, pathMacroSubstitutor, intern);
            for (Attribute attribute : rootElement.getAttributes()) {
                if (attribute.getName().equals("version")) continue;
                this.myOptions.put(attribute.getName(), attribute.getValue());
            }
            this.dirty = false;
        }

        @Override
        protected void writeOptions(@NotNull Element root, @NotNull String versionString) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "writeOptions"));
            }
            if (versionString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionString", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "writeOptions"));
            }
            if (!this.myOptions.isEmpty()) {
                for (Map.Entry<String, String> entry : this.myOptions.entrySet()) {
                    root.setAttribute(entry.getKey(), entry.getValue());
                }
            }
            super.writeOptions(root, versionString);
            this.dirty = false;
        }

        @Override
        public StorageData clone() {
            return new ModuleFileData(this);
        }

        @Override
        @Nullable
        public Set<String> getChangedComponentNames(@NotNull StorageData newStorageData, @Nullable PathMacroSubstitutor substitutor) {
            if (newStorageData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStorageData", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "getChangedComponentNames"));
            }
            ModuleFileData data = (ModuleFileData)newStorageData;
            if (!((Object)this.myOptions).equals(data.myOptions)) {
                return null;
            }
            return super.getChangedComponentNames(newStorageData, substitutor);
        }

        public void setOption(@NotNull String optionName, @NotNull String optionValue) {
            if (optionName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "setOption"));
            }
            if (optionValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionValue", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "setOption"));
            }
            if (!optionValue.equals(this.myOptions.put(optionName, optionValue))) {
                this.dirty = true;
            }
        }

        public void clearOption(@NotNull String optionName) {
            if (optionName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "clearOption"));
            }
            if (this.myOptions.remove(optionName) != null) {
                this.dirty = true;
            }
        }

        @Nullable
        public String getOptionValue(@NotNull String optionName) {
            if (optionName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "getOptionValue"));
            }
            return this.myOptions.get(optionName);
        }
    }
}

