/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeList;
import com.intellij.openapi.diff.impl.util.DiffPanelOuterComponent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ApplyNonConflicts
extends AnAction
implements DumbAware {
    @Nullable
    private final DiffPanelOuterComponent myDiffPanel;

    public ApplyNonConflicts(@Nullable DiffPanelOuterComponent diffPanel) {
        super(DiffBundle.message((String)"merge.dialog.apply.all.non.conflicting.changes.action.name", (Object[])new Object[0]), null, AllIcons.Diff.ApplyNotConflicts);
        this.myDiffPanel = diffPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        MergeList mergeList = MergeList.fromDataContext(e.getDataContext());
        assert (mergeList != null);
        List notConflicts = ContainerUtil.collect(ApplyNonConflicts.getNotConflicts(mergeList));
        mergeList.startBulkUpdate();
        try {
            for (Change change : notConflicts) {
                Change.apply(change, MergeList.BRANCH_SIDE);
            }
        }
        finally {
            mergeList.finishBulkUpdate();
        }
        if (this.myDiffPanel != null) {
            this.myDiffPanel.requestScrollEditors();
        }
    }

    public void update(AnActionEvent e) {
        MergeList mergeList = MergeList.fromDataContext(e.getDataContext());
        e.getPresentation().setEnabled(ApplyNonConflicts.getNotConflicts(mergeList).hasNext());
    }

    private static Iterator<Change> getNotConflicts(MergeList mergeList) {
        if (mergeList == null) {
            return new ArrayList(1).iterator();
        }
        return FilteringIterator.create(mergeList.getAllChanges(), MergeList.NOT_CONFLICTS);
    }
}

