/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.IterationState;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.TextLayoutHighlightShape;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GraphicAttribute;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class LineView {
    private static final Stroke IME_COMPOSED_TEXT_UNDERLINE_STROKE = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);
    private final TextLayout myLayout;
    private final TabSpacer[] myTabs;

    public LineView(EditorImpl editor, int startOffset, int endOffset, FontRenderContext fontRenderContext) {
        if (startOffset == endOffset) {
            this.myLayout = null;
            this.myTabs = null;
        } else {
            Ref tabs = new Ref();
            AttributedCharacterIterator iterator = LineView.createTextWithAttributes(editor, startOffset, endOffset, fontRenderContext, (Ref<TabSpacer[]>)tabs);
            this.myLayout = new TextLayout(iterator, fontRenderContext);
            this.myTabs = (TabSpacer[])tabs.get();
        }
    }

    public int getWidthInPixels() {
        return this.myLayout == null ? 0 : (int)this.myLayout.getAdvance();
    }

    public static int spacePixelsToColumns(int pixels, int plainSpaceWidth) {
        return pixels < 0 ? 0 : (pixels + plainSpaceWidth / 2) / plainSpaceWidth;
    }

    public static int spaceColumnsToPixels(int columns, int plainSpaceWidth) {
        return columns < 0 ? 0 : columns * plainSpaceWidth;
    }

    public int xToColumn(int x, int plainSpaceWidth, boolean canBeInsideTab) {
        if (this.myLayout == null) {
            return LineView.spacePixelsToColumns(x, plainSpaceWidth);
        }
        if (x <= 0) {
            return 0;
        }
        int width = this.getWidthInPixels();
        if (x >= width) {
            return this.offsetToColumn(this.myLayout.getCharacterCount(), plainSpaceWidth) + LineView.spacePixelsToColumns(x - width, plainSpaceWidth);
        }
        TextHitInfo hit = this.myLayout.hitTestChar(x, 0.0f);
        if (this.myTabs != null && canBeInsideTab) {
            int charIndex = hit.getCharIndex();
            for (TabSpacer tab : this.myTabs) {
                int tabOffset = tab.getOffset();
                if (tabOffset == charIndex) {
                    int tabColumn = this.offsetToColumn(charIndex, plainSpaceWidth);
                    return tabColumn + LineView.spacePixelsToColumns(x - this.columnToX(tabColumn, plainSpaceWidth), plainSpaceWidth);
                }
                if (tabOffset > charIndex) break;
            }
        }
        return this.offsetToColumn(hit.getInsertionIndex(), plainSpaceWidth);
    }

    public int columnToX(int column, int plainSpaceWidth) {
        if (this.myLayout == null) {
            return LineView.spaceColumnsToPixels(column, plainSpaceWidth);
        }
        if (column < 0) {
            return 0;
        }
        int[] result = this.columnToOffset(column, plainSpaceWidth);
        int spacePixels = LineView.spaceColumnsToPixels(result[1], plainSpaceWidth);
        int charCount = this.myLayout.getCharacterCount();
        if (result[0] >= charCount) {
            return this.getWidthInPixels() + spacePixels;
        }
        Point point = new Point();
        this.myLayout.hitToPoint(TextHitInfo.beforeOffset(result[0]), point);
        return point.x + spacePixels;
    }

    public int offsetToColumn(int offset, int plainSpaceWidth) {
        if (this.myTabs == null) {
            return offset;
        }
        int column = offset;
        for (TabSpacer tab : this.myTabs) {
            if (tab.getOffset() >= offset) break;
            column += tab.getWidthInColumns(plainSpaceWidth) - 1;
        }
        return column;
    }

    public int[] columnToOffset(int column, int plainSpaceWidth) {
        int offset;
        int offsetOverflow;
        if (this.myLayout == null) {
            return new int[]{0, column};
        }
        if (column <= 0) {
            return new int[]{0, 0};
        }
        int columnDiff = 0;
        if (this.myTabs != null) {
            for (TabSpacer tab : this.myTabs) {
                int tabStartColumn = tab.getOffset() + columnDiff;
                if (column <= tabStartColumn) {
                    return new int[]{column - columnDiff, 0};
                }
                int tabEndColumn = tabStartColumn + tab.getWidthInColumns(plainSpaceWidth);
                if (column < tabEndColumn) {
                    return new int[]{tab.getOffset(), column - tabStartColumn};
                }
                columnDiff += tab.getWidthInColumns(plainSpaceWidth) - 1;
            }
        }
        if ((offsetOverflow = (offset = column - columnDiff) - this.myLayout.getCharacterCount()) > 0) {
            return new int[]{this.myLayout.getCharacterCount(), offsetOverflow};
        }
        return new int[]{offset, 0};
    }

    public void paintTextAndEffects(Graphics2D g, EditorImpl editor, int startOffset, int endOffset, EditorImpl.WhitespacePaintingStrategy whitespacePaintingStrategy, int plainSpaceWidth) {
        if (this.myLayout != null) {
            this.myLayout.draw(g, 0.0f, editor.getAscent());
            this.paintWhitespace(g, editor, startOffset, endOffset, whitespacePaintingStrategy, plainSpaceWidth);
            this.paintTextEffects(g, editor, startOffset, endOffset);
            this.paintComposedTextDecoration(g, editor, startOffset, endOffset);
        }
    }

    private void paintWhitespace(Graphics2D g, EditorImpl editor, int startOffset, int endOffset, EditorImpl.WhitespacePaintingStrategy whitespacePaintingStrategy, int plainSpaceWidth) {
        g.setColor(editor.getColorsScheme().getColor(EditorColors.WHITESPACES_COLOR));
        CharSequence text = editor.getDocument().getImmutableCharSequence();
        for (int i = startOffset; i < endOffset; ++i) {
            char c = text.charAt(i);
            if (" \t\u3000".indexOf(c) < 0 || !whitespacePaintingStrategy.showWhitespaceAtOffset(i)) continue;
            Point start = new Point();
            this.myLayout.hitToPoint(TextHitInfo.leading(i - startOffset), start);
            Point end = new Point();
            this.myLayout.hitToPoint(TextHitInfo.trailing(i - startOffset), end);
            int y = editor.getAscent();
            if (c == ' ') {
                g.fillRect((start.x + end.x) / 2, y, 1, 1);
                continue;
            }
            if (c == '\t') {
                int startX = Math.min(start.x, end.x);
                int stopX = Math.max(start.x, end.x);
                int height = editor.getCharHeight();
                int halfHeight = height / 2;
                int mid = y - halfHeight;
                int top = y - height;
                UIUtil.drawLine((Graphics)g, (int)startX, (int)mid, (int)(stopX -= plainSpaceWidth / 4), (int)mid);
                UIUtil.drawLine((Graphics)g, (int)stopX, (int)y, (int)stopX, (int)top);
                g.fillPolygon(new int[]{stopX - halfHeight, stopX - halfHeight, stopX}, new int[]{y, y - height, y - halfHeight}, 3);
                continue;
            }
            if (c != '\u3000') continue;
            int charHeight = editor.getCharHeight();
            g.drawRect(Math.min(start.x, end.x) + 2, y - charHeight, Math.abs(start.x - end.x) - 4, charHeight);
        }
    }

    private void paintTextEffects(Graphics2D g, final EditorImpl editor, int startOffset, int endOffset) {
        IterationState it = new IterationState(editor, startOffset, endOffset, editor.isPaintSelection());
        while (!it.atEnd()) {
            EffectType type;
            TextAttributes attributes = it.getMergedAttributes();
            final Color color = attributes.getEffectColor();
            if (LineView.hasTextEffect(color, type = attributes.getEffectType())) {
                this.paintInRange(g, editor, it.getStartOffset() - startOffset, it.getEndOffset() - startOffset, new Consumer<Graphics2D>(){

                    public void consume(Graphics2D window) {
                        window.setColor(color);
                        Rectangle clipBounds = window.getClipBounds();
                        LineView.paintTextEffect(window, editor, (int)clipBounds.getMinX(), (int)clipBounds.getMaxX(), editor.getAscent(), type);
                    }
                });
            }
            it.advance();
        }
    }

    public static boolean hasTextEffect(Color effectColor, EffectType effectType) {
        return effectColor != null && (effectType == EffectType.LINE_UNDERSCORE || effectType == EffectType.BOLD_LINE_UNDERSCORE || effectType == EffectType.BOLD_DOTTED_LINE || effectType == EffectType.WAVE_UNDERSCORE || effectType == EffectType.STRIKEOUT);
    }

    public static void paintTextEffect(Graphics2D g, EditorImpl editor, int xStart, int xEnd, int y, EffectType effectType) {
        if (effectType == EffectType.LINE_UNDERSCORE) {
            UIUtil.drawLine((Graphics)g, (int)xStart, (int)(y + 1), (int)xEnd, (int)(y + 1));
        } else if (effectType == EffectType.BOLD_LINE_UNDERSCORE) {
            UIUtil.drawLine((Graphics)g, (int)xStart, (int)y, (int)xEnd, (int)y);
            UIUtil.drawLine((Graphics)g, (int)xStart, (int)(y + 1), (int)xEnd, (int)(y + 1));
        } else if (effectType == EffectType.STRIKEOUT) {
            int y1 = y - editor.getCharHeight() / 2;
            UIUtil.drawLine((Graphics)g, (int)xStart, (int)y1, (int)xEnd, (int)y1);
        } else if (effectType == EffectType.WAVE_UNDERSCORE) {
            UIUtil.drawWave((Graphics2D)g, (Rectangle)new Rectangle(xStart, y + 1, xEnd - xStart, editor.getDescent() - 1));
        } else if (effectType == EffectType.BOLD_DOTTED_LINE) {
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)xStart, (int)xEnd, (int)(SystemInfo.isMac ? y : y + 1), (Color)editor.getBackgroundColor(), (Color)g.getColor(), (boolean)false);
        }
    }

    private void paintComposedTextDecoration(Graphics2D g, final EditorImpl editor, int startOffset, int endOffset) {
        int end;
        int start;
        TextRange composedTextRange = editor.getComposedTextRange();
        if (composedTextRange != null && (start = LineView.trim(composedTextRange.getStartOffset(), startOffset, endOffset) - startOffset) < (end = LineView.trim(composedTextRange.getEndOffset(), startOffset, endOffset) - startOffset)) {
            this.paintInRange(g, editor, start, end, new Consumer<Graphics2D>(){

                public void consume(Graphics2D window) {
                    window.setColor(editor.getColorsScheme().getColor(EditorColors.CARET_COLOR));
                    window.setStroke(IME_COMPOSED_TEXT_UNDERLINE_STROKE);
                    Rectangle clipBounds = window.getClipBounds();
                    UIUtil.drawLine((Graphics)window, (int)((int)clipBounds.getMinX()), (int)1, (int)((int)clipBounds.getMaxX()), (int)1);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintInRange(Graphics2D g, EditorImpl editor, int start, int end, Consumer<Graphics2D> paintRunnable) {
        TextLayoutHighlightShape shape = new TextLayoutHighlightShape(this.myLayout, start, end, editor.getAscent(), editor.getLineHeight());
        Graphics2D window = (Graphics2D)g.create();
        try {
            shape.setAsClip(window);
            paintRunnable.consume((Object)window);
        }
        finally {
            window.dispose();
        }
    }

    private static int trim(int offset, int minimum, int maximum) {
        return Math.min(maximum, Math.max(minimum, offset));
    }

    public void paintBackground(Graphics2D g, EditorImpl editor, int startOffset, int endOffset, int plainSpaceWidth) {
        IterationState it = new IterationState(editor, startOffset, endOffset, editor.isPaintSelection());
        if (this.myLayout != null) {
            while (!it.atEnd()) {
                LineView.paintBackground(g, editor, this.myLayout, it.getStartOffset() - startOffset, it.getEndOffset() - startOffset, it.getMergedAttributes());
                it.advance();
            }
        }
        int lastSegmentX = LineView.paintAfterLineEndBackgroundSegments(g, editor, it, this.getWidthInPixels(), plainSpaceWidth);
        if (endOffset < editor.getDocument().getTextLength()) {
            Color color = EditorView.getBackgroundColor(editor, it.getPastLineEndBackgroundAttributes());
            LineView.paintBackgroundTillClipRightBoundary(g, editor, color, lastSegmentX);
        } else {
            if (it.hasPastFileEndBackgroundSegments()) {
                lastSegmentX = LineView.paintAfterLineEndBackgroundSegments(g, editor, it, lastSegmentX, plainSpaceWidth);
            }
            Color color = it.getPastFileEndBackground();
            LineView.paintBackgroundTillClipRightBoundary(g, editor, color, lastSegmentX);
        }
    }

    public static void paintBackground(Graphics2D g, EditorImpl editor, TextLayout textLayout, int start, int end, TextAttributes attributes) {
        Color color = EditorView.getBackgroundColor(editor, attributes);
        if (color != null) {
            TextLayoutHighlightShape shape = new TextLayoutHighlightShape(textLayout, start, end, editor.getAscent(), editor.getLineHeight());
            g.setColor(color);
            shape.fill(g);
        }
    }

    private static int paintAfterLineEndBackgroundSegments(Graphics g, EditorImpl editor, IterationState it, int x, int plainSpaceWidth) {
        while (it.hasPastLineEndBackgroundSegment()) {
            int width = plainSpaceWidth * it.getPastLineEndBackgroundSegmentWidth();
            Color color = EditorView.getBackgroundColor(editor, it.getPastLineEndBackgroundAttributes());
            if (color != null) {
                g.setColor(color);
                g.fillRect(x, 0, width, editor.getLineHeight());
            }
            x += width;
            it.advanceToNextPastLineEndBackgroundSegment();
        }
        return x;
    }

    private static void paintBackgroundTillClipRightBoundary(Graphics g, EditorImpl editor, Color color, int x) {
        if (color == null || color.equals(editor.getBackgroundColor())) {
            return;
        }
        Rectangle clipBounds = g.getClipBounds();
        g.setColor(color);
        g.fillRect(x, 0, clipBounds.x + clipBounds.width - x, editor.getLineHeight());
    }

    private static AttributedCharacterIterator createTextWithAttributes(EditorImpl editor, int startOffset, int endOffset, FontRenderContext fontRenderContext, Ref<TabSpacer[]> tabs) {
        String text = ((Object)editor.getDocument().getImmutableCharSequence().subSequence(startOffset, endOffset)).toString();
        AttributedString string = LineView.createAttributedString(text);
        FontPreferences fontPreferences = editor.getColorsScheme().getFontPreferences();
        ArrayList<Integer> tabRendererPositions = new ArrayList<Integer>();
        IterationState it = new IterationState(editor, startOffset, endOffset, true, false, false);
        while (!it.atEnd()) {
            TextAttributes attributes = it.getMergedAttributes();
            LineView.setFontAttributes(string, it.getStartOffset() - startOffset, it.getEndOffset() - startOffset, attributes.getFontType(), attributes.getForegroundColor(), fontPreferences, tabRendererPositions);
            it.advance();
        }
        LineView.insertTabRenderers(editor, string, tabRendererPositions, fontRenderContext, tabs, startOffset == 0);
        return string.getIterator();
    }

    public static AttributedString createAttributedString(String text) {
        AttributedString string = new AttributedString(text);
        string.addAttribute(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
        return string;
    }

    public static void setFontAttributes(AttributedString string, int start, int end, int fontStyle, Color fontColor, FontPreferences fontPreferences, @Nullable List<Integer> tabRendererPositions) {
        AttributedCharacterIterator it = string.getIterator(new AttributedCharacterIterator.Attribute[0], start, end);
        Font currentFont = null;
        int currentIndex = start;
        char c = it.first();
        while (c != '\uffff') {
            int i = it.getIndex();
            Font font = ComplementaryFontsRegistry.getFontAbleToDisplay(c, fontStyle, fontPreferences).getFont();
            if (!font.equals(currentFont)) {
                if (i > currentIndex) {
                    string.addAttribute(TextAttribute.FONT, currentFont, currentIndex, i);
                }
                currentFont = font;
                currentIndex = i;
            }
            if (tabRendererPositions != null && c == '\t') {
                tabRendererPositions.add(i);
            }
            c = it.next();
        }
        if (currentIndex < end) {
            string.addAttribute(TextAttribute.FONT, currentFont, currentIndex, end);
        }
        string.addAttribute(TextAttribute.FOREGROUND, fontColor, start, end);
    }

    private static void insertTabRenderers(EditorImpl editor, AttributedString string, List<Integer> tabRendererPositions, FontRenderContext fontRenderContext, Ref<TabSpacer[]> tabs, boolean firstLine) {
        int tabCount = tabRendererPositions.size();
        if (tabCount == 0) {
            return;
        }
        int[] tabWidths = new int[tabCount];
        int currentPos = 0;
        int currentX = firstLine ? editor.getPrefixTextWidthInPixels() : 0;
        TextMeasurer measurer = null;
        for (int i = 0; i < tabCount; ++i) {
            int pos = tabRendererPositions.get(i);
            if (pos > currentPos) {
                if (measurer == null) {
                    measurer = new TextMeasurer(string.getIterator(), fontRenderContext);
                }
                currentX = (int)((float)currentX + measurer.getAdvanceBetween(currentPos, pos));
                currentPos = pos;
            }
            ++currentPos;
            int nextX = EditorUtil.nextTabStop(currentX, editor);
            tabWidths[i] = nextX - currentX;
            currentX = nextX;
        }
        TabSpacer[] tabArray = new TabSpacer[tabCount];
        for (int i = 0; i < tabCount; ++i) {
            int pos = tabRendererPositions.get(i);
            tabArray[i] = new TabSpacer(editor, pos, tabWidths[i]);
            string.addAttribute(TextAttribute.CHAR_REPLACEMENT, tabArray[i], pos, pos + 1);
        }
        tabs.set((Object)tabArray);
    }

    public TextLayoutHighlightShape getRangeShape(EditorImpl editor, int start, int end) {
        return new TextLayoutHighlightShape(this.myLayout, start, end, editor.getAscent(), editor.getLineHeight());
    }

    public int getVisualLineEndOffset() {
        return this.myLayout == null ? 0 : this.myLayout.hitTestChar(this.myLayout.getAdvance() - 1.0f, 0.0f).getInsertionIndex();
    }

    private static class TabSpacer
    extends GraphicAttribute {
        private final EditorImpl myEditor;
        private final int myOffset;
        private final int myWidthInPixels;

        public TabSpacer(EditorImpl editor, int offset, int widthInPixels) {
            super(0);
            this.myEditor = editor;
            this.myOffset = offset;
            this.myWidthInPixels = widthInPixels;
        }

        @Override
        public float getAscent() {
            return this.myEditor.getAscent();
        }

        @Override
        public float getDescent() {
            return this.myEditor.getDescent();
        }

        @Override
        public float getAdvance() {
            return this.myWidthInPixels;
        }

        public int getOffset() {
            return this.myOffset;
        }

        public int getWidthInColumns(int plainSpaceWidth) {
            return EditorUtil.columnsNumber(this.myWidthInPixels, plainSpaceWidth);
        }

        @Override
        public void draw(Graphics2D graphics, float x, float y) {
        }
    }
}

