/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.BlockingProgressIndicator;
import com.intellij.openapi.progress.util.ProgressDialog;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.FocusTrackback;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressWindow
extends ProgressIndicatorBase
implements BlockingProgressIndicator,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.util.ProgressWindow");
    public static final int DEFAULT_PROGRESS_DIALOG_POSTPONE_TIME_MILLIS = 300;
    private ProgressDialog myDialog;
    final Project myProject;
    final boolean myShouldShowCancel;
    String myCancelText;
    private String myTitle = null;
    private boolean myStoppedAlready = false;
    protected final FocusTrackback myFocusTrackback;
    private boolean myStarted = false;
    protected boolean myBackgrounded = false;
    private String myProcessId = "<unknown>";
    @Nullable
    private volatile Runnable myBackgroundHandler;
    private int myDelayInMillis = 300;

    public ProgressWindow(boolean shouldShowCancel, Project project) {
        this(shouldShowCancel, false, project);
    }

    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project) {
        this(shouldShowCancel, shouldShowBackground, project, null);
    }

    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project, String cancelText) {
        this(shouldShowCancel, shouldShowBackground, project, null, cancelText);
    }

    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project, JComponent parentComponent, String cancelText) {
        this.myProject = project;
        this.myShouldShowCancel = shouldShowCancel;
        this.myCancelText = cancelText;
        this.setModalityProgress(shouldShowBackground ? null : this);
        this.myFocusTrackback = new FocusTrackback((Object)this, WindowManager.getInstance().suggestParentWindow(project), false);
        Container parent = parentComponent;
        if (parent == null && project == null && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            parent = JOptionPane.getRootFrame();
        }
        this.myDialog = parent == null ? new ProgressDialog(this, shouldShowBackground, this.myProject, this.myCancelText) : new ProgressDialog(this, shouldShowBackground, parent, this.myCancelText);
        Disposer.register((Disposable)this, (Disposable)this.myDialog);
        this.myFocusTrackback.registerFocusComponent(this.myDialog.getPanel());
        this.addStateDelegate(new AbstractProgressIndicatorExBase(){

            @Override
            public void cancel() {
                super.cancel();
                if (ProgressWindow.this.myDialog != null) {
                    ProgressWindow.this.myDialog.cancel();
                }
            }
        });
    }

    @Override
    public synchronized void start() {
        LOG.assertTrue(!this.isRunning());
        LOG.assertTrue(!this.myStoppedAlready);
        super.start();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.prepareShowDialog();
        }
        this.myStarted = true;
    }

    public void setDelayInMillis(int delayInMillis) {
        this.myDelayInMillis = delayInMillis;
    }

    private synchronized boolean isStarted() {
        return this.myStarted;
    }

    protected void prepareShowDialog() {
        Timer timer = UIUtil.createNamedTimer((String)"Progress window timer", (int)this.myDelayInMillis, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ProgressWindow.this.isRunning()) {
                            DialogWrapper popup;
                            if (ProgressWindow.this.myDialog != null && (popup = ((ProgressWindow)ProgressWindow.this).myDialog.myPopup) != null) {
                                ProgressWindow.this.myFocusTrackback.registerFocusComponent(new FocusTrackback.ComponentQuery(){

                                    @Override
                                    public Component getComponent() {
                                        return popup.getPreferredFocusedComponent();
                                    }
                                });
                                if (popup.isShowing()) {
                                    ((ProgressWindow)ProgressWindow.this).myDialog.myWasShown = true;
                                }
                            }
                            ProgressWindow.this.showDialog();
                        } else {
                            Disposer.dispose((Disposable)ProgressWindow.this);
                        }
                    }
                }, ProgressWindow.this.getModalityState());
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startBlocking() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ProgressWindow progressWindow = this;
        synchronized (progressWindow) {
            LOG.assertTrue(!this.isRunning());
            LOG.assertTrue(!this.myStoppedAlready);
        }
        this.enterModality();
        IdeEventQueue.getInstance().pumpEventsForHierarchy(this.myDialog.myPanel, new Condition<AWTEvent>(){

            public boolean value(AWTEvent object) {
                if (ProgressWindow.this.myShouldShowCancel && object instanceof KeyEvent && object.getID() == 401 && ((KeyEvent)object).getKeyCode() == 27 && ((KeyEvent)object).getModifiers() == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProgressWindow.this.cancel();
                        }
                    });
                }
                return ProgressWindow.this.isStarted() && !ProgressWindow.this.isRunning();
            }
        });
        this.exitModality();
    }

    @NotNull
    public String getProcessId() {
        String string = this.myProcessId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressWindow", "getProcessId"));
        }
        return string;
    }

    public void setProcessId(@NotNull String processId) {
        if (processId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processId", "com/intellij/openapi/progress/util/ProgressWindow", "setProcessId"));
        }
        this.myProcessId = processId;
    }

    protected void showDialog() {
        if (!this.isRunning() || this.isCanceled()) {
            return;
        }
        this.myDialog.show();
        if (this.myDialog != null) {
            this.myDialog.myRepaintRunnable.run();
        }
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.update();
    }

    @Override
    public synchronized void stop() {
        LOG.assertTrue(!this.myStoppedAlready);
        super.stop();
        if (this.isDialogShowing() && this.myFocusTrackback != null) {
            this.myFocusTrackback.setWillBeSheduledForRestore();
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean wasShowing = ProgressWindow.this.isDialogShowing();
                if (ProgressWindow.this.myDialog != null) {
                    ProgressWindow.this.myDialog.hide();
                }
                if (ProgressWindow.this.myFocusTrackback != null) {
                    if (wasShowing) {
                        ProgressWindow.this.myFocusTrackback.restoreFocus();
                    } else {
                        ProgressWindow.this.myFocusTrackback.consume();
                    }
                }
                ProgressWindow progressWindow = ProgressWindow.this;
                synchronized (progressWindow) {
                    ProgressWindow.this.myStoppedAlready = true;
                }
                Disposer.dispose((Disposable)ProgressWindow.this);
            }
        });
        SwingUtilities.invokeLater(EmptyRunnable.INSTANCE);
    }

    private boolean isDialogShowing() {
        return this.myDialog != null && this.myDialog.getPanel() != null && this.myDialog.getPanel().isShowing();
    }

    public void background() {
        Runnable backgroundHandler = this.myBackgroundHandler;
        if (backgroundHandler != null) {
            backgroundHandler.run();
            return;
        }
        if (this.myDialog != null) {
            this.myBackgrounded = true;
            this.myDialog.background();
            if (this.myDialog.wasShown()) {
                this.myFocusTrackback.restoreFocus();
            } else {
                this.myFocusTrackback.consume();
            }
            this.myDialog = null;
        }
    }

    public boolean isBackgrounded() {
        return this.myBackgrounded;
    }

    @Override
    public void setText(String text) {
        if (!Comparing.equal((String)text, (String)this.getText())) {
            super.setText(text);
            this.update();
        }
    }

    @Override
    public void setFraction(double fraction) {
        if (fraction != this.getFraction()) {
            super.setFraction(fraction);
            this.update();
        }
    }

    @Override
    public void setText2(String text) {
        if (!Comparing.equal((String)text, (String)this.getText2())) {
            super.setText2(text);
            this.update();
        }
    }

    private void update() {
        if (this.myDialog != null) {
            this.myDialog.update();
        }
    }

    public void setTitle(String title) {
        if (!Comparing.equal((String)title, (String)this.myTitle)) {
            this.myTitle = title;
            this.update();
        }
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setBackgroundHandler(@Nullable Runnable backgroundHandler) {
        this.myBackgroundHandler = backgroundHandler;
        this.myDialog.setShouldShowBackground(backgroundHandler != null);
    }

    public void setCancelButtonText(String text) {
        if (this.myDialog != null) {
            this.myDialog.changeCancelButtonText(text);
        } else {
            this.myCancelText = text;
        }
    }

    IdeFocusManager getFocusManager() {
        return IdeFocusManager.getInstance((Project)this.myProject);
    }

    public void dispose() {
    }

    @Override
    public boolean isPopupWasShown() {
        return this.myDialog != null && this.myDialog.myPopup != null && this.myDialog.myPopup.isShowing();
    }
}

