/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;

public class ChangeLibraryLevelDialog
extends DialogWrapper {
    private JTextField myNameField;
    private JCheckBox myCopyFilesCheckBox;
    private TextFieldWithBrowseButton myDirectoryForFilesField;
    private JPanel myMainPanel;
    private final boolean myAllowEmptyName;
    private LibraryTable.ModifiableModel myModifiableModel;

    public ChangeLibraryLevelDialog(JComponent parent, Project project, boolean copy, String libraryName, String path, boolean allowEmptyName, LibraryTableModifiableModelProvider provider) {
        super((Component)parent, true);
        this.myAllowEmptyName = allowEmptyName;
        this.$$$setupUI$$$();
        String actionName = copy ? "Copy" : "Move";
        this.setTitle(actionName + " Library");
        this.myCopyFilesCheckBox.setText(actionName + " library files to:");
        this.myCopyFilesCheckBox.setMnemonic(copy ? (char)'C' : 'M');
        this.myCopyFilesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeLibraryLevelDialog.this.updateDirectoriesForFilesField();
            }
        });
        this.myModifiableModel = provider.getModifiableModel();
        this.myNameField.setText(libraryName);
        this.myDirectoryForFilesField.addBrowseFolderListener("Directory for Library Files", null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myDirectoryForFilesField.setText(FileUtil.toSystemDependentName((String)path));
        this.myNameField.selectAll();
        this.init();
        this.checkName();
        this.updateDirectoriesForFilesField();
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ChangeLibraryLevelDialog.this.checkName();
            }
        });
    }

    private void checkName() {
        String name = this.getLibraryName();
        if (name.isEmpty()) {
            if (!this.myAllowEmptyName) {
                this.setErrorText("Library name is not specified");
            }
            return;
        }
        if (LibraryEditingUtil.libraryAlreadyExists(this.myModifiableModel, name)) {
            this.setErrorText("Library '" + name + "' already exists");
            return;
        }
        this.setErrorText(null);
    }

    private void updateDirectoriesForFilesField() {
        this.myDirectoryForFilesField.setEnabled(this.myCopyFilesCheckBox.isSelected());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public String getLibraryName() {
        return this.myNameField.getText().trim();
    }

    @Nullable
    public String getDirectoryForFilesPath() {
        if (!this.myCopyFilesCheckBox.isSelected()) {
            return null;
        }
        return FileUtil.toSystemIndependentName((String)this.myDirectoryForFilesField.getText());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        this.myCopyFilesCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Copy library files to:");
        jCheckBox.setMnemonic('C');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDirectoryForFilesField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 0, 1, 1, 0, 1, 6, 0, null, new Dimension(350, -1), null, 1));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

