/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.icons.AllIcons;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentEP;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.NotNullFunction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesViewContentManager
extends AbstractProjectComponent
implements ChangesViewContentI {
    public static final String TOOLWINDOW_ID = Registry.is((String)"vcs.merge.toolwindows") ? ToolWindowId.VCS : VcsBundle.message((String)"changes.toolwindow.name", (Object[])new Object[0]);
    private static final Key<ChangesViewContentEP> myEPKey = Key.create((String)"ChangesViewContentEP");
    private static final Logger LOG = Logger.getInstance(ChangesViewContentManager.class);
    private MyContentManagerListener myContentManagerListener;
    private final ProjectLevelVcsManager myVcsManager;
    private ContentManager myContentManager;
    private ToolWindow myToolWindow;
    private final VcsListener myVcsListener = new MyVcsListener();
    private final Alarm myVcsChangeAlarm;
    private final List<Content> myAddedContents = new ArrayList<Content>();
    @NotNull
    private final CountDownLatch myInitializationWaiter = new CountDownLatch(1);
    public static final String LOCAL_CHANGES = Registry.is((String)"vcs.merge.toolwindows") ? "Local Changes" : "Local";
    public static final String REPOSITORY = "Repository";
    public static final String INCOMING = "Incoming";
    public static final String SHELF = "Shelf";
    private static final String[] ourPresetOrder = new String[]{LOCAL_CHANGES, "Repository", "Incoming", "Shelf"};

    public static ChangesViewContentI getInstance(Project project) {
        return (ChangesViewContentI)PeriodicalTasksCloser.getInstance().safeGetComponent(project, ChangesViewContentI.class);
    }

    public ChangesViewContentManager(Project project, ProjectLevelVcsManager vcsManager) {
        super(project);
        this.myVcsManager = vcsManager;
        this.myVcsChangeAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
    }

    public void projectOpened() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)ChangesViewContentManager.this.myProject);
                if (toolWindowManager != null) {
                    ChangesViewContentManager.this.myToolWindow = toolWindowManager.registerToolWindow(TOOLWINDOW_ID, true, ToolWindowAnchor.BOTTOM, (Disposable)ChangesViewContentManager.this.myProject, true);
                    ChangesViewContentManager.this.myToolWindow.setIcon(AllIcons.Toolwindows.ToolWindowChanges);
                    ChangesViewContentManager.this.updateToolWindowAvailability();
                    final ContentManager contentManager = ChangesViewContentManager.this.myToolWindow.getContentManager();
                    ChangesViewContentManager.this.myContentManagerListener = new MyContentManagerListener();
                    contentManager.addContentManagerListener((ContentManagerListener)ChangesViewContentManager.this.myContentManagerListener);
                    ChangesViewContentManager.this.myVcsManager.addVcsListener(ChangesViewContentManager.this.myVcsListener);
                    Disposer.register((Disposable)ChangesViewContentManager.this.myProject, (Disposable)new Disposable(){

                        public void dispose() {
                            contentManager.removeContentManagerListener((ContentManagerListener)ChangesViewContentManager.this.myContentManagerListener);
                            ChangesViewContentManager.this.myVcsManager.removeVcsListener(ChangesViewContentManager.this.myVcsListener);
                        }
                    });
                    ChangesViewContentManager.this.loadExtensionTabs();
                    ChangesViewContentManager.this.myContentManager = contentManager;
                    List ordered = ChangesViewContentManager.doPresetOrdering(ChangesViewContentManager.this.myAddedContents);
                    for (Content content : ordered) {
                        ChangesViewContentManager.this.myContentManager.addContent(content);
                    }
                    ChangesViewContentManager.this.myAddedContents.clear();
                    if (contentManager.getContentCount() > 0) {
                        contentManager.setSelectedContent(contentManager.getContent(0));
                    }
                    ChangesViewContentManager.this.myInitializationWaiter.countDown();
                }
            }
        });
    }

    public void executeWhenInitialized(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/vcs/changes/ui/ChangesViewContentManager", "executeWhenInitialized"));
        }
        try {
            this.myInitializationWaiter.await();
            runnable.run();
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
    }

    private void loadExtensionTabs() {
        ChangesViewContentEP[] contentEPs;
        LinkedList<Content> contentList = new LinkedList<Content>();
        for (ChangesViewContentEP ep : contentEPs = (ChangesViewContentEP[])this.myProject.getExtensions(ChangesViewContentEP.EP_NAME)) {
            NotNullFunction<Project, Boolean> predicate = ep.newPredicateInstance(this.myProject);
            if (predicate != null && !((Boolean)predicate.fun((Object)this.myProject)).equals(Boolean.TRUE)) continue;
            Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)new ContentStub(ep), ep.getTabName(), false);
            content.setCloseable(false);
            content.putUserData(myEPKey, (Object)ep);
            contentList.add(content);
        }
        this.myAddedContents.addAll(0, contentList);
    }

    private void addExtensionTab(ChangesViewContentEP ep) {
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)new ContentStub(ep), ep.getTabName(), false);
        content.setCloseable(false);
        content.putUserData(myEPKey, (Object)ep);
        this.addIntoCorrectPlace(content);
    }

    private void updateExtensionTabs() {
        ChangesViewContentEP[] contentEPs;
        for (ChangesViewContentEP ep : contentEPs = (ChangesViewContentEP[])this.myProject.getExtensions(ChangesViewContentEP.EP_NAME)) {
            NotNullFunction<Project, Boolean> predicate = ep.newPredicateInstance(this.myProject);
            if (predicate == null) continue;
            Content epContent = this.findEPContent(ep);
            Boolean predicateResult = (Boolean)predicate.fun((Object)this.myProject);
            if (predicateResult.equals(Boolean.TRUE) && epContent == null) {
                this.addExtensionTab(ep);
                continue;
            }
            if (!predicateResult.equals(Boolean.FALSE) || epContent == null) continue;
            if (!(epContent.getComponent() instanceof ContentStub)) {
                ep.getInstance(this.myProject).disposeContent();
            }
            this.myContentManager.removeContent(epContent, true);
        }
    }

    @Nullable
    private Content findEPContent(ChangesViewContentEP ep) {
        Content[] contents;
        for (Content content : contents = this.myContentManager.getContents()) {
            if (content.getUserData(myEPKey) != ep) continue;
            return content;
        }
        return null;
    }

    private void updateToolWindowAvailability() {
        AbstractVcs[] abstractVcses = this.myVcsManager.getAllActiveVcss();
        this.myToolWindow.setAvailable(abstractVcses.length > 0, null);
    }

    public boolean isToolwindowVisible() {
        return !this.myToolWindow.isDisposed() && this.myToolWindow.isVisible();
    }

    public void projectClosed() {
        this.myVcsChangeAlarm.cancelAllRequests();
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ChangesViewContentManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesViewContentManager", "getComponentName"));
        }
        return "ChangesViewContentManager";
    }

    @Override
    public void addContent(Content content) {
        if (this.myContentManager == null) {
            this.myAddedContents.add(content);
        } else {
            this.addIntoCorrectPlace(content);
        }
    }

    @Override
    public void removeContent(Content content) {
        if (this.myContentManager != null && !this.myContentManager.isDisposed()) {
            this.myContentManager.removeContent(content, true);
        }
    }

    @Override
    public void setSelectedContent(Content content) {
        this.myContentManager.setSelectedContent(content);
    }

    @Override
    @Nullable
    public <T> T getActiveComponent(Class<T> aClass) {
        Content content = this.myContentManager.getSelectedContent();
        if (content != null && aClass.isInstance(content.getComponent())) {
            return (T)content.getComponent();
        }
        return null;
    }

    public boolean isContentSelected(Content content) {
        return Comparing.equal((Object)content, (Object)this.myContentManager.getSelectedContent());
    }

    @Override
    public void selectContent(String tabName) {
        for (Content content : this.myContentManager.getContents()) {
            if (!content.getDisplayName().equals(tabName)) continue;
            this.myContentManager.setSelectedContent(content);
            break;
        }
    }

    private static List<Content> doPresetOrdering(List<Content> contents) {
        ArrayList<Content> result = new ArrayList<Content>(contents.size());
        for (String preset : ourPresetOrder) {
            Iterator<Content> iterator = contents.iterator();
            while (iterator.hasNext()) {
                Content current = iterator.next();
                if (!preset.equals(current.getTabName())) continue;
                iterator.remove();
                result.add(current);
            }
        }
        result.addAll(contents);
        return result;
    }

    private void addIntoCorrectPlace(Content content) {
        String name = content.getTabName();
        Content[] contents = this.myContentManager.getContents();
        int idxOfBeingInserted = -1;
        for (int i = 0; i < ourPresetOrder.length; ++i) {
            String s = ourPresetOrder[i];
            if (!s.equals(name)) continue;
            idxOfBeingInserted = i;
        }
        if (idxOfBeingInserted == -1) {
            this.myContentManager.addContent(content);
            return;
        }
        HashSet<String> existingNames = new HashSet<String>();
        for (Content existingContent : contents) {
            existingNames.add(existingContent.getTabName());
        }
        int place = idxOfBeingInserted;
        for (int i = 0; i < idxOfBeingInserted; ++i) {
            if (existingNames.contains(ourPresetOrder[i])) continue;
            --place;
        }
        this.myContentManager.addContent(content, place);
    }

    private class MyContentManagerListener
    extends ContentManagerAdapter {
        private MyContentManagerListener() {
        }

        public void selectionChanged(ContentManagerEvent event) {
            Content content = event.getContent();
            if (content.getComponent() instanceof ContentStub) {
                ChangesViewContentEP ep = ((ContentStub)content.getComponent()).getEP();
                ChangesViewContentProvider provider = ep.getInstance(ChangesViewContentManager.this.myProject);
                JComponent contentComponent = provider.initContent();
                content.setComponent(contentComponent);
                if (contentComponent instanceof Disposable) {
                    content.setDisposer((Disposable)contentComponent);
                }
            }
        }
    }

    private static class ContentStub
    extends JPanel {
        private final ChangesViewContentEP myEP;

        private ContentStub(ChangesViewContentEP EP) {
            this.myEP = EP;
        }

        public ChangesViewContentEP getEP() {
            return this.myEP;
        }
    }

    private class MyVcsListener
    implements VcsListener {
        private MyVcsListener() {
        }

        public void directoryMappingChanged() {
            ChangesViewContentManager.this.myVcsChangeAlarm.cancelAllRequests();
            ChangesViewContentManager.this.myVcsChangeAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    if (ChangesViewContentManager.this.myProject.isDisposed()) {
                        return;
                    }
                    ChangesViewContentManager.this.updateToolWindowAvailability();
                    ChangesViewContentManager.this.updateExtensionTabs();
                }
            }, 100, ModalityState.NON_MODAL);
        }
    }
}

