/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.util.scopeChooser.PackageSetChooserCombo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DefaultScopesProvider;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class DependencyConfigurable
extends BaseConfigurable {
    private final Project myProject;
    private MyTableModel myDenyRulesModel;
    private MyTableModel myAllowRulesModel;
    private TableView<DependencyRule> myDenyTable;
    private TableView<DependencyRule> myAllowTable;
    private final ColumnInfo<DependencyRule, NamedScope> DENY_USAGES_OF;
    private final ColumnInfo<DependencyRule, NamedScope> DENY_USAGES_IN;
    private final ColumnInfo<DependencyRule, NamedScope> ALLOW_USAGES_OF;
    private final ColumnInfo<DependencyRule, NamedScope> ALLOW_USAGES_ONLY_IN;
    private JPanel myWholePanel;
    private JPanel myDenyPanel;
    private JPanel myAllowPanel;
    private JCheckBox mySkipImports;
    private static final Logger LOG = Logger.getInstance((String)("#" + DependencyConfigurable.class.getName()));
    private static final DefaultTableCellRenderer CELL_RENDERER = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setText(value == null ? "" : ((NamedScope)value).getName());
            return this;
        }
    };

    public DependencyConfigurable(Project project) {
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.DENY_USAGES_OF = new LeftColumn(AnalysisScopeBundle.message((String)"dependency.configurable.deny.table.column1", (Object[])objectArray));
        this.DENY_USAGES_IN = new RightColumn(AnalysisScopeBundle.message((String)"dependency.configurable.deny.table.column2", (Object[])new Object[0]));
        this.ALLOW_USAGES_OF = new LeftColumn(AnalysisScopeBundle.message((String)"dependency.configurable.allow.table.column1", (Object[])new Object[0]));
        this.ALLOW_USAGES_ONLY_IN = new RightColumn(AnalysisScopeBundle.message((String)"dependency.configurable.allow.table.column2", (Object[])new Object[0]));
        this.myProject = project;
    }

    public String getDisplayName() {
        return AnalysisScopeBundle.message((String)"dependency.configurable.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "editing.analyzeDependencies.validation";
    }

    public JComponent createComponent() {
        this.myDenyRulesModel = new MyTableModel(this.myProject, new ColumnInfo[]{this.DENY_USAGES_OF, this.DENY_USAGES_IN}, true);
        this.myDenyRulesModel.setSortable(false);
        this.myAllowRulesModel = new MyTableModel(this.myProject, new ColumnInfo[]{this.ALLOW_USAGES_OF, this.ALLOW_USAGES_ONLY_IN}, false);
        this.myAllowRulesModel.setSortable(false);
        this.myDenyTable = new TableView((ListTableModel)this.myDenyRulesModel);
        this.myDenyPanel.add((Component)this.createRulesPanel(this.myDenyRulesModel, this.myDenyTable), "Center");
        this.myAllowTable = new TableView((ListTableModel)this.myAllowRulesModel);
        this.myAllowPanel.add((Component)this.createRulesPanel(this.myAllowRulesModel, this.myAllowTable), "Center");
        return this.myWholePanel;
    }

    private JPanel createRulesPanel(MyTableModel model, TableView<DependencyRule> table) {
        table.setSurrendersFocusOnKeystroke(true);
        table.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)300, (int)150));
        table.setShowGrid(true);
        table.setRowHeight(new PackageSetChooserCombo((Project)this.myProject, null).getPreferredSize().height);
        return ToolbarDecorator.createDecorator(table).createPanel();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDenyTable;
    }

    public void apply() throws ConfigurationException {
        this.stopTableEditing();
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)this.myProject);
        validationManager.removeAllRules();
        HashMap unUsed = new HashMap(validationManager.getUnnamedScopes());
        ArrayList modelItems = new ArrayList();
        modelItems.addAll(this.myDenyRulesModel.getItems());
        modelItems.addAll(this.myAllowRulesModel.getItems());
        for (DependencyRule rule : modelItems) {
            NamedScope toScope;
            validationManager.addRule(rule);
            NamedScope fromScope = rule.getFromScope();
            if (fromScope instanceof NamedScope.UnnamedScope) {
                PackageSet fromPackageSet = fromScope.getValue();
                LOG.assertTrue(fromPackageSet != null);
                unUsed.remove(fromPackageSet.getText());
            }
            if (!((toScope = rule.getToScope()) instanceof NamedScope.UnnamedScope)) continue;
            PackageSet toPackageSet = toScope.getValue();
            LOG.assertTrue(toPackageSet != null);
            unUsed.remove(toPackageSet.getText());
        }
        for (String text : unUsed.keySet()) {
            validationManager.getUnnamedScopes().remove(text);
        }
        validationManager.setSkipImportStatements(this.mySkipImports.isSelected());
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    private void stopTableEditing() {
        this.myDenyTable.stopEditing();
        this.myAllowTable.stopEditing();
    }

    public void reset() {
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)this.myProject);
        DependencyRule[] rules = validationManager.getAllRules();
        ArrayList<DependencyRule> denyList = new ArrayList<DependencyRule>();
        ArrayList<DependencyRule> allowList = new ArrayList<DependencyRule>();
        for (DependencyRule rule : rules) {
            if (rule.isDenyRule()) {
                denyList.add(rule.createCopy());
                continue;
            }
            allowList.add(rule.createCopy());
        }
        this.myDenyRulesModel.setItems(denyList);
        this.myAllowRulesModel.setItems(allowList);
        this.mySkipImports.setSelected(validationManager.skipImportStatements());
    }

    public boolean isModified() {
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)this.myProject);
        if (validationManager.skipImportStatements() != this.mySkipImports.isSelected()) {
            return true;
        }
        ArrayList rules = new ArrayList();
        rules.addAll(this.myDenyRulesModel.getItems());
        rules.addAll(this.myAllowRulesModel.getItems());
        return !((Object)Arrays.asList(validationManager.getAllRules())).equals(rules);
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        this.myWholePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new FormLayout("fill:max(d;4px):grow", "center:max(d;4px):grow,top:7dlu:noGrow,center:max(d;4px):grow,top:4dlu:noGrow,center:max(d;4px):noGrow"));
        this.mySkipImports = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/AnalysisScopeBundle").getString("skip.import.statements.checkbox.title"));
        jPanel3.add((Component)jCheckBox, new CellConstraints(1, 5, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myAllowPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.myDenyPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyTableModel
    extends ListTableModel<DependencyRule>
    implements EditableModel {
        private final Project myProject;
        private final boolean myDenyRule;

        public MyTableModel(Project project, ColumnInfo[] columnInfos, boolean isDenyRule) {
            super(columnInfos);
            this.myProject = project;
            this.myDenyRule = isDenyRule;
        }

        public void addRow() {
            ArrayList<DependencyRule> newList = new ArrayList<DependencyRule>(this.getItems());
            NamedScope scope = DefaultScopesProvider.getAllScope();
            newList.add(new DependencyRule(scope, scope, this.myDenyRule));
            this.setItems(newList);
        }

        public void exchangeRows(int index1, int index2) {
            ArrayList<DependencyRule> newList = new ArrayList<DependencyRule>(this.getItems());
            DependencyRule r1 = (DependencyRule)newList.get(index1);
            DependencyRule r2 = (DependencyRule)newList.get(index2);
            newList.set(index1, r2);
            newList.set(index2, r1);
            this.setItems(newList);
        }
    }

    private class LeftColumn
    extends MyColumnInfo {
        public LeftColumn(String name) {
            super(name);
        }

        public NamedScope valueOf(DependencyRule rule) {
            return rule.getToScope();
        }

        @Override
        public void setValue(DependencyRule rule, NamedScope set) {
            rule.setToScope(set);
        }
    }

    private class RightColumn
    extends MyColumnInfo {
        public RightColumn(String name) {
            super(name);
        }

        public NamedScope valueOf(DependencyRule rule) {
            return rule.getFromScope();
        }

        @Override
        public void setValue(DependencyRule rule, NamedScope set) {
            rule.setFromScope(set);
        }
    }

    public abstract class MyColumnInfo
    extends ColumnInfo<DependencyRule, NamedScope> {
        protected MyColumnInfo(String name) {
            super(name);
        }

        public boolean isCellEditable(DependencyRule rule) {
            return true;
        }

        public TableCellRenderer getRenderer(DependencyRule rule) {
            return CELL_RENDERER;
        }

        public TableCellEditor getEditor(DependencyRule packageSetDependencyRule) {
            return new AbstractTableCellEditor(){
                private PackageSetChooserCombo myCombo;

                public Object getCellEditorValue() {
                    return this.myCombo.getSelectedScope();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    this.myCombo = new PackageSetChooserCombo(DependencyConfigurable.this.myProject, value == null ? null : ((NamedScope)value).getName());
                    return new CellEditorComponentWithBrowseButton<JComponent>(this.myCombo, (TableCellEditor)((Object)this));
                }
            };
        }

        public abstract void setValue(DependencyRule var1, NamedScope var2);
    }
}

