/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.ContentBasedFileSubstitutor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClassFileDecompilers;
import org.jetbrains.annotations.NotNull;

public class ClassFileViewProviderFactory
implements FileViewProviderFactory {
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, Language language, @NotNull PsiManager manager, boolean eventSystemEnabled) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/ClassFileViewProviderFactory", "createFileViewProvider"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/ClassFileViewProviderFactory", "createFileViewProvider"));
        }
        ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find((VirtualFile)file);
        if (decompiler instanceof ClassFileDecompilers.Full) {
            FileViewProvider fileViewProvider = ((ClassFileDecompilers.Full)decompiler).createFileViewProvider(file, manager, eventSystemEnabled);
            if (fileViewProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ClassFileViewProviderFactory", "createFileViewProvider"));
            }
            return fileViewProvider;
        }
        for (ContentBasedFileSubstitutor processor : (ContentBasedFileSubstitutor[])Extensions.getExtensions((ExtensionPointName)ContentBasedFileSubstitutor.EP_NAME)) {
            Language lang = processor.obtainLanguageForFile(file);
            if (lang == null) continue;
            FileViewProviderFactory factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
            FileViewProvider fileViewProvider = factory.createFileViewProvider(file, language, manager, eventSystemEnabled);
            if (fileViewProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ClassFileViewProviderFactory", "createFileViewProvider"));
            }
            return fileViewProvider;
        }
        ClassFileViewProvider classFileViewProvider = new ClassFileViewProvider(manager, file, eventSystemEnabled);
        if (classFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ClassFileViewProviderFactory", "createFileViewProvider"));
        }
        return classFileViewProvider;
    }
}

