/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.psi.codeStyle.autodetect.LineIndentInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineIndentInfoBuilder {
    private static final int MAX_LINES_TO_PROCESS = 500;
    private final CharSequence myText;
    private final int myLength;
    private final Commenter myCommenter;

    public LineIndentInfoBuilder(@NotNull CharSequence text, @Nullable Language language) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/codeStyle/autodetect/LineIndentInfoBuilder", "<init>"));
        }
        this.myText = text;
        this.myLength = text.length();
        this.myCommenter = language != null ? (Commenter)LanguageCommenters.INSTANCE.forLanguage(language) : null;
    }

    @NotNull
    public List<LineIndentInfo> build() {
        ArrayList lineIndentInfos = ContainerUtil.newArrayList();
        int lineStartOffset = 0;
        for (int currentLine = 0; lineStartOffset < this.myText.length() && currentLine < 500; ++currentLine) {
            int lineEndOffset = this.getLineEndOffset(lineStartOffset);
            int textStartOffset = CharArrayUtil.shiftForward((CharSequence)this.myText, (int)lineStartOffset, (int)lineEndOffset, (String)" \t");
            if (textStartOffset != lineEndOffset) {
                lineIndentInfos.add(this.createInfoFromWhiteSpaceRange(lineStartOffset, textStartOffset));
            } else {
                lineIndentInfos.add(LineIndentInfo.EMPTY_LINE);
            }
            lineStartOffset = lineEndOffset + 1;
        }
        ArrayList arrayList = lineIndentInfos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/LineIndentInfoBuilder", "build"));
        }
        return arrayList;
    }

    @NotNull
    private LineIndentInfo createInfoFromWhiteSpaceRange(int lineStartOffset, int textStartOffset) {
        if (this.startsWithComment(textStartOffset)) {
            LineIndentInfo lineIndentInfo = LineIndentInfo.LINE_WITH_COMMENT;
            if (lineIndentInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/LineIndentInfoBuilder", "createInfoFromWhiteSpaceRange"));
            }
            return lineIndentInfo;
        }
        if (CharArrayUtil.indexOf((CharSequence)this.myText, (CharSequence)"\t", (int)lineStartOffset, (int)textStartOffset) > 0) {
            LineIndentInfo lineIndentInfo = LineIndentInfo.LINE_WITH_TABS;
            if (lineIndentInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/LineIndentInfoBuilder", "createInfoFromWhiteSpaceRange"));
            }
            return lineIndentInfo;
        }
        int indentSize = textStartOffset - lineStartOffset;
        LineIndentInfo lineIndentInfo = LineIndentInfo.newWhiteSpaceIndent(indentSize);
        if (lineIndentInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/LineIndentInfoBuilder", "createInfoFromWhiteSpaceRange"));
        }
        return lineIndentInfo;
    }

    private boolean startsWithComment(int textStartOffset) {
        return this.myText.charAt(textStartOffset) == '*' || this.startsWithLineComment(textStartOffset);
    }

    private boolean startsWithLineComment(int textStartOffset) {
        if (this.myCommenter == null) {
            return false;
        }
        String lineCommentPrefix = this.myCommenter.getLineCommentPrefix();
        return lineCommentPrefix != null && CharArrayUtil.regionMatches((CharSequence)this.myText, (int)textStartOffset, (CharSequence)lineCommentPrefix);
    }

    private int getLineEndOffset(int lineStartOffset) {
        int lineEndOffset = CharArrayUtil.indexOf((CharSequence)this.myText, (CharSequence)"\n", (int)lineStartOffset, (int)this.myLength);
        if (lineEndOffset < 0) {
            lineEndOffset = this.myText.length();
        }
        return lineEndOffset;
    }
}

